/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1beta1CSINodeDriver;
import io.kubernetes.client.openapi.models.V1beta1CSINodeDriverFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1beta1CSINodeDriverFluentImpl<A extends V1beta1CSINodeDriverFluent<A>>
extends BaseFluent<A>
implements V1beta1CSINodeDriverFluent<A> {
    private String name;
    private String nodeID;
    private List<String> topologyKeys;

    public V1beta1CSINodeDriverFluentImpl() {
    }

    public V1beta1CSINodeDriverFluentImpl(V1beta1CSINodeDriver instance) {
        this.withName(instance.getName());
        this.withNodeID(instance.getNodeID());
        this.withTopologyKeys(instance.getTopologyKeys());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public A withNodeID(String nodeID) {
        this.nodeID = nodeID;
        return (A)this;
    }

    @Override
    public Boolean hasNodeID() {
        return this.nodeID != null;
    }

    @Override
    public A withNewNodeID(String arg1) {
        return this.withNodeID(new String(arg1));
    }

    @Override
    public A withNewNodeID(StringBuilder arg1) {
        return this.withNodeID(new String(arg1));
    }

    @Override
    public A withNewNodeID(StringBuffer arg1) {
        return this.withNodeID(new String(arg1));
    }

    @Override
    public A addToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologyKeys(String ... items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologyKeys(Collection<String> items) {
        for (String item : items) {
            if (this.topologyKeys == null) continue;
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    @Override
    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    @Override
    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    @Override
    public String getLastTopologyKey() {
        return this.topologyKeys.get(this.topologyKeys.size() - 1);
    }

    @Override
    public String getMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologyKeys(List<String> topologyKeys) {
        if (this.topologyKeys != null) {
            this._visitables.get("topologyKeys").removeAll(this.topologyKeys);
        }
        if (topologyKeys != null) {
            this.topologyKeys = new ArrayList<String>();
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        } else {
            this.topologyKeys = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologyKeys(String ... topologyKeys) {
        if (this.topologyKeys != null) {
            this.topologyKeys.clear();
        }
        if (topologyKeys != null) {
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKeys() {
        return this.topologyKeys != null && !this.topologyKeys.isEmpty();
    }

    @Override
    public A addNewTopologyKey(String arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    @Override
    public A addNewTopologyKey(StringBuilder arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    @Override
    public A addNewTopologyKey(StringBuffer arg1) {
        return this.addToTopologyKeys(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CSINodeDriverFluentImpl that = (V1beta1CSINodeDriverFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nodeID != null ? !this.nodeID.equals(that.nodeID) : that.nodeID != null) {
            return false;
        }
        return !(this.topologyKeys != null ? !this.topologyKeys.equals(that.topologyKeys) : that.topologyKeys != null);
    }
}

