/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).")
public class V2beta1PodsMetricStatus {
    public static final String SERIALIZED_NAME_CURRENT_AVERAGE_VALUE = "currentAverageValue";
    @SerializedName(value="currentAverageValue")
    private Quantity currentAverageValue;
    public static final String SERIALIZED_NAME_METRIC_NAME = "metricName";
    @SerializedName(value="metricName")
    private String metricName;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;

    public V2beta1PodsMetricStatus currentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and Int64() accessors.  The serialization format is:  <quantity>        ::= <signedNumber><suffix>   (Note that <suffix> may be empty, from the \"\" case in <decimalSI>.) <digit>           ::= 0 | 1 | ... | 9 <digits>          ::= <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits> | <digits>. | .<digits> <sign>            ::= \"+\" | \"-\" <signedNumber>    ::= <number> | <sign><number> <suffix>          ::= <binarySI> | <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei   (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html) <decimalSI>       ::= m | \"\" | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.) <decimalExponent> ::= \"e\" <signedNumber> | \"E\" <signedNumber>  No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.  When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.  Before serializing, Quantity will be put in \"canonical form\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:   a. No precision is lost   b. No fractional digits will be emitted   c. The exponent (or suffix) is as large as possible. The sign will be omitted unless the number is negative.  Examples:   1.5 will be serialized as \"1500m\"   1.5Gi will be serialized as \"1536Mi\"  Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.  Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)  This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.")
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public void setCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
    }

    public V2beta1PodsMetricStatus metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of the metric in question")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2beta1PodsMetricStatus selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1PodsMetricStatus v2beta1PodsMetricStatus = (V2beta1PodsMetricStatus)o;
        return Objects.equals(this.currentAverageValue, v2beta1PodsMetricStatus.currentAverageValue) && Objects.equals(this.metricName, v2beta1PodsMetricStatus.metricName) && Objects.equals(this.selector, v2beta1PodsMetricStatus.selector);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.metricName, this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1PodsMetricStatus {\n");
        sb.append("    currentAverageValue: ").append(this.toIndentedString(this.currentAverageValue)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

