/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cert.manager.models.V1beta1CertificateRequestSpecIssuerRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Desired state of the CertificateRequest resource.")
public class V1beta1CertificateRequestSpec {
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private String duration;
    public static final String SERIALIZED_NAME_IS_C_A = "isCA";
    @SerializedName(value="isCA")
    private Boolean isCA;
    public static final String SERIALIZED_NAME_ISSUER_REF = "issuerRef";
    @SerializedName(value="issuerRef")
    private V1beta1CertificateRequestSpecIssuerRef issuerRef;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private byte[] request;
    public static final String SERIALIZED_NAME_USAGES = "usages";
    @SerializedName(value="usages")
    private List<UsagesEnum> usages = null;

    public V1beta1CertificateRequestSpec duration(String duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The requested 'duration' (i.e. lifetime) of the Certificate. This option may be ignored/overridden by some issuer types.")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public V1beta1CertificateRequestSpec isCA(Boolean isCA) {
        this.isCA = isCA;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IsCA will request to mark the certificate as valid for certificate signing when submitting to the issuer. This will automatically add the `cert sign` usage to the list of `usages`.")
    public Boolean getIsCA() {
        return this.isCA;
    }

    public void setIsCA(Boolean isCA) {
        this.isCA = isCA;
    }

    public V1beta1CertificateRequestSpec issuerRef(V1beta1CertificateRequestSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1beta1CertificateRequestSpecIssuerRef getIssuerRef() {
        return this.issuerRef;
    }

    public void setIssuerRef(V1beta1CertificateRequestSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
    }

    public V1beta1CertificateRequestSpec request(byte[] request) {
        this.request = request;
        return this;
    }

    @ApiModelProperty(required=true, value="The PEM-encoded x509 certificate signing request to be submitted to the CA for signing.")
    public byte[] getRequest() {
        return this.request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public V1beta1CertificateRequestSpec usages(List<UsagesEnum> usages) {
        this.usages = usages;
        return this;
    }

    public V1beta1CertificateRequestSpec addUsagesItem(UsagesEnum usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<UsagesEnum>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Usages is the set of x509 usages that are requested for the certificate. Defaults to `digital signature` and `key encipherment` if not specified.")
    public List<UsagesEnum> getUsages() {
        return this.usages;
    }

    public void setUsages(List<UsagesEnum> usages) {
        this.usages = usages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateRequestSpec v1beta1CertificateRequestSpec = (V1beta1CertificateRequestSpec)o;
        return Objects.equals(this.duration, v1beta1CertificateRequestSpec.duration) && Objects.equals(this.isCA, v1beta1CertificateRequestSpec.isCA) && Objects.equals(this.issuerRef, v1beta1CertificateRequestSpec.issuerRef) && Arrays.equals(this.request, v1beta1CertificateRequestSpec.request) && Objects.equals(this.usages, v1beta1CertificateRequestSpec.usages);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.isCA, this.issuerRef, Arrays.hashCode(this.request), this.usages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateRequestSpec {\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    isCA: ").append(this.toIndentedString(this.isCA)).append("\n");
        sb.append("    issuerRef: ").append(this.toIndentedString(this.issuerRef)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UsagesEnum {
        SIGNING("signing"),
        DIGITAL_SIGNATURE("digital signature"),
        CONTENT_COMMITMENT("content commitment"),
        KEY_ENCIPHERMENT("key encipherment"),
        KEY_AGREEMENT("key agreement"),
        DATA_ENCIPHERMENT("data encipherment"),
        CERT_SIGN("cert sign"),
        CRL_SIGN("crl sign"),
        ENCIPHER_ONLY("encipher only"),
        DECIPHER_ONLY("decipher only"),
        ANY("any"),
        SERVER_AUTH("server auth"),
        CLIENT_AUTH("client auth"),
        CODE_SIGNING("code signing"),
        EMAIL_PROTECTION("email protection"),
        S_MIME("s/mime"),
        IPSEC_END_SYSTEM("ipsec end system"),
        IPSEC_TUNNEL("ipsec tunnel"),
        IPSEC_USER("ipsec user"),
        TIMESTAMPING("timestamping"),
        OCSP_SIGNING("ocsp signing"),
        MICROSOFT_SGC("microsoft sgc"),
        NETSCAPE_SGC("netscape sgc");

        private String value;

        private UsagesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UsagesEnum fromValue(String value) {
            for (UsagesEnum b : UsagesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<UsagesEnum> {
            public void write(JsonWriter jsonWriter, UsagesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UsagesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UsagesEnum.fromValue(value);
            }
        }
    }
}

