/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecAcmeDns01Rfc2136TsigSecretSecretRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use RFC2136 (\"Dynamic Updates in the Domain Name System\") (https://datatracker.ietf.org/doc/rfc2136/) to manage DNS01 challenge records.")
public class V1alpha2IssuerSpecAcmeDns01Rfc2136 {
    public static final String SERIALIZED_NAME_NAMESERVER = "nameserver";
    @SerializedName(value="nameserver")
    private String nameserver;
    public static final String SERIALIZED_NAME_TSIG_ALGORITHM = "tsigAlgorithm";
    @SerializedName(value="tsigAlgorithm")
    private String tsigAlgorithm;
    public static final String SERIALIZED_NAME_TSIG_KEY_NAME = "tsigKeyName";
    @SerializedName(value="tsigKeyName")
    private String tsigKeyName;
    public static final String SERIALIZED_NAME_TSIG_SECRET_SECRET_REF = "tsigSecretSecretRef";
    @SerializedName(value="tsigSecretSecretRef")
    private V1alpha2IssuerSpecAcmeDns01Rfc2136TsigSecretSecretRef tsigSecretSecretRef;

    public V1alpha2IssuerSpecAcmeDns01Rfc2136 nameserver(String nameserver) {
        this.nameserver = nameserver;
        return this;
    }

    @ApiModelProperty(required=true, value="The IP address or hostname of an authoritative DNS server supporting RFC2136 in the form host:port. If the host is an IPv6 address it must be enclosed in square brackets (e.g [2001:db8::1])\u00a0; port is optional. This field is required.")
    public String getNameserver() {
        return this.nameserver;
    }

    public void setNameserver(String nameserver) {
        this.nameserver = nameserver;
    }

    public V1alpha2IssuerSpecAcmeDns01Rfc2136 tsigAlgorithm(String tsigAlgorithm) {
        this.tsigAlgorithm = tsigAlgorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The TSIG Algorithm configured in the DNS supporting RFC2136. Used only when ``tsigSecretSecretRef`` and ``tsigKeyName`` are defined. Supported values are (case-insensitive): ``HMACMD5`` (default), ``HMACSHA1``, ``HMACSHA256`` or ``HMACSHA512``.")
    public String getTsigAlgorithm() {
        return this.tsigAlgorithm;
    }

    public void setTsigAlgorithm(String tsigAlgorithm) {
        this.tsigAlgorithm = tsigAlgorithm;
    }

    public V1alpha2IssuerSpecAcmeDns01Rfc2136 tsigKeyName(String tsigKeyName) {
        this.tsigKeyName = tsigKeyName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The TSIG Key name configured in the DNS. If ``tsigSecretSecretRef`` is defined, this field is required.")
    public String getTsigKeyName() {
        return this.tsigKeyName;
    }

    public void setTsigKeyName(String tsigKeyName) {
        this.tsigKeyName = tsigKeyName;
    }

    public V1alpha2IssuerSpecAcmeDns01Rfc2136 tsigSecretSecretRef(V1alpha2IssuerSpecAcmeDns01Rfc2136TsigSecretSecretRef tsigSecretSecretRef) {
        this.tsigSecretSecretRef = tsigSecretSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2IssuerSpecAcmeDns01Rfc2136TsigSecretSecretRef getTsigSecretSecretRef() {
        return this.tsigSecretSecretRef;
    }

    public void setTsigSecretSecretRef(V1alpha2IssuerSpecAcmeDns01Rfc2136TsigSecretSecretRef tsigSecretSecretRef) {
        this.tsigSecretSecretRef = tsigSecretSecretRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecAcmeDns01Rfc2136 v1alpha2IssuerSpecAcmeDns01Rfc2136 = (V1alpha2IssuerSpecAcmeDns01Rfc2136)o;
        return Objects.equals(this.nameserver, v1alpha2IssuerSpecAcmeDns01Rfc2136.nameserver) && Objects.equals(this.tsigAlgorithm, v1alpha2IssuerSpecAcmeDns01Rfc2136.tsigAlgorithm) && Objects.equals(this.tsigKeyName, v1alpha2IssuerSpecAcmeDns01Rfc2136.tsigKeyName) && Objects.equals(this.tsigSecretSecretRef, v1alpha2IssuerSpecAcmeDns01Rfc2136.tsigSecretSecretRef);
    }

    public int hashCode() {
        return Objects.hash(this.nameserver, this.tsigAlgorithm, this.tsigKeyName, this.tsigSecretSecretRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecAcmeDns01Rfc2136 {\n");
        sb.append("    nameserver: ").append(this.toIndentedString(this.nameserver)).append("\n");
        sb.append("    tsigAlgorithm: ").append(this.toIndentedString(this.tsigAlgorithm)).append("\n");
        sb.append("    tsigKeyName: ").append(this.toIndentedString(this.tsigKeyName)).append("\n");
        sb.append("    tsigSecretSecretRef: ").append(this.toIndentedString(this.tsigSecretSecretRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

