/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ACME specific status options. This field should only be set if the Issuer is configured to use an ACME server to issue certificates.")
public class V1alpha2IssuerStatusAcme {
    public static final String SERIALIZED_NAME_LAST_REGISTERED_EMAIL = "lastRegisteredEmail";
    @SerializedName(value="lastRegisteredEmail")
    private String lastRegisteredEmail;
    public static final String SERIALIZED_NAME_URI = "uri";
    @SerializedName(value="uri")
    private String uri;

    public V1alpha2IssuerStatusAcme lastRegisteredEmail(String lastRegisteredEmail) {
        this.lastRegisteredEmail = lastRegisteredEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LastRegisteredEmail is the email associated with the latest registered ACME account, in order to track changes made to registered account associated with the  Issuer")
    public String getLastRegisteredEmail() {
        return this.lastRegisteredEmail;
    }

    public void setLastRegisteredEmail(String lastRegisteredEmail) {
        this.lastRegisteredEmail = lastRegisteredEmail;
    }

    public V1alpha2IssuerStatusAcme uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URI is the unique account identifier, which can also be used to retrieve account details from the CA")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerStatusAcme v1alpha2IssuerStatusAcme = (V1alpha2IssuerStatusAcme)o;
        return Objects.equals(this.lastRegisteredEmail, v1alpha2IssuerStatusAcme.lastRegisteredEmail) && Objects.equals(this.uri, v1alpha2IssuerStatusAcme.uri);
    }

    public int hashCode() {
        return Objects.hash(this.lastRegisteredEmail, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerStatusAcme {\n");
        sb.append("    lastRegisteredEmail: ").append(this.toIndentedString(this.lastRegisteredEmail)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

