/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1beta1CertificateRequestStatusConditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ApiModel(description="Status of the CertificateRequest. This is set and managed automatically.")
public class V1beta1CertificateRequestStatus {
    public static final String SERIALIZED_NAME_CA = "ca";
    @SerializedName(value="ca")
    private byte[] ca;
    public static final String SERIALIZED_NAME_CERTIFICATE = "certificate";
    @SerializedName(value="certificate")
    private byte[] certificate;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1beta1CertificateRequestStatusConditions> conditions = null;
    public static final String SERIALIZED_NAME_FAILURE_TIME = "failureTime";
    @SerializedName(value="failureTime")
    private DateTime failureTime;

    public V1beta1CertificateRequestStatus ca(byte[] ca) {
        this.ca = ca;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The PEM encoded x509 certificate of the signer, also known as the CA (Certificate Authority). This is set on a best-effort basis by different issuers. If not set, the CA is assumed to be unknown/not available.")
    public byte[] getCa() {
        return this.ca;
    }

    public void setCa(byte[] ca) {
        this.ca = ca;
    }

    public V1beta1CertificateRequestStatus certificate(byte[] certificate) {
        this.certificate = certificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The PEM encoded x509 certificate resulting from the certificate signing request. If not set, the CertificateRequest has either not been completed or has failed. More information on failure can be found by checking the `conditions` field.")
    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public V1beta1CertificateRequestStatus conditions(List<V1beta1CertificateRequestStatusConditions> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1beta1CertificateRequestStatus addConditionsItem(V1beta1CertificateRequestStatusConditions conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1CertificateRequestStatusConditions>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of status conditions to indicate the status of a CertificateRequest. Known condition types are `Ready` and `InvalidRequest`.")
    public List<V1beta1CertificateRequestStatusConditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1beta1CertificateRequestStatusConditions> conditions) {
        this.conditions = conditions;
    }

    public V1beta1CertificateRequestStatus failureTime(DateTime failureTime) {
        this.failureTime = failureTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FailureTime stores the time that this CertificateRequest failed. This is used to influence garbage collection and back-off.")
    public DateTime getFailureTime() {
        return this.failureTime;
    }

    public void setFailureTime(DateTime failureTime) {
        this.failureTime = failureTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateRequestStatus v1beta1CertificateRequestStatus = (V1beta1CertificateRequestStatus)o;
        return Arrays.equals(this.ca, v1beta1CertificateRequestStatus.ca) && Arrays.equals(this.certificate, v1beta1CertificateRequestStatus.certificate) && Objects.equals(this.conditions, v1beta1CertificateRequestStatus.conditions) && Objects.equals(this.failureTime, v1beta1CertificateRequestStatus.failureTime);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.ca), Arrays.hashCode(this.certificate), this.conditions, this.failureTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateRequestStatus {\n");
        sb.append("    ca: ").append(this.toIndentedString(this.ca)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    failureTime: ").append(this.toIndentedString(this.failureTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

