/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecAcmeExternalAccountBinding;
import io.cert.manager.models.V1alpha2IssuerSpecAcmePrivateKeySecretRef;
import io.cert.manager.models.V1beta1IssuerSpecAcmeSolvers;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ACME configures this issuer to communicate with a RFC8555 (ACME) server to obtain signed x509 certificates.")
public class V1beta1IssuerSpecAcme {
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_EXTERNAL_ACCOUNT_BINDING = "externalAccountBinding";
    @SerializedName(value="externalAccountBinding")
    private V1alpha2IssuerSpecAcmeExternalAccountBinding externalAccountBinding;
    public static final String SERIALIZED_NAME_PRIVATE_KEY_SECRET_REF = "privateKeySecretRef";
    @SerializedName(value="privateKeySecretRef")
    private V1alpha2IssuerSpecAcmePrivateKeySecretRef privateKeySecretRef;
    public static final String SERIALIZED_NAME_SERVER = "server";
    @SerializedName(value="server")
    private String server;
    public static final String SERIALIZED_NAME_SKIP_T_L_S_VERIFY = "skipTLSVerify";
    @SerializedName(value="skipTLSVerify")
    private Boolean skipTLSVerify;
    public static final String SERIALIZED_NAME_SOLVERS = "solvers";
    @SerializedName(value="solvers")
    private List<V1beta1IssuerSpecAcmeSolvers> solvers = null;

    public V1beta1IssuerSpecAcme email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Email is the email address to be associated with the ACME account. This field is optional, but it is strongly recommended to be set. It will be used to contact you in case of issues with your account or certificates, including expiry notification emails. This field may be updated after the account is initially registered.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public V1beta1IssuerSpecAcme externalAccountBinding(V1alpha2IssuerSpecAcmeExternalAccountBinding externalAccountBinding) {
        this.externalAccountBinding = externalAccountBinding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha2IssuerSpecAcmeExternalAccountBinding getExternalAccountBinding() {
        return this.externalAccountBinding;
    }

    public void setExternalAccountBinding(V1alpha2IssuerSpecAcmeExternalAccountBinding externalAccountBinding) {
        this.externalAccountBinding = externalAccountBinding;
    }

    public V1beta1IssuerSpecAcme privateKeySecretRef(V1alpha2IssuerSpecAcmePrivateKeySecretRef privateKeySecretRef) {
        this.privateKeySecretRef = privateKeySecretRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha2IssuerSpecAcmePrivateKeySecretRef getPrivateKeySecretRef() {
        return this.privateKeySecretRef;
    }

    public void setPrivateKeySecretRef(V1alpha2IssuerSpecAcmePrivateKeySecretRef privateKeySecretRef) {
        this.privateKeySecretRef = privateKeySecretRef;
    }

    public V1beta1IssuerSpecAcme server(String server) {
        this.server = server;
        return this;
    }

    @ApiModelProperty(required=true, value="Server is the URL used to access the ACME server's 'directory' endpoint. For example, for Let's Encrypt's staging endpoint, you would use: \"https://acme-staging-v02.api.letsencrypt.org/directory\". Only ACME v2 endpoints (i.e. RFC 8555) are supported.")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public V1beta1IssuerSpecAcme skipTLSVerify(Boolean skipTLSVerify) {
        this.skipTLSVerify = skipTLSVerify;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Enables or disables validation of the ACME server TLS certificate. If true, requests to the ACME server will not have their TLS certificate validated (i.e. insecure connections will be allowed). Only enable this option in development environments. The cert-manager system installed roots will be used to verify connections to the ACME server if this is false. Defaults to false.")
    public Boolean getSkipTLSVerify() {
        return this.skipTLSVerify;
    }

    public void setSkipTLSVerify(Boolean skipTLSVerify) {
        this.skipTLSVerify = skipTLSVerify;
    }

    public V1beta1IssuerSpecAcme solvers(List<V1beta1IssuerSpecAcmeSolvers> solvers) {
        this.solvers = solvers;
        return this;
    }

    public V1beta1IssuerSpecAcme addSolversItem(V1beta1IssuerSpecAcmeSolvers solversItem) {
        if (this.solvers == null) {
            this.solvers = new ArrayList<V1beta1IssuerSpecAcmeSolvers>();
        }
        this.solvers.add(solversItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Solvers is a list of challenge solvers that will be used to solve ACME challenges for the matching domains. Solver configurations must be provided in order to obtain certificates from an ACME server. For more information, see: https://cert-manager.io/docs/configuration/acme/")
    public List<V1beta1IssuerSpecAcmeSolvers> getSolvers() {
        return this.solvers;
    }

    public void setSolvers(List<V1beta1IssuerSpecAcmeSolvers> solvers) {
        this.solvers = solvers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1IssuerSpecAcme v1beta1IssuerSpecAcme = (V1beta1IssuerSpecAcme)o;
        return Objects.equals(this.email, v1beta1IssuerSpecAcme.email) && Objects.equals(this.externalAccountBinding, v1beta1IssuerSpecAcme.externalAccountBinding) && Objects.equals(this.privateKeySecretRef, v1beta1IssuerSpecAcme.privateKeySecretRef) && Objects.equals(this.server, v1beta1IssuerSpecAcme.server) && Objects.equals(this.skipTLSVerify, v1beta1IssuerSpecAcme.skipTLSVerify) && Objects.equals(this.solvers, v1beta1IssuerSpecAcme.solvers);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.externalAccountBinding, this.privateKeySecretRef, this.server, this.skipTLSVerify, this.solvers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1IssuerSpecAcme {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    externalAccountBinding: ").append(this.toIndentedString(this.externalAccountBinding)).append("\n");
        sb.append("    privateKeySecretRef: ").append(this.toIndentedString(this.privateKeySecretRef)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("    skipTLSVerify: ").append(this.toIndentedString(this.skipTLSVerify)).append("\n");
        sb.append("    solvers: ").append(this.toIndentedString(this.solvers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

