/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class V1alpha3ChallengeStatus {
    public static final String SERIALIZED_NAME_PRESENTED = "presented";
    @SerializedName(value="presented")
    private Boolean presented;
    public static final String SERIALIZED_NAME_PROCESSING = "processing";
    @SerializedName(value="processing")
    private Boolean processing;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;

    public V1alpha3ChallengeStatus presented(Boolean presented) {
        this.presented = presented;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Presented will be set to true if the challenge values for this challenge are currently 'presented'. This *does not* imply the self check is passing. Only that the values have been 'submitted' for the appropriate challenge mechanism (i.e. the DNS01 TXT record has been presented, or the HTTP01 configuration has been configured).")
    public Boolean getPresented() {
        return this.presented;
    }

    public void setPresented(Boolean presented) {
        this.presented = presented;
    }

    public V1alpha3ChallengeStatus processing(Boolean processing) {
        this.processing = processing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Processing is used to denote whether this challenge should be processed or not. This field will only be set to true by the 'scheduling' component. It will only be set to false by the 'challenges' controller, after the challenge has reached a final state or timed out. If this field is set to false, the challenge controller will not take any more action.")
    public Boolean getProcessing() {
        return this.processing;
    }

    public void setProcessing(Boolean processing) {
        this.processing = processing;
    }

    public V1alpha3ChallengeStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason contains human readable information on why the Challenge is in the current state.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1alpha3ChallengeStatus state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State contains the current 'state' of the challenge. If not set, the state of the challenge is unknown.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ChallengeStatus v1alpha3ChallengeStatus = (V1alpha3ChallengeStatus)o;
        return Objects.equals(this.presented, v1alpha3ChallengeStatus.presented) && Objects.equals(this.processing, v1alpha3ChallengeStatus.processing) && Objects.equals(this.reason, v1alpha3ChallengeStatus.reason) && Objects.equals((Object)this.state, (Object)v1alpha3ChallengeStatus.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.presented, this.processing, this.reason, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ChallengeStatus {\n");
        sb.append("    presented: ").append(this.toIndentedString(this.presented)).append("\n");
        sb.append("    processing: ").append(this.toIndentedString(this.processing)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        VALID("valid"),
        READY("ready"),
        PENDING("pending"),
        PROCESSING("processing"),
        INVALID("invalid"),
        EXPIRED("expired"),
        ERRORED("errored");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

