/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options to control private keys used for the Certificate.")
public class V1beta1CertificateSpecPrivateKey {
    public static final String SERIALIZED_NAME_ALGORITHM = "algorithm";
    @SerializedName(value="algorithm")
    private AlgorithmEnum algorithm;
    public static final String SERIALIZED_NAME_ENCODING = "encoding";
    @SerializedName(value="encoding")
    private EncodingEnum encoding;
    public static final String SERIALIZED_NAME_ROTATION_POLICY = "rotationPolicy";
    @SerializedName(value="rotationPolicy")
    private String rotationPolicy;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private Integer size;

    public V1beta1CertificateSpecPrivateKey algorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Algorithm is the private key algorithm of the corresponding private key for this certificate. If provided, allowed values are either \"rsa\" or \"ecdsa\" If `algorithm` is specified and `size` is not provided, key size of 256 will be used for \"ecdsa\" key algorithm and key size of 2048 will be used for \"rsa\" key algorithm.")
    public AlgorithmEnum getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
    }

    public V1beta1CertificateSpecPrivateKey encoding(EncodingEnum encoding) {
        this.encoding = encoding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The private key cryptography standards (PKCS) encoding for this certificate's private key to be encoded in. If provided, allowed values are \"pkcs1\" and \"pkcs8\" standing for PKCS#1 and PKCS#8, respectively. Defaults to PKCS#1 if not specified.")
    public EncodingEnum getEncoding() {
        return this.encoding;
    }

    public void setEncoding(EncodingEnum encoding) {
        this.encoding = encoding;
    }

    public V1beta1CertificateSpecPrivateKey rotationPolicy(String rotationPolicy) {
        this.rotationPolicy = rotationPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RotationPolicy controls how private keys should be regenerated when a re-issuance is being processed. If set to Never, a private key will only be generated if one does not already exist in the target `spec.secretName`. If one does exists but it does not have the correct algorithm or size, a warning will be raised to await user intervention. If set to Always, a private key matching the specified requirements will be generated whenever a re-issuance occurs. Default is 'Never' for backward compatibility.")
    public String getRotationPolicy() {
        return this.rotationPolicy;
    }

    public void setRotationPolicy(String rotationPolicy) {
        this.rotationPolicy = rotationPolicy;
    }

    public V1beta1CertificateSpecPrivateKey size(Integer size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size is the key bit size of the corresponding private key for this certificate. If `algorithm` is set to `RSA`, valid values are `2048`, `4096` or `8192`, and will default to `2048` if not specified. If `algorithm` is set to `ECDSA`, valid values are `256`, `384` or `521`, and will default to `256` if not specified. No other values are allowed.")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateSpecPrivateKey v1beta1CertificateSpecPrivateKey = (V1beta1CertificateSpecPrivateKey)o;
        return Objects.equals((Object)this.algorithm, (Object)v1beta1CertificateSpecPrivateKey.algorithm) && Objects.equals((Object)this.encoding, (Object)v1beta1CertificateSpecPrivateKey.encoding) && Objects.equals(this.rotationPolicy, v1beta1CertificateSpecPrivateKey.rotationPolicy) && Objects.equals(this.size, v1beta1CertificateSpecPrivateKey.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.encoding, this.rotationPolicy, this.size});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateSpecPrivateKey {\n");
        sb.append("    algorithm: ").append(this.toIndentedString((Object)this.algorithm)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString((Object)this.encoding)).append("\n");
        sb.append("    rotationPolicy: ").append(this.toIndentedString(this.rotationPolicy)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EncodingEnum {
        PKCS1("PKCS1"),
        PKCS8("PKCS8");

        private String value;

        private EncodingEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EncodingEnum fromValue(String value) {
            for (EncodingEnum b : EncodingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EncodingEnum> {
            public void write(JsonWriter jsonWriter, EncodingEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EncodingEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EncodingEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AlgorithmEnum {
        RSA("RSA"),
        ECDSA("ECDSA");

        private String value;

        private AlgorithmEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AlgorithmEnum fromValue(String value) {
            for (AlgorithmEnum b : AlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AlgorithmEnum> {
            public void write(JsonWriter jsonWriter, AlgorithmEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AlgorithmEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AlgorithmEnum.fromValue(value);
            }
        }
    }
}

