/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.controller;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controllers {
    private static final Logger log = LoggerFactory.getLogger(Controllers.class);

    public static <ApiType extends KubernetesObject> Function<ApiType, Request> defaultReflectiveKeyFunc() {
        return obj -> {
            V1ObjectMeta objectMeta = obj.getMetadata();
            return new Request(objectMeta.getNamespace(), objectMeta.getName());
        };
    }

    public static ThreadFactory namedControllerThreadFactory(String controllerName) {
        return new ThreadFactoryBuilder().setNameFormat(controllerName + "-%d").build();
    }
}

