/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.event.legacy;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.extended.event.legacy.EventBroadcaster;
import io.kubernetes.client.extended.event.legacy.EventCorrelator;
import io.kubernetes.client.extended.event.legacy.EventRecorder;
import io.kubernetes.client.extended.event.legacy.EventSink;
import io.kubernetes.client.extended.event.legacy.ObjectReferenceResolvingEventRecorder;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Event;
import io.kubernetes.client.openapi.models.V1EventBuilder;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.util.PatchUtils;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyEventBroadcaster
implements EventBroadcaster {
    private static final Logger logger = LoggerFactory.getLogger(LegacyEventBroadcaster.class);
    private static final int maxTriesPerEvent = 10;
    private BlockingQueue<V1Event> pendingEventQueue = new LinkedBlockingQueue<V1Event>();
    private ExecutorService eventProcessingWorker = Executors.newSingleThreadExecutor();
    private EventSink eventSink;
    private EventCorrelator eventCorrelator;
    private Duration sleepDuration;
    private boolean shuttingDown;

    public LegacyEventBroadcaster(final CoreV1Api coreV1Api) {
        this(new EventCorrelator(), new EventSink(){

            @Override
            public V1Event create(V1Event event) throws ApiException {
                return coreV1Api.createNamespacedEvent(event.getMetadata().getNamespace(), event, null, null, null);
            }

            @Override
            public V1Event update(V1Event event) throws ApiException {
                return coreV1Api.replaceNamespacedEvent(event.getMetadata().getName(), event.getMetadata().getNamespace(), event, null, null, null);
            }

            @Override
            public V1Event patch(V1Event event, V1Patch patch) throws ApiException {
                return (V1Event)PatchUtils.patch(V1Event.class, () -> coreV1Api.patchNamespacedEventCall(event.getMetadata().getName(), event.getMetadata().getNamespace(), patch, null, null, null, null, null), (String)"application/strategic-merge-patch+json", (ApiClient)coreV1Api.getApiClient());
            }
        });
    }

    public LegacyEventBroadcaster(EventCorrelator correlator, EventSink sink) {
        this.eventCorrelator = correlator;
        this.sleepDuration = Duration.ofSeconds(10L);
        this.eventSink = sink;
    }

    @Override
    public EventRecorder newRecorder(V1EventSource eventSource) {
        return new ObjectReferenceResolvingEventRecorder(this.pendingEventQueue, eventSource);
    }

    @Override
    public void startRecording() {
        this.eventProcessingWorker.submit(() -> {
            while (!this.shuttingDown) {
                try {
                    V1Event event = this.pendingEventQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (event == null) continue;
                    this.recordToSink(event);
                }
                catch (InterruptedException e) {
                    logger.info("shutdown signaled");
                }
            }
        });
    }

    @Override
    public void shutdown() {
        this.eventProcessingWorker.shutdown();
        this.shuttingDown = true;
    }

    private void recordToSink(V1Event event) throws InterruptedException {
        Optional<MutablePair<V1Event, V1Patch>> eventAndPatch = this.eventCorrelator.correlate(event);
        if (!eventAndPatch.isPresent()) {
            return;
        }
        V1Event recordingEvent = (V1Event)eventAndPatch.get().getLeft();
        V1Patch patch = (V1Patch)eventAndPatch.get().getRight();
        for (int retries = 0; retries < 10 && !this.recordEvent(recordingEvent, patch, event.getCount() > 1); ++retries) {
            Thread.sleep(this.sleepDuration.toMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean recordEvent(V1Event event, V1Patch patch, boolean updateExistingEvent) {
        block15: {
            V1Event newEvent;
            block14: {
                newEvent = null;
                if (updateExistingEvent) {
                    try {
                        newEvent = this.eventSink.patch(event, patch);
                    }
                    catch (ApiException patchException) {
                        if (patchException.getCode() != 404) break block14;
                        event = new V1EventBuilder(event).build();
                        event.getMetadata().setResourceVersion("");
                        updateExistingEvent = false;
                    }
                }
            }
            if (!updateExistingEvent) {
                try {
                    newEvent = this.eventSink.create(event);
                }
                catch (ApiException e) {
                    if (e.getCode() == 409) {
                        logger.error("event already exists", (Throwable)e);
                        boolean bl = true;
                        if (newEvent != null) {
                            this.eventCorrelator.updateState(newEvent);
                        }
                        return bl;
                    }
                    boolean bl = false;
                    if (newEvent != null) {
                        this.eventCorrelator.updateState(newEvent);
                    }
                    return bl;
                }
            }
            if (newEvent != null) {
                this.eventCorrelator.updateState(newEvent);
            }
            break block15;
            {
                catch (Throwable throwable) {
                    if (newEvent != null) {
                        this.eventCorrelator.updateState(newEvent);
                    }
                    throw throwable;
                }
            }
        }
        return true;
    }
}

