/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.event.legacy;

import com.google.common.base.Strings;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.event.EventType;
import io.kubernetes.client.extended.event.legacy.EventRecorder;
import io.kubernetes.client.extended.event.legacy.EventUtils;
import io.kubernetes.client.openapi.models.V1Event;
import io.kubernetes.client.openapi.models.V1EventBuilder;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReferenceResolvingEventRecorder
implements EventRecorder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectReferenceResolvingEventRecorder.class);
    private BlockingQueue<V1Event> pendingEventQueue;
    private V1EventSource eventSource;

    public ObjectReferenceResolvingEventRecorder(BlockingQueue<V1Event> queue, V1EventSource eventSource) {
        this.pendingEventQueue = queue;
        this.eventSource = eventSource;
    }

    @Override
    public void event(KubernetesObject object, EventType t, String reason, String format, String ... args) {
        this.event(object, new HashMap<String, String>(), t, reason, format, args);
    }

    @Override
    public void event(KubernetesObject object, Map<String, String> attachedAnnotation, EventType t, String reason, String format, String ... args) {
        this.generateEvent(this.constructObjectReference(object), attachedAnnotation, t, reason, String.format(format, args));
    }

    @Override
    public void event(V1ObjectReference ref, EventType t, String reason, String format, String ... args) {
        this.event(ref, new HashMap<String, String>(), t, reason, format, args);
    }

    @Override
    public void event(V1ObjectReference ref, Map<String, String> attachedAnnotation, EventType t, String reason, String format, String ... args) {
        this.generateEvent(ref, attachedAnnotation, t, reason, String.format(format, args));
    }

    private V1ObjectReference constructObjectReference(KubernetesObject eventRefObject) {
        V1ObjectMeta meta = eventRefObject.getMetadata();
        return ((V1ObjectReferenceBuilder)((V1ObjectReferenceBuilder)((V1ObjectReferenceBuilder)((V1ObjectReferenceBuilder)((V1ObjectReferenceBuilder)((V1ObjectReferenceBuilder)new V1ObjectReferenceBuilder().withApiVersion(eventRefObject.getApiVersion())).withKind(eventRefObject.getKind())).withUid(meta.getUid())).withNamespace(meta.getNamespace())).withName(meta.getName())).withResourceVersion(meta.getResourceVersion())).build();
    }

    private void generateEvent(V1ObjectReference eventRef, Map<String, String> annotations, EventType t, String reason, String message) {
        String namespace = eventRef.getNamespace();
        if (Strings.isNullOrEmpty((String)eventRef.getNamespace())) {
            namespace = "default";
        }
        DateTime now = DateTime.now();
        V1Event event = ((V1EventBuilder)((V1EventBuilder)((V1EventBuilder)((V1EventBuilder)((V1EventBuilder)((V1EventBuilder)((V1EventBuilder)((V1EventBuilder)((V1EventBuilder)new V1EventBuilder().withMetadata(((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)new V1ObjectMetaBuilder().withName(EventUtils.generateName(eventRef.getName(), now))).withNamespace(namespace)).withAnnotations(annotations)).build())).withInvolvedObject(eventRef)).withType(t.toString())).withReason(reason)).withMessage(message)).withFirstTimestamp(now)).withLastTimestamp(now)).withSource(this.eventSource)).withCount(Integer.valueOf(1))).build();
        try {
            this.pendingEventQueue.offer(event, 100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("the event queue is full, dropping requesting event upon {}/{}", (Object)eventRef.getNamespace(), (Object)eventRef.getName());
        }
    }
}

