/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.ModelMapper;
import io.kubernetes.client.util.annotations.Annotations;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class KubectlAnnotate<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlAnnotate<ApiType>>
implements Kubectl.Executable<ApiType> {
    private final Map<String, String> addingAnnotations = new HashMap<String, String>();

    KubectlAnnotate(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlAnnotate<ApiType> addAnnotation(String key, String value) {
        this.addingAnnotations.put(key, value);
        return this;
    }

    @Override
    public ApiType execute() throws KubectlException {
        KubernetesObject currentObj;
        this.verifyArguments();
        this.refreshDiscovery();
        if (this.isNamespaced(this.apiTypeClass)) {
            try {
                currentObj = (KubernetesObject)this.getGenericApi().get(this.namespace, this.name).throwsApiException().getObject();
            }
            catch (ApiException e) {
                throw new KubectlException(e);
            }
        }
        try {
            currentObj = (KubernetesObject)this.getGenericApi().get(this.name).throwsApiException().getObject();
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
        Annotations.addAnnotations((KubernetesObject)currentObj, this.addingAnnotations);
        try {
            return (ApiType)((KubernetesObject)this.getGenericApi().update(currentObj).throwsApiException().getObject());
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }

    public boolean isNamespaced(Class<ApiType> apiTypeClass) {
        Boolean isNamespaced = ModelMapper.isNamespaced(apiTypeClass);
        if (isNamespaced == null) {
            return false;
        }
        return isNamespaced != false || !StringUtils.isEmpty((String)this.namespace);
    }

    private void verifyArguments() throws KubectlException {
        if (null == this.name) {
            throw new KubectlException("missing name argument");
        }
    }
}

