/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Node;

public class KubectlCordon
extends Kubectl.ResourceAndContainerBuilder<V1Node, KubectlCordon>
implements Kubectl.Executable<V1Node> {
    static final String CORDON_PATCH_STR = "[{\"op\":\"replace\",\"path\":\"/spec/unschedulable\",\"value\":true}]";
    static String UNCORDON_PATCH_STR = "[{\"op\":\"replace\",\"path\":\"/spec/unschedulable\",\"value\":false}]";
    private boolean cordon;

    KubectlCordon(boolean performCordon) {
        super(V1Node.class);
        this.cordon = performCordon;
    }

    @Override
    public V1Node execute() throws KubectlException {
        return this.performCordon();
    }

    protected V1Node performCordon() throws KubectlException {
        String patch = this.cordon ? CORDON_PATCH_STR : UNCORDON_PATCH_STR;
        try {
            return (V1Node)this.getGenericApi().patch(this.name, "application/json-patch+json", new V1Patch(patch)).throwsApiException().getObject();
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }
}

