/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import com.google.common.io.ByteStreams;
import io.kubernetes.client.Exec;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KubectlExec
extends Kubectl.ResourceAndContainerBuilder<V1Pod, KubectlExec>
implements Kubectl.Executable<Integer> {
    private String[] command;
    private boolean stdin;
    private boolean tty;

    KubectlExec() {
        super(V1Pod.class);
    }

    public KubectlExec command(String[] command) {
        this.command = command;
        return this;
    }

    public KubectlExec stdin(boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    public KubectlExec tty(boolean tty) {
        this.tty = tty;
        return this;
    }

    @Override
    public Integer execute() throws KubectlException {
        V1Pod pod = new V1Pod().metadata(new V1ObjectMeta().name(this.name).namespace(this.namespace));
        Exec exec = new Exec(this.apiClient);
        try {
            Process proc = exec.exec(pod, this.command, this.container, this.stdin, this.tty);
            KubectlExec.copyAsync(proc.getInputStream(), System.out);
            KubectlExec.copyAsync(proc.getErrorStream(), System.err);
            if (this.stdin) {
                KubectlExec.copyAsync(System.in, proc.getOutputStream());
            }
            return proc.waitFor();
        }
        catch (ApiException | IOException | InterruptedException ex) {
            throw new KubectlException(ex);
        }
    }

    protected static Thread copyAsync(final InputStream in, final OutputStream out) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteStreams.copy((InputStream)in, (OutputStream)out);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        t.start();
        return t;
    }
}

