/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import com.google.common.base.Strings;
import io.kubernetes.client.PodLogs;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Pod;
import java.io.IOException;
import java.io.InputStream;

public class KubectlLog
extends Kubectl.ResourceAndContainerBuilder<V1Pod, KubectlLog>
implements Kubectl.Executable<InputStream> {
    KubectlLog() {
        super(V1Pod.class);
    }

    @Override
    public InputStream execute() throws KubectlException {
        this.validate();
        PodLogs logs = new PodLogs(this.apiClient);
        String ns = this.namespace == null ? "default" : this.namespace;
        try {
            return logs.streamNamespacedPodLog(this.name, ns, this.container);
        }
        catch (ApiException | IOException ex) {
            throw new KubectlException(ex);
        }
    }

    private void validate() throws KubectlException {
        StringBuilder msg = new StringBuilder();
        if (Strings.isNullOrEmpty((String)this.name)) {
            msg.append("missing name! ");
        }
        if (Strings.isNullOrEmpty((String)this.container)) {
            msg.append("missing container!");
        }
        if (msg.length() > 0) {
            throw new KubectlException(msg.toString());
        }
    }
}

