/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.ModelMapper;
import io.kubernetes.client.util.generic.options.UpdateOptions;
import org.apache.commons.lang.StringUtils;

public class KubectlReplace<ApiType extends KubernetesObject>
extends Kubectl.ResourceBuilder<ApiType, KubectlReplace<ApiType>>
implements Kubectl.Executable<ApiType> {
    ApiType updateObject;
    UpdateOptions options;

    KubectlReplace(Class<ApiType> apiTypeClass) {
        super(apiTypeClass);
    }

    public KubectlReplace<ApiType> resource(ApiType resource) {
        this.updateObject = resource;
        return this;
    }

    public KubectlReplace<ApiType> options(UpdateOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public ApiType execute() throws KubectlException {
        this.verifyArguments();
        this.refreshDiscovery();
        if (this.isNamespaced(this.apiTypeClass)) {
            try {
                return (ApiType)((KubernetesObject)this.getGenericApi().update(this.updateObject, this.options).throwsApiException().getObject());
            }
            catch (ApiException e) {
                throw new KubectlException(e);
            }
        }
        try {
            return (ApiType)((KubernetesObject)this.getGenericApi().update(this.updateObject, this.options).throwsApiException().getObject());
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }

    public boolean isNamespaced(Class<ApiType> apiTypeClass) {
        Boolean isNamespaced = ModelMapper.isNamespaced(apiTypeClass);
        if (isNamespaced == null) {
            return false;
        }
        return isNamespaced != false || !StringUtils.isEmpty((String)this.namespace);
    }

    private void verifyArguments() throws KubectlException {
        if (null == this.name) {
            throw new KubectlException("missing name argument");
        }
        if (null == this.updateObject) {
            throw new KubectlException("missing new resource");
        }
    }
}

