/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.pager;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.function.Function;
import okhttp3.Call;

public class Pager<ApiType extends KubernetesObject, ApiListType extends KubernetesListObject>
implements Iterable<ApiType> {
    private Integer limit;
    private ApiClient client;
    private Type listType;
    private Function<PagerParams, Call> listFunc;
    private ApiListType listObjectCurrentPage;

    public Pager(Function<PagerParams, Call> listFunc, ApiClient client, Integer limit, Type listType) {
        this.listFunc = listFunc;
        this.client = client;
        this.limit = limit;
        this.listType = listType;
    }

    @Override
    public Iterator<ApiType> iterator() {
        return new PagerIterator();
    }

    private Call getNextCall(Integer nextLimit, String continueToken) {
        PagerParams params = new PagerParams(nextLimit != null ? nextLimit : this.limit, continueToken);
        return this.listFunc.apply(params);
    }

    private ApiListType executeRequest(Call call) throws IOException, ApiException {
        return (ApiListType)((KubernetesListObject)this.client.handleResponse(call.execute(), this.listType));
    }

    private class PagerIterator
    implements Iterator<ApiType> {
        private boolean started;
        private String continueToken;
        private Call call;
        private int offsetCurrentPage;
        private int currentPageSize;

        private PagerIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.started) {
                this.started = true;
                return Boolean.TRUE;
            }
            return this.continueToken != null || this.offsetCurrentPage < this.currentPageSize;
        }

        @Override
        public ApiType next() {
            try {
                if (this.offsetCurrentPage >= this.currentPageSize) {
                    this.call = Pager.this.getNextCall(Pager.this.limit, this.continueToken);
                    Pager.this.listObjectCurrentPage = Pager.this.executeRequest(this.call);
                    this.continueToken = Pager.this.listObjectCurrentPage.getMetadata().getContinue();
                    this.offsetCurrentPage = 0;
                    this.currentPageSize = Pager.this.listObjectCurrentPage.getItems().size();
                }
                return (KubernetesObject)Pager.this.listObjectCurrentPage.getItems().get(this.offsetCurrentPage++);
            }
            catch (ApiException e) {
                throw new RuntimeException(e.getResponseBody());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class PagerParams {
        private String continueToken;
        private Integer limit;

        private PagerParams(Integer limit, String continueToken) {
            this.limit = limit;
            this.continueToken = continueToken;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public String getContinueToken() {
            return this.continueToken;
        }
    }
}

