/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.workqueue;

import com.google.common.primitives.Longs;
import io.kubernetes.client.extended.workqueue.DefaultWorkQueue;
import io.kubernetes.client.extended.workqueue.DelayingQueue;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DefaultDelayingQueue<T>
extends DefaultWorkQueue<T>
implements DelayingQueue<T> {
    public static Duration heartBeatInterval = Duration.ofSeconds(10L);
    private DelayQueue<WaitForEntry<T>> delayQueue = new DelayQueue();
    private ConcurrentMap<T, WaitForEntry<T>> waitingEntryByData = new ConcurrentHashMap<T, WaitForEntry<T>>();
    protected BlockingQueue<WaitForEntry<T>> waitingForAddQueue = new LinkedBlockingQueue<WaitForEntry<T>>(1000);

    public DefaultDelayingQueue(ExecutorService waitingWorker) {
        waitingWorker.submit(this::waitingLoop);
    }

    public DefaultDelayingQueue() {
        this(Executors.newSingleThreadExecutor());
    }

    @Override
    public void addAfter(T item, Duration duration) {
        if (super.isShuttingDown()) {
            return;
        }
        if (duration.isZero()) {
            super.add(item);
            return;
        }
        WaitForEntry entry = new WaitForEntry(item, duration.addTo(Instant.now()));
        this.waitingForAddQueue.offer(entry);
    }

    private void waitingLoop() {
        try {
            while (true) {
                WaitForEntry<T> waitForEntry;
                if (super.isShuttingDown()) {
                    return;
                }
                WaitForEntry entry = (WaitForEntry)this.delayQueue.peek();
                Duration nextReadyAt = heartBeatInterval;
                if (entry != null) {
                    Instant now = Instant.now();
                    if (!Duration.between(entry.readyAtMillis, now).isNegative()) {
                        this.delayQueue.remove(entry);
                        super.add(entry.data);
                        this.waitingEntryByData.remove(entry.data);
                        continue;
                    }
                    nextReadyAt = Duration.between(now, entry.readyAtMillis);
                }
                if ((waitForEntry = this.waitingForAddQueue.poll(nextReadyAt.toMillis(), TimeUnit.MILLISECONDS)) == null) continue;
                if (Duration.between(((WaitForEntry)waitForEntry).readyAtMillis, Instant.now()).isNegative()) {
                    this.insert(this.delayQueue, this.waitingEntryByData, waitForEntry);
                    continue;
                }
                super.add(((WaitForEntry)waitForEntry).data);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void insert(DelayQueue<WaitForEntry<T>> q, Map<T, WaitForEntry<T>> knownEntries, WaitForEntry entry) {
        WaitForEntry<T> existing = knownEntries.get(entry.data);
        if (existing != null) {
            if (Duration.between(((WaitForEntry)existing).readyAtMillis, entry.readyAtMillis).isNegative()) {
                q.remove(existing);
                ((WaitForEntry)existing).readyAtMillis = entry.readyAtMillis;
                q.add(existing);
            }
            return;
        }
        q.offer(entry);
        knownEntries.put(entry.data, entry);
    }

    private class WaitForEntry<T>
    implements Delayed {
        private T data;
        private Temporal readyAtMillis;

        private WaitForEntry(T data, Temporal readyAtMillis) {
            this.data = data;
            this.readyAtMillis = readyAtMillis;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            Duration duration = Duration.between(Instant.now(), this.readyAtMillis);
            return unit.convert(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Longs.compare((long)this.getDelay(TimeUnit.MILLISECONDS), (long)o.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

