/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.kubectl;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import io.kubernetes.client.util.generic.options.ListOptions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KubectlGet<ApiType extends KubernetesObject>
extends Kubectl.ApiClientBuilder<KubectlGet<ApiType>>
implements Kubectl.Executable<List<ApiType>> {
    private String namespace;
    private ListOptions listOptions;
    private Class<ApiType> apiTypeClass;
    private Class<? extends KubernetesListObject> apiTypeListClass;

    KubectlGet(Class<ApiType> apiTypeClass) {
        this.apiTypeClass = apiTypeClass;
        this.listOptions = new ListOptions();
    }

    public KubectlGet<ApiType> apiListTypeClass(Class<? extends KubernetesListObject> apiTypeListClass) {
        this.apiTypeListClass = apiTypeListClass;
        return this;
    }

    public KubectlGet<ApiType> options(ListOptions listOptions) {
        this.listOptions = listOptions;
        return this;
    }

    public KubectlGet<ApiType> namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public KubectlGetSingle name(String name) {
        return new KubectlGetSingle(name);
    }

    @Override
    public List<ApiType> execute() throws KubectlException {
        this.refreshDiscovery();
        GenericKubernetesApi<ApiType, KubernetesListObject> api = this.apiTypeListClass == null ? this.getGenericApi(this.apiTypeClass) : this.getGenericApi(this.apiTypeClass, this.apiTypeListClass);
        try {
            if (this.isNamespaced()) {
                return ((KubernetesListObject)api.list(this.namespace, this.listOptions).throwsApiException().getObject()).getItems();
            }
            return ((KubernetesListObject)api.list(this.listOptions).throwsApiException().getObject()).getItems();
        }
        catch (ApiException e) {
            throw new KubectlException(e);
        }
    }

    private boolean isNamespaced() {
        return !StringUtils.isEmpty((CharSequence)this.namespace);
    }

    public class KubectlGetSingle
    extends Kubectl.ResourceBuilder<ApiType, KubectlGetSingle>
    implements Kubectl.Executable<ApiType> {
        private KubectlGetSingle(String name) {
            super(KubectlGet.this.apiTypeClass);
            this.name = name;
            this.namespace = KubectlGet.this.namespace;
            this.apiClient = KubectlGet.this.apiClient;
            this.skipDiscovery = KubectlGet.this.skipDiscovery;
        }

        private boolean isNamespaced() {
            return !StringUtils.isEmpty((CharSequence)this.namespace);
        }

        @Override
        public ApiType execute() throws KubectlException {
            GenericKubernetesApi api = this.getGenericApi(this.apiTypeClass);
            try {
                if (this.isNamespaced()) {
                    return (KubernetesObject)api.get(this.namespace, this.name).throwsApiException().getObject();
                }
                return (KubernetesObject)api.get(this.name).throwsApiException().getObject();
            }
            catch (ApiException e) {
                throw new KubectlException(e);
            }
        }
    }
}

