/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.leaderelection.resourcelock;

import io.kubernetes.client.extended.leaderelection.LeaderElectionRecord;
import io.kubernetes.client.extended.leaderelection.Lock;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoordinationV1Api;
import io.kubernetes.client.openapi.models.V1Lease;
import io.kubernetes.client.openapi.models.V1LeaseSpec;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(LeaseLock.class);
    private final String namespace;
    private final String name;
    private final String identity;
    private CoordinationV1Api coordinationV1Api;
    private AtomicReference<V1Lease> leaseRefer = new AtomicReference<Object>(null);

    public LeaseLock(String namespace, String name, String identity) {
        this(namespace, name, identity, Configuration.getDefaultApiClient());
    }

    public LeaseLock(String namespace, String name, String identity, ApiClient apiClient) {
        this.namespace = namespace;
        this.name = name;
        this.identity = identity;
        this.coordinationV1Api = new CoordinationV1Api(apiClient);
    }

    @Override
    public LeaderElectionRecord get() throws ApiException {
        V1Lease lease = this.coordinationV1Api.readNamespacedLease(this.name, this.namespace, null, null, null);
        this.leaseRefer.set(lease);
        return this.getRecordFromLease(lease.getSpec());
    }

    @Override
    public boolean create(LeaderElectionRecord record) {
        try {
            V1ObjectMeta objectMeta = new V1ObjectMeta();
            objectMeta.setName(this.name);
            objectMeta.setNamespace(this.namespace);
            if (record.getOwnerReference() != null) {
                objectMeta.setOwnerReferences(Collections.singletonList(record.getOwnerReference()));
            }
            V1Lease createdLease = this.coordinationV1Api.createNamespacedLease(this.namespace, new V1Lease().metadata(objectMeta).spec(this.getLeaseFromRecord(record)), null, null, null);
            this.leaseRefer.set(createdLease);
            return true;
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                log.debug("received {} when creating configmap lock", (Object)e.getCode(), (Object)e);
            } else {
                log.error("received {} when creating configmap lock", (Object)e.getCode(), (Object)e);
            }
            return false;
        }
    }

    @Override
    public boolean update(LeaderElectionRecord record) {
        try {
            V1Lease latest = this.leaseRefer.get();
            latest.setSpec(this.getLeaseFromRecord(record));
            V1Lease updatedLease = this.coordinationV1Api.replaceNamespacedLease(this.name, this.namespace, latest, null, null, null);
            this.leaseRefer.set(updatedLease);
            return true;
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                log.debug("received {} when creating configmap lock", (Object)e.getCode(), (Object)e);
            } else {
                log.error("received {} when creating configmap lock", (Object)e.getCode(), (Object)e);
            }
            return false;
        }
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public String describe() {
        return this.namespace + "/" + this.name;
    }

    private LeaderElectionRecord getRecordFromLease(V1LeaseSpec lease) {
        LeaderElectionRecord record = new LeaderElectionRecord();
        if (lease.getAcquireTime() != null) {
            record.setAcquireTime(lease.getAcquireTime().toDate());
        }
        if (lease.getRenewTime() != null) {
            record.setRenewTime(lease.getRenewTime().toDate());
        }
        record.setHolderIdentity(lease.getHolderIdentity());
        record.setLeaderTransitions(lease.getLeaseTransitions());
        record.setLeaseDurationSeconds(lease.getLeaseDurationSeconds());
        return record;
    }

    private V1LeaseSpec getLeaseFromRecord(LeaderElectionRecord record) {
        return new V1LeaseSpec().acquireTime(new DateTime((Object)record.getAcquireTime())).renewTime(new DateTime((Object)record.getRenewTime())).holderIdentity(record.getHolderIdentity()).leaseDurationSeconds(Integer.valueOf(record.getLeaseDurationSeconds())).leaseTransitions(Integer.valueOf(record.getLeaderTransitions()));
    }
}

