/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.event.legacy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.kubernetes.client.extended.event.legacy.EventUtils;
import io.kubernetes.client.fluent.Function;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.MutablePair;

public class EventAggregator {
    public static final int DEFAULT_MAX_EVENT_LOCAL_KEYS = 10;
    public static final Duration DEFAULT_EVENT_AGGREGATE_CACHE_EXPIRATION = Duration.ofSeconds(600L);
    private Cache<String, AggregatedRecord> spammingCache;
    private Function<CoreV1Event, MutablePair<String, String>> keyFunc;
    private Function<CoreV1Event, String> messageFunc;
    private final int maxEvents;

    public EventAggregator(int maxLRUCacheEntries, Function<CoreV1Event, MutablePair<String, String>> keyFunc, Function<CoreV1Event, String> messageFunc) {
        this.keyFunc = keyFunc;
        this.messageFunc = messageFunc;
        this.maxEvents = 10;
        this.spammingCache = Caffeine.newBuilder().maximumSize((long)maxLRUCacheEntries).expireAfterWrite(DEFAULT_EVENT_AGGREGATE_CACHE_EXPIRATION).build();
    }

    public synchronized MutablePair<CoreV1Event, String> aggregate(CoreV1Event event) {
        OffsetDateTime now = OffsetDateTime.now();
        MutablePair aggregatedKeys = (MutablePair)this.keyFunc.apply((Object)event);
        String aggregatedKey = (String)aggregatedKeys.getLeft();
        String localKey = (String)aggregatedKeys.getRight();
        AggregatedRecord record = (AggregatedRecord)this.spammingCache.get((Object)aggregatedKey, k -> new AggregatedRecord());
        record.lastTimestamp = now;
        record.localKeys.add(localKey);
        if (record.localKeys.size() < this.maxEvents) {
            this.spammingCache.put((Object)aggregatedKey, (Object)record);
            return new MutablePair((Object)event, (Object)EventUtils.getEventKey(event));
        }
        record.localKeys.remove(record.localKeys.stream().findAny().get());
        CoreV1Event aggregatedEvent = ((CoreV1EventBuilder)((CoreV1EventBuilder)((CoreV1EventBuilder)((CoreV1EventBuilder)((CoreV1EventBuilder)new CoreV1EventBuilder(event).withMetadata(((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)new V1ObjectMetaBuilder().withName(EventUtils.generateName(event.getInvolvedObject().getName(), now))).withNamespace(event.getInvolvedObject().getNamespace())).build())).withCount(Integer.valueOf(1))).withFirstTimestamp(now)).withLastTimestamp(now)).withMessage((String)this.messageFunc.apply((Object)event))).build();
        this.spammingCache.put((Object)aggregatedKey, (Object)record);
        return new MutablePair((Object)aggregatedEvent, (Object)aggregatedKey);
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    private static class AggregatedRecord {
        private Set<String> localKeys = new HashSet<String>();
        private OffsetDateTime lastTimestamp;

        private AggregatedRecord() {
        }

        public boolean equals(Object o) {
            return Objects.equals(this, o);
        }

        public int hashCode() {
            return Objects.hashCode(this);
        }
    }
}

