/*
Copyright 2021 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.proto;

public final class V1Apps {
  private V1Apps() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface ControllerRevisionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.ControllerRevision)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    boolean hasData();
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    io.kubernetes.client.proto.Runtime.RawExtension getData();
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder getDataOrBuilder();

    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    boolean hasRevision();
    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    long getRevision();
  }
  /**
   *
   *
   * <pre>
   * ControllerRevision implements an immutable snapshot of state data. Clients
   * are responsible for serializing and deserializing the objects that contain
   * their internal state.
   * Once a ControllerRevision has been successfully created, it can not be updated.
   * The API Server will fail validation of all requests that attempt to mutate
   * the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both
   * the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However,
   * it may be subject to name and representation changes in future releases, and clients should not
   * depend on its stability. It is primarily for internal use by controllers.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.ControllerRevision}
   */
  public static final class ControllerRevision extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.ControllerRevision)
      ControllerRevisionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ControllerRevision.newBuilder() to construct.
    private ControllerRevision(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ControllerRevision() {
      revision_ = 0L;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ControllerRevision(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.Runtime.RawExtension.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = data_.toBuilder();
                }
                data_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Runtime.RawExtension.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(data_);
                  data_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 24:
              {
                bitField0_ |= 0x00000004;
                revision_ = input.readInt64();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ControllerRevision_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ControllerRevision_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.ControllerRevision.class,
              io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int DATA_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.Runtime.RawExtension data_;
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    public boolean hasData() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    public io.kubernetes.client.proto.Runtime.RawExtension getData() {
      return data_ == null
          ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
          : data_;
    }
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    public io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder getDataOrBuilder() {
      return data_ == null
          ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
          : data_;
    }

    public static final int REVISION_FIELD_NUMBER = 3;
    private long revision_;
    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    public boolean hasRevision() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    public long getRevision() {
      return revision_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getData());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt64(3, revision_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getData());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, revision_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.ControllerRevision)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.ControllerRevision other =
          (io.kubernetes.client.proto.V1Apps.ControllerRevision) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasData() == other.hasData());
      if (hasData()) {
        result = result && getData().equals(other.getData());
      }
      result = result && (hasRevision() == other.hasRevision());
      if (hasRevision()) {
        result = result && (getRevision() == other.getRevision());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasData()) {
        hash = (37 * hash) + DATA_FIELD_NUMBER;
        hash = (53 * hash) + getData().hashCode();
      }
      if (hasRevision()) {
        hash = (37 * hash) + REVISION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRevision());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Apps.ControllerRevision prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ControllerRevision implements an immutable snapshot of state data. Clients
     * are responsible for serializing and deserializing the objects that contain
     * their internal state.
     * Once a ControllerRevision has been successfully created, it can not be updated.
     * The API Server will fail validation of all requests that attempt to mutate
     * the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both
     * the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However,
     * it may be subject to name and representation changes in future releases, and clients should not
     * depend on its stability. It is primarily for internal use by controllers.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.ControllerRevision}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.ControllerRevision)
        io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ControllerRevision_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ControllerRevision_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.ControllerRevision.class,
                io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.ControllerRevision.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getDataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (dataBuilder_ == null) {
          data_ = null;
        } else {
          dataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        revision_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ControllerRevision_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ControllerRevision getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.ControllerRevision.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ControllerRevision build() {
        io.kubernetes.client.proto.V1Apps.ControllerRevision result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ControllerRevision buildPartial() {
        io.kubernetes.client.proto.V1Apps.ControllerRevision result =
            new io.kubernetes.client.proto.V1Apps.ControllerRevision(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (dataBuilder_ == null) {
          result.data_ = data_;
        } else {
          result.data_ = dataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.revision_ = revision_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.ControllerRevision) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.ControllerRevision) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.ControllerRevision other) {
        if (other == io.kubernetes.client.proto.V1Apps.ControllerRevision.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasData()) {
          mergeData(other.getData());
        }
        if (other.hasRevision()) {
          setRevision(other.getRevision());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.ControllerRevision parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.ControllerRevision) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.Runtime.RawExtension data_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Runtime.RawExtension,
              io.kubernetes.client.proto.Runtime.RawExtension.Builder,
              io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder>
          dataBuilder_;
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public boolean hasData() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public io.kubernetes.client.proto.Runtime.RawExtension getData() {
        if (dataBuilder_ == null) {
          return data_ == null
              ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
              : data_;
        } else {
          return dataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder setData(io.kubernetes.client.proto.Runtime.RawExtension value) {
        if (dataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          dataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder setData(
          io.kubernetes.client.proto.Runtime.RawExtension.Builder builderForValue) {
        if (dataBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          dataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder mergeData(io.kubernetes.client.proto.Runtime.RawExtension value) {
        if (dataBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && data_ != null
              && data_ != io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()) {
            data_ =
                io.kubernetes.client.proto.Runtime.RawExtension.newBuilder(data_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          dataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder clearData() {
        if (dataBuilder_ == null) {
          data_ = null;
          onChanged();
        } else {
          dataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public io.kubernetes.client.proto.Runtime.RawExtension.Builder getDataBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder getDataOrBuilder() {
        if (dataBuilder_ != null) {
          return dataBuilder_.getMessageOrBuilder();
        } else {
          return data_ == null
              ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
              : data_;
        }
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Runtime.RawExtension,
              io.kubernetes.client.proto.Runtime.RawExtension.Builder,
              io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder>
          getDataFieldBuilder() {
        if (dataBuilder_ == null) {
          dataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Runtime.RawExtension,
                  io.kubernetes.client.proto.Runtime.RawExtension.Builder,
                  io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder>(
                  getData(), getParentForChildren(), isClean());
          data_ = null;
        }
        return dataBuilder_;
      }

      private long revision_;
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public boolean hasRevision() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public long getRevision() {
        return revision_;
      }
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public Builder setRevision(long value) {
        bitField0_ |= 0x00000004;
        revision_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public Builder clearRevision() {
        bitField0_ = (bitField0_ & ~0x00000004);
        revision_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.ControllerRevision)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.ControllerRevision)
    private static final io.kubernetes.client.proto.V1Apps.ControllerRevision DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.ControllerRevision();
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevision getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ControllerRevision> PARSER =
        new com.google.protobuf.AbstractParser<ControllerRevision>() {
          @java.lang.Override
          public ControllerRevision parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ControllerRevision(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ControllerRevision> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ControllerRevision> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.ControllerRevision getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ControllerRevisionListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.ControllerRevisionList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Apps.ControllerRevision> getItemsList();
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.ControllerRevision getItems(int index);
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * ControllerRevisionList is a resource containing a list of ControllerRevision objects.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.ControllerRevisionList}
   */
  public static final class ControllerRevisionList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.ControllerRevisionList)
      ControllerRevisionListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ControllerRevisionList.newBuilder() to construct.
    private ControllerRevisionList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ControllerRevisionList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ControllerRevisionList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Apps.ControllerRevision>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.ControllerRevision.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ControllerRevisionList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ControllerRevisionList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.ControllerRevisionList.class,
              io.kubernetes.client.proto.V1Apps.ControllerRevisionList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Apps.ControllerRevision> items_;
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Apps.ControllerRevision> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ControllerRevision getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder getItemsOrBuilder(
        int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.ControllerRevisionList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.ControllerRevisionList other =
          (io.kubernetes.client.proto.V1Apps.ControllerRevisionList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Apps.ControllerRevisionList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ControllerRevisionList is a resource containing a list of ControllerRevision objects.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.ControllerRevisionList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.ControllerRevisionList)
        io.kubernetes.client.proto.V1Apps.ControllerRevisionListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ControllerRevisionList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ControllerRevisionList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.ControllerRevisionList.class,
                io.kubernetes.client.proto.V1Apps.ControllerRevisionList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.ControllerRevisionList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ControllerRevisionList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ControllerRevisionList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.ControllerRevisionList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ControllerRevisionList build() {
        io.kubernetes.client.proto.V1Apps.ControllerRevisionList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ControllerRevisionList buildPartial() {
        io.kubernetes.client.proto.V1Apps.ControllerRevisionList result =
            new io.kubernetes.client.proto.V1Apps.ControllerRevisionList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.ControllerRevisionList) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.ControllerRevisionList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.ControllerRevisionList other) {
        if (other == io.kubernetes.client.proto.V1Apps.ControllerRevisionList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.ControllerRevisionList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.ControllerRevisionList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Apps.ControllerRevision> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.ControllerRevision>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ControllerRevision,
              io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder,
              io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.ControllerRevision> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ControllerRevision getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Apps.ControllerRevision value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Apps.ControllerRevision value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Apps.ControllerRevision value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Apps.ControllerRevision>
              values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder getItemsBuilder(
          int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder getItemsOrBuilder(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Apps.ControllerRevision.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder addItemsBuilder(
          int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Apps.ControllerRevision.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ControllerRevision items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ControllerRevision,
              io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder,
              io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.ControllerRevision,
                  io.kubernetes.client.proto.V1Apps.ControllerRevision.Builder,
                  io.kubernetes.client.proto.V1Apps.ControllerRevisionOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.ControllerRevisionList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.ControllerRevisionList)
    private static final io.kubernetes.client.proto.V1Apps.ControllerRevisionList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.ControllerRevisionList();
    }

    public static io.kubernetes.client.proto.V1Apps.ControllerRevisionList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ControllerRevisionList> PARSER =
        new com.google.protobuf.AbstractParser<ControllerRevisionList>() {
          @java.lang.Override
          public ControllerRevisionList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ControllerRevisionList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ControllerRevisionList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ControllerRevisionList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.ControllerRevisionList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DaemonSetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DaemonSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * The desired behavior of this daemon set.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * The desired behavior of this daemon set.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetSpec getSpec();
    /**
     *
     *
     * <pre>
     * The desired behavior of this daemon set.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetSpecOrBuilder getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * The current status of this daemon set. This data may be
     * out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * The current status of this daemon set. This data may be
     * out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetStatus getStatus();
    /**
     *
     *
     * <pre>
     * The current status of this daemon set. This data may be
     * out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetStatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * DaemonSet represents the configuration of a daemon set.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DaemonSet}
   */
  public static final class DaemonSet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DaemonSet)
      DaemonSetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DaemonSet.newBuilder() to construct.
    private DaemonSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DaemonSet() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DaemonSet(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DaemonSetSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = status_.toBuilder();
                }
                status_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DaemonSetStatus.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(status_);
                  status_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DaemonSet.class,
              io.kubernetes.client.proto.V1Apps.DaemonSet.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Apps.DaemonSetSpec spec_;
    /**
     *
     *
     * <pre>
     * The desired behavior of this daemon set.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * The desired behavior of this daemon set.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Apps.DaemonSetSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * The desired behavior of this daemon set.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Apps.DaemonSetSpec.getDefaultInstance()
          : spec_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1Apps.DaemonSetStatus status_;
    /**
     *
     *
     * <pre>
     * The current status of this daemon set. This data may be
     * out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * The current status of this daemon set. This data may be
     * out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetStatus getStatus() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Apps.DaemonSetStatus.getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * The current status of this daemon set. This data may be
     * out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetStatusOrBuilder getStatusOrBuilder() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Apps.DaemonSetStatus.getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getStatus());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStatus());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DaemonSet)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DaemonSet other =
          (io.kubernetes.client.proto.V1Apps.DaemonSet) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.DaemonSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DaemonSet represents the configuration of a daemon set.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DaemonSet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DaemonSet)
        io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DaemonSet.class,
                io.kubernetes.client.proto.V1Apps.DaemonSet.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DaemonSet.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSet_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSet getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DaemonSet.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSet build() {
        io.kubernetes.client.proto.V1Apps.DaemonSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSet buildPartial() {
        io.kubernetes.client.proto.V1Apps.DaemonSet result =
            new io.kubernetes.client.proto.V1Apps.DaemonSet(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DaemonSet) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DaemonSet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DaemonSet other) {
        if (other == io.kubernetes.client.proto.V1Apps.DaemonSet.getDefaultInstance()) return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DaemonSet parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.kubernetes.client.proto.V1Apps.DaemonSet) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.DaemonSetSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetSpec,
              io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Apps.DaemonSetSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1Apps.DaemonSetSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1Apps.DaemonSetSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_ != io.kubernetes.client.proto.V1Apps.DaemonSetSpec.getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1Apps.DaemonSetSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Apps.DaemonSetSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * The desired behavior of this daemon set.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetSpec,
              io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DaemonSetSpec,
                  io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder,
                  io.kubernetes.client.proto.V1Apps.DaemonSetSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.DaemonSetStatus status_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetStatus,
              io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? io.kubernetes.client.proto.V1Apps.DaemonSetStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public Builder setStatus(io.kubernetes.client.proto.V1Apps.DaemonSetStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public Builder setStatus(
          io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public Builder mergeStatus(io.kubernetes.client.proto.V1Apps.DaemonSetStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && status_ != null
              && status_
                  != io.kubernetes.client.proto.V1Apps.DaemonSetStatus.getDefaultInstance()) {
            status_ =
                io.kubernetes.client.proto.V1Apps.DaemonSetStatus.newBuilder(status_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder getStatusBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetStatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? io.kubernetes.client.proto.V1Apps.DaemonSetStatus.getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * The current status of this daemon set. This data may be
       * out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetStatus status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetStatus,
              io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DaemonSetStatus,
                  io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder,
                  io.kubernetes.client.proto.V1Apps.DaemonSetStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DaemonSet)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DaemonSet)
    private static final io.kubernetes.client.proto.V1Apps.DaemonSet DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DaemonSet();
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DaemonSet> PARSER =
        new com.google.protobuf.AbstractParser<DaemonSet>() {
          @java.lang.Override
          public DaemonSet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DaemonSet(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DaemonSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DaemonSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DaemonSet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DaemonSetConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DaemonSetCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of DaemonSet condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of DaemonSet condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of DaemonSet condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    java.lang.String getStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    com.google.protobuf.ByteString getStatusBytes();

    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    boolean hasLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    io.kubernetes.client.proto.Meta.Time getLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    boolean hasReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    java.lang.String getReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    com.google.protobuf.ByteString getReasonBytes();

    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    boolean hasMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * DaemonSetCondition describes the state of a DaemonSet at a certain point.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetCondition}
   */
  public static final class DaemonSetCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DaemonSetCondition)
      DaemonSetConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DaemonSetCondition.newBuilder() to construct.
    private DaemonSetCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DaemonSetCondition() {
      type_ = "";
      status_ = "";
      reason_ = "";
      message_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DaemonSetCondition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                status_ = bs;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.Meta.Time.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = lastTransitionTime_.toBuilder();
                }
                lastTransitionTime_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.Time.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(lastTransitionTime_);
                  lastTransitionTime_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 34:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                reason_ = bs;
                break;
              }
            case 42:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                message_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DaemonSetCondition.class,
              io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of DaemonSet condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of DaemonSet condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of DaemonSet condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private volatile java.lang.Object status_;
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          status_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LASTTRANSITIONTIME_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.Meta.Time lastTransitionTime_;
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public boolean hasLastTransitionTime() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }

    public static final int REASON_FIELD_NUMBER = 4;
    private volatile java.lang.Object reason_;
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public boolean hasReason() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          reason_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MESSAGE_FIELD_NUMBER = 5;
    private volatile java.lang.Object message_;
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          message_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, status_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getLastTransitionTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reason_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, message_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, status_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLastTransitionTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reason_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, message_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DaemonSetCondition)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DaemonSetCondition other =
          (io.kubernetes.client.proto.V1Apps.DaemonSetCondition) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && (hasLastTransitionTime() == other.hasLastTransitionTime());
      if (hasLastTransitionTime()) {
        result = result && getLastTransitionTime().equals(other.getLastTransitionTime());
      }
      result = result && (hasReason() == other.hasReason());
      if (hasReason()) {
        result = result && getReason().equals(other.getReason());
      }
      result = result && (hasMessage() == other.hasMessage());
      if (hasMessage()) {
        result = result && getMessage().equals(other.getMessage());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (hasLastTransitionTime()) {
        hash = (37 * hash) + LASTTRANSITIONTIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastTransitionTime().hashCode();
      }
      if (hasReason()) {
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + getReason().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Apps.DaemonSetCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DaemonSetCondition describes the state of a DaemonSet at a certain point.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DaemonSetCondition)
        io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DaemonSetCondition.class,
                io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DaemonSetCondition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLastTransitionTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        reason_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        message_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetCondition_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetCondition getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DaemonSetCondition.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetCondition build() {
        io.kubernetes.client.proto.V1Apps.DaemonSetCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetCondition buildPartial() {
        io.kubernetes.client.proto.V1Apps.DaemonSetCondition result =
            new io.kubernetes.client.proto.V1Apps.DaemonSetCondition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (lastTransitionTimeBuilder_ == null) {
          result.lastTransitionTime_ = lastTransitionTime_;
        } else {
          result.lastTransitionTime_ = lastTransitionTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.reason_ = reason_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.message_ = message_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DaemonSetCondition) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DaemonSetCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DaemonSetCondition other) {
        if (other == io.kubernetes.client.proto.V1Apps.DaemonSetCondition.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasStatus()) {
          bitField0_ |= 0x00000002;
          status_ = other.status_;
          onChanged();
        }
        if (other.hasLastTransitionTime()) {
          mergeLastTransitionTime(other.getLastTransitionTime());
        }
        if (other.hasReason()) {
          bitField0_ |= 0x00000008;
          reason_ = other.reason_;
          onChanged();
        }
        if (other.hasMessage()) {
          bitField0_ |= 0x00000010;
          message_ = other.message_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DaemonSetCondition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DaemonSetCondition) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of DaemonSet condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of DaemonSet condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of DaemonSet condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of DaemonSet condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of DaemonSet condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of DaemonSet condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object status_ = "";
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public java.lang.String getStatus() {
        java.lang.Object ref = status_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            status_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public com.google.protobuf.ByteString getStatusBytes() {
        java.lang.Object ref = status_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          status_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatus(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = getDefaultInstance().getStatus();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatusBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.Time lastTransitionTime_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          lastTransitionTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public boolean hasLastTransitionTime() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        } else {
          return lastTransitionTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder setLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastTransitionTime_ = value;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder setLastTransitionTime(
          io.kubernetes.client.proto.Meta.Time.Builder builderForValue) {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = builderForValue.build();
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder mergeLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && lastTransitionTime_ != null
              && lastTransitionTime_ != io.kubernetes.client.proto.Meta.Time.getDefaultInstance()) {
            lastTransitionTime_ =
                io.kubernetes.client.proto.Meta.Time.newBuilder(lastTransitionTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastTransitionTime_ = value;
          }
          onChanged();
        } else {
          lastTransitionTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder clearLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.Time.Builder getLastTransitionTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLastTransitionTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
        if (lastTransitionTimeBuilder_ != null) {
          return lastTransitionTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          getLastTransitionTimeFieldBuilder() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.Time,
                  io.kubernetes.client.proto.Meta.Time.Builder,
                  io.kubernetes.client.proto.Meta.TimeOrBuilder>(
                  getLastTransitionTime(), getParentForChildren(), isClean());
          lastTransitionTime_ = null;
        }
        return lastTransitionTimeBuilder_;
      }

      private java.lang.Object reason_ = "";
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public boolean hasReason() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public java.lang.String getReason() {
        java.lang.Object ref = reason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            reason_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public com.google.protobuf.ByteString getReasonBytes() {
        java.lang.Object ref = reason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        reason_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder clearReason() {
        bitField0_ = (bitField0_ & ~0x00000008);
        reason_ = getDefaultInstance().getReason();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        reason_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            message_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        message_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000010);
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        message_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DaemonSetCondition)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DaemonSetCondition)
    private static final io.kubernetes.client.proto.V1Apps.DaemonSetCondition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DaemonSetCondition();
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DaemonSetCondition> PARSER =
        new com.google.protobuf.AbstractParser<DaemonSetCondition>() {
          @java.lang.Override
          public DaemonSetCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DaemonSetCondition(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DaemonSetCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DaemonSetCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DaemonSetCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DaemonSetListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DaemonSetList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSet> getItemsList();
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSet getItems(int index);
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * DaemonSetList is a collection of daemon sets.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetList}
   */
  public static final class DaemonSetList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DaemonSetList)
      DaemonSetListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DaemonSetList.newBuilder() to construct.
    private DaemonSetList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DaemonSetList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DaemonSetList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.DaemonSet>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DaemonSet.PARSER, extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DaemonSetList.class,
              io.kubernetes.client.proto.V1Apps.DaemonSetList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSet> items_;
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSet> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSet getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of daemon sets.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder getItemsOrBuilder(int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DaemonSetList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DaemonSetList other =
          (io.kubernetes.client.proto.V1Apps.DaemonSetList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.DaemonSetList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DaemonSetList is a collection of daemon sets.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DaemonSetList)
        io.kubernetes.client.proto.V1Apps.DaemonSetListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DaemonSetList.class,
                io.kubernetes.client.proto.V1Apps.DaemonSetList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DaemonSetList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DaemonSetList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetList build() {
        io.kubernetes.client.proto.V1Apps.DaemonSetList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetList buildPartial() {
        io.kubernetes.client.proto.V1Apps.DaemonSetList result =
            new io.kubernetes.client.proto.V1Apps.DaemonSetList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DaemonSetList) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DaemonSetList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DaemonSetList other) {
        if (other == io.kubernetes.client.proto.V1Apps.DaemonSetList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DaemonSetList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DaemonSetList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSet> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.DaemonSet>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSet,
              io.kubernetes.client.proto.V1Apps.DaemonSet.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSet> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSet getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder setItems(int index, io.kubernetes.client.proto.V1Apps.DaemonSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Apps.DaemonSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Apps.DaemonSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder addItems(int index, io.kubernetes.client.proto.V1Apps.DaemonSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Apps.DaemonSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Apps.DaemonSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Apps.DaemonSet> values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSet.Builder getItemsBuilder(int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder getItemsOrBuilder(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSet.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Apps.DaemonSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSet.Builder addItemsBuilder(int index) {
        return getItemsFieldBuilder()
            .addBuilder(index, io.kubernetes.client.proto.V1Apps.DaemonSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of daemon sets.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSet items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSet.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSet,
              io.kubernetes.client.proto.V1Apps.DaemonSet.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DaemonSet,
                  io.kubernetes.client.proto.V1Apps.DaemonSet.Builder,
                  io.kubernetes.client.proto.V1Apps.DaemonSetOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DaemonSetList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DaemonSetList)
    private static final io.kubernetes.client.proto.V1Apps.DaemonSetList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DaemonSetList();
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DaemonSetList> PARSER =
        new com.google.protobuf.AbstractParser<DaemonSetList>() {
          @java.lang.Override
          public DaemonSetList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DaemonSetList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DaemonSetList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DaemonSetList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DaemonSetList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DaemonSetSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DaemonSetSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A label query over pods that are managed by the daemon set.
     * Must match in order to be controlled.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
     */
    boolean hasSelector();
    /**
     *
     *
     * <pre>
     * A label query over pods that are managed by the daemon set.
     * Must match in order to be controlled.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelector getSelector();
    /**
     *
     *
     * <pre>
     * A label query over pods that are managed by the daemon set.
     * Must match in order to be controlled.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * An object that describes the pod that will be created.
     * The DaemonSet will create exactly one copy of this pod on every node
     * that matches the template's node selector (or on every node if no node
     * selector is specified).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
     */
    boolean hasTemplate();
    /**
     *
     *
     * <pre>
     * An object that describes the pod that will be created.
     * The DaemonSet will create exactly one copy of this pod on every node
     * that matches the template's node selector (or on every node if no node
     * selector is specified).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate();
    /**
     *
     *
     * <pre>
     * An object that describes the pod that will be created.
     * The DaemonSet will create exactly one copy of this pod on every node
     * that matches the template's node selector (or on every node if no node
     * selector is specified).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder();

    /**
     *
     *
     * <pre>
     * An update strategy to replace existing DaemonSet pods with new pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
     */
    boolean hasUpdateStrategy();
    /**
     *
     *
     * <pre>
     * An update strategy to replace existing DaemonSet pods with new pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy getUpdateStrategy();
    /**
     *
     *
     * <pre>
     * An update strategy to replace existing DaemonSet pods with new pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategyOrBuilder getUpdateStrategyOrBuilder();

    /**
     *
     *
     * <pre>
     * The minimum number of seconds for which a newly created DaemonSet pod should
     * be ready without any of its container crashing, for it to be considered
     * available. Defaults to 0 (pod will be considered available as soon as it
     * is ready).
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    boolean hasMinReadySeconds();
    /**
     *
     *
     * <pre>
     * The minimum number of seconds for which a newly created DaemonSet pod should
     * be ready without any of its container crashing, for it to be considered
     * available. Defaults to 0 (pod will be considered available as soon as it
     * is ready).
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    int getMinReadySeconds();

    /**
     *
     *
     * <pre>
     * The number of old history to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    boolean hasRevisionHistoryLimit();
    /**
     *
     *
     * <pre>
     * The number of old history to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    int getRevisionHistoryLimit();
  }
  /**
   *
   *
   * <pre>
   * DaemonSetSpec is the specification of a daemon set.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetSpec}
   */
  public static final class DaemonSetSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DaemonSetSpec)
      DaemonSetSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DaemonSetSpec.newBuilder() to construct.
    private DaemonSetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DaemonSetSpec() {
      minReadySeconds_ = 0;
      revisionHistoryLimit_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DaemonSetSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.LabelSelector.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = selector_.toBuilder();
                }
                selector_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.LabelSelector.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(selector_);
                  selector_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1.PodTemplateSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = template_.toBuilder();
                }
                template_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1.PodTemplateSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(template_);
                  template_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = updateStrategy_.toBuilder();
                }
                updateStrategy_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(updateStrategy_);
                  updateStrategy_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 32:
              {
                bitField0_ |= 0x00000008;
                minReadySeconds_ = input.readInt32();
                break;
              }
            case 48:
              {
                bitField0_ |= 0x00000010;
                revisionHistoryLimit_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DaemonSetSpec.class,
              io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder.class);
    }

    private int bitField0_;
    public static final int SELECTOR_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.LabelSelector selector_;
    /**
     *
     *
     * <pre>
     * A label query over pods that are managed by the daemon set.
     * Must match in order to be controlled.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
     */
    public boolean hasSelector() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * A label query over pods that are managed by the daemon set.
     * Must match in order to be controlled.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }
    /**
     *
     *
     * <pre>
     * A label query over pods that are managed by the daemon set.
     * Must match in order to be controlled.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }

    public static final int TEMPLATE_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1.PodTemplateSpec template_;
    /**
     *
     *
     * <pre>
     * An object that describes the pod that will be created.
     * The DaemonSet will create exactly one copy of this pod on every node
     * that matches the template's node selector (or on every node if no node
     * selector is specified).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * An object that describes the pod that will be created.
     * The DaemonSet will create exactly one copy of this pod on every node
     * that matches the template's node selector (or on every node if no node
     * selector is specified).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }
    /**
     *
     *
     * <pre>
     * An object that describes the pod that will be created.
     * The DaemonSet will create exactly one copy of this pod on every node
     * that matches the template's node selector (or on every node if no node
     * selector is specified).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }

    public static final int UPDATESTRATEGY_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy updateStrategy_;
    /**
     *
     *
     * <pre>
     * An update strategy to replace existing DaemonSet pods with new pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
     */
    public boolean hasUpdateStrategy() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * An update strategy to replace existing DaemonSet pods with new pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy getUpdateStrategy() {
      return updateStrategy_ == null
          ? io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.getDefaultInstance()
          : updateStrategy_;
    }
    /**
     *
     *
     * <pre>
     * An update strategy to replace existing DaemonSet pods with new pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategyOrBuilder
        getUpdateStrategyOrBuilder() {
      return updateStrategy_ == null
          ? io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.getDefaultInstance()
          : updateStrategy_;
    }

    public static final int MINREADYSECONDS_FIELD_NUMBER = 4;
    private int minReadySeconds_;
    /**
     *
     *
     * <pre>
     * The minimum number of seconds for which a newly created DaemonSet pod should
     * be ready without any of its container crashing, for it to be considered
     * available. Defaults to 0 (pod will be considered available as soon as it
     * is ready).
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    public boolean hasMinReadySeconds() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * The minimum number of seconds for which a newly created DaemonSet pod should
     * be ready without any of its container crashing, for it to be considered
     * available. Defaults to 0 (pod will be considered available as soon as it
     * is ready).
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    public int getMinReadySeconds() {
      return minReadySeconds_;
    }

    public static final int REVISIONHISTORYLIMIT_FIELD_NUMBER = 6;
    private int revisionHistoryLimit_;
    /**
     *
     *
     * <pre>
     * The number of old history to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    public boolean hasRevisionHistoryLimit() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * The number of old history to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    public int getRevisionHistoryLimit() {
      return revisionHistoryLimit_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getSelector());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getTemplate());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getUpdateStrategy());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(4, minReadySeconds_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(6, revisionHistoryLimit_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSelector());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTemplate());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateStrategy());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, minReadySeconds_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, revisionHistoryLimit_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DaemonSetSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DaemonSetSpec other =
          (io.kubernetes.client.proto.V1Apps.DaemonSetSpec) obj;

      boolean result = true;
      result = result && (hasSelector() == other.hasSelector());
      if (hasSelector()) {
        result = result && getSelector().equals(other.getSelector());
      }
      result = result && (hasTemplate() == other.hasTemplate());
      if (hasTemplate()) {
        result = result && getTemplate().equals(other.getTemplate());
      }
      result = result && (hasUpdateStrategy() == other.hasUpdateStrategy());
      if (hasUpdateStrategy()) {
        result = result && getUpdateStrategy().equals(other.getUpdateStrategy());
      }
      result = result && (hasMinReadySeconds() == other.hasMinReadySeconds());
      if (hasMinReadySeconds()) {
        result = result && (getMinReadySeconds() == other.getMinReadySeconds());
      }
      result = result && (hasRevisionHistoryLimit() == other.hasRevisionHistoryLimit());
      if (hasRevisionHistoryLimit()) {
        result = result && (getRevisionHistoryLimit() == other.getRevisionHistoryLimit());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSelector()) {
        hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getSelector().hashCode();
      }
      if (hasTemplate()) {
        hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
        hash = (53 * hash) + getTemplate().hashCode();
      }
      if (hasUpdateStrategy()) {
        hash = (37 * hash) + UPDATESTRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateStrategy().hashCode();
      }
      if (hasMinReadySeconds()) {
        hash = (37 * hash) + MINREADYSECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getMinReadySeconds();
      }
      if (hasRevisionHistoryLimit()) {
        hash = (37 * hash) + REVISIONHISTORYLIMIT_FIELD_NUMBER;
        hash = (53 * hash) + getRevisionHistoryLimit();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.DaemonSetSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DaemonSetSpec is the specification of a daemon set.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DaemonSetSpec)
        io.kubernetes.client.proto.V1Apps.DaemonSetSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DaemonSetSpec.class,
                io.kubernetes.client.proto.V1Apps.DaemonSetSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DaemonSetSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSelectorFieldBuilder();
          getTemplateFieldBuilder();
          getUpdateStrategyFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (selectorBuilder_ == null) {
          selector_ = null;
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (templateBuilder_ == null) {
          template_ = null;
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (updateStrategyBuilder_ == null) {
          updateStrategy_ = null;
        } else {
          updateStrategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        minReadySeconds_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        revisionHistoryLimit_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DaemonSetSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetSpec build() {
        io.kubernetes.client.proto.V1Apps.DaemonSetSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetSpec buildPartial() {
        io.kubernetes.client.proto.V1Apps.DaemonSetSpec result =
            new io.kubernetes.client.proto.V1Apps.DaemonSetSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (selectorBuilder_ == null) {
          result.selector_ = selector_;
        } else {
          result.selector_ = selectorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (templateBuilder_ == null) {
          result.template_ = template_;
        } else {
          result.template_ = templateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (updateStrategyBuilder_ == null) {
          result.updateStrategy_ = updateStrategy_;
        } else {
          result.updateStrategy_ = updateStrategyBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.minReadySeconds_ = minReadySeconds_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.revisionHistoryLimit_ = revisionHistoryLimit_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DaemonSetSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DaemonSetSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DaemonSetSpec other) {
        if (other == io.kubernetes.client.proto.V1Apps.DaemonSetSpec.getDefaultInstance())
          return this;
        if (other.hasSelector()) {
          mergeSelector(other.getSelector());
        }
        if (other.hasTemplate()) {
          mergeTemplate(other.getTemplate());
        }
        if (other.hasUpdateStrategy()) {
          mergeUpdateStrategy(other.getUpdateStrategy());
        }
        if (other.hasMinReadySeconds()) {
          setMinReadySeconds(other.getMinReadySeconds());
        }
        if (other.hasRevisionHistoryLimit()) {
          setRevisionHistoryLimit(other.getRevisionHistoryLimit());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DaemonSetSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DaemonSetSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.LabelSelector selector_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          selectorBuilder_;
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public boolean hasSelector() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
        if (selectorBuilder_ == null) {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        } else {
          return selectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public Builder setSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          selector_ = value;
          onChanged();
        } else {
          selectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public Builder setSelector(
          io.kubernetes.client.proto.Meta.LabelSelector.Builder builderForValue) {
        if (selectorBuilder_ == null) {
          selector_ = builderForValue.build();
          onChanged();
        } else {
          selectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public Builder mergeSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && selector_ != null
              && selector_ != io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()) {
            selector_ =
                io.kubernetes.client.proto.Meta.LabelSelector.newBuilder(selector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            selector_ = value;
          }
          onChanged();
        } else {
          selectorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public Builder clearSelector() {
        if (selectorBuilder_ == null) {
          selector_ = null;
          onChanged();
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector.Builder getSelectorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
        if (selectorBuilder_ != null) {
          return selectorBuilder_.getMessageOrBuilder();
        } else {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        }
      }
      /**
       *
       *
       * <pre>
       * A label query over pods that are managed by the daemon set.
       * Must match in order to be controlled.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          getSelectorFieldBuilder() {
        if (selectorBuilder_ == null) {
          selectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.LabelSelector,
                  io.kubernetes.client.proto.Meta.LabelSelector.Builder,
                  io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>(
                  getSelector(), getParentForChildren(), isClean());
          selector_ = null;
        }
        return selectorBuilder_;
      }

      private io.kubernetes.client.proto.V1.PodTemplateSpec template_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          templateBuilder_;
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public boolean hasTemplate() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
        if (templateBuilder_ == null) {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        } else {
          return templateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public Builder setTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          template_ = value;
          onChanged();
        } else {
          templateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public Builder setTemplate(
          io.kubernetes.client.proto.V1.PodTemplateSpec.Builder builderForValue) {
        if (templateBuilder_ == null) {
          template_ = builderForValue.build();
          onChanged();
        } else {
          templateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public Builder mergeTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && template_ != null
              && template_ != io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()) {
            template_ =
                io.kubernetes.client.proto.V1.PodTemplateSpec.newBuilder(template_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            template_ = value;
          }
          onChanged();
        } else {
          templateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public Builder clearTemplate() {
        if (templateBuilder_ == null) {
          template_ = null;
          onChanged();
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec.Builder getTemplateBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTemplateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
        if (templateBuilder_ != null) {
          return templateBuilder_.getMessageOrBuilder();
        } else {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        }
      }
      /**
       *
       *
       * <pre>
       * An object that describes the pod that will be created.
       * The DaemonSet will create exactly one copy of this pod on every node
       * that matches the template's node selector (or on every node if no node
       * selector is specified).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          getTemplateFieldBuilder() {
        if (templateBuilder_ == null) {
          templateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1.PodTemplateSpec,
                  io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
                  io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>(
                  getTemplate(), getParentForChildren(), isClean());
          template_ = null;
        }
        return templateBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy updateStrategy_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy,
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategyOrBuilder>
          updateStrategyBuilder_;
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public boolean hasUpdateStrategy() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy getUpdateStrategy() {
        if (updateStrategyBuilder_ == null) {
          return updateStrategy_ == null
              ? io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.getDefaultInstance()
              : updateStrategy_;
        } else {
          return updateStrategyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public Builder setUpdateStrategy(
          io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy value) {
        if (updateStrategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateStrategy_ = value;
          onChanged();
        } else {
          updateStrategyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public Builder setUpdateStrategy(
          io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder builderForValue) {
        if (updateStrategyBuilder_ == null) {
          updateStrategy_ = builderForValue.build();
          onChanged();
        } else {
          updateStrategyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public Builder mergeUpdateStrategy(
          io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy value) {
        if (updateStrategyBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && updateStrategy_ != null
              && updateStrategy_
                  != io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy
                      .getDefaultInstance()) {
            updateStrategy_ =
                io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.newBuilder(
                        updateStrategy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            updateStrategy_ = value;
          }
          onChanged();
        } else {
          updateStrategyBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public Builder clearUpdateStrategy() {
        if (updateStrategyBuilder_ == null) {
          updateStrategy_ = null;
          onChanged();
        } else {
          updateStrategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder
          getUpdateStrategyBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getUpdateStrategyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategyOrBuilder
          getUpdateStrategyOrBuilder() {
        if (updateStrategyBuilder_ != null) {
          return updateStrategyBuilder_.getMessageOrBuilder();
        } else {
          return updateStrategy_ == null
              ? io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.getDefaultInstance()
              : updateStrategy_;
        }
      }
      /**
       *
       *
       * <pre>
       * An update strategy to replace existing DaemonSet pods with new pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DaemonSetUpdateStrategy updateStrategy = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy,
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategyOrBuilder>
          getUpdateStrategyFieldBuilder() {
        if (updateStrategyBuilder_ == null) {
          updateStrategyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy,
                  io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder,
                  io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategyOrBuilder>(
                  getUpdateStrategy(), getParentForChildren(), isClean());
          updateStrategy_ = null;
        }
        return updateStrategyBuilder_;
      }

      private int minReadySeconds_;
      /**
       *
       *
       * <pre>
       * The minimum number of seconds for which a newly created DaemonSet pod should
       * be ready without any of its container crashing, for it to be considered
       * available. Defaults to 0 (pod will be considered available as soon as it
       * is ready).
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public boolean hasMinReadySeconds() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * The minimum number of seconds for which a newly created DaemonSet pod should
       * be ready without any of its container crashing, for it to be considered
       * available. Defaults to 0 (pod will be considered available as soon as it
       * is ready).
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public int getMinReadySeconds() {
        return minReadySeconds_;
      }
      /**
       *
       *
       * <pre>
       * The minimum number of seconds for which a newly created DaemonSet pod should
       * be ready without any of its container crashing, for it to be considered
       * available. Defaults to 0 (pod will be considered available as soon as it
       * is ready).
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public Builder setMinReadySeconds(int value) {
        bitField0_ |= 0x00000008;
        minReadySeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum number of seconds for which a newly created DaemonSet pod should
       * be ready without any of its container crashing, for it to be considered
       * available. Defaults to 0 (pod will be considered available as soon as it
       * is ready).
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public Builder clearMinReadySeconds() {
        bitField0_ = (bitField0_ & ~0x00000008);
        minReadySeconds_ = 0;
        onChanged();
        return this;
      }

      private int revisionHistoryLimit_;
      /**
       *
       *
       * <pre>
       * The number of old history to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public boolean hasRevisionHistoryLimit() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * The number of old history to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public int getRevisionHistoryLimit() {
        return revisionHistoryLimit_;
      }
      /**
       *
       *
       * <pre>
       * The number of old history to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public Builder setRevisionHistoryLimit(int value) {
        bitField0_ |= 0x00000010;
        revisionHistoryLimit_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of old history to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public Builder clearRevisionHistoryLimit() {
        bitField0_ = (bitField0_ & ~0x00000010);
        revisionHistoryLimit_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DaemonSetSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DaemonSetSpec)
    private static final io.kubernetes.client.proto.V1Apps.DaemonSetSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DaemonSetSpec();
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DaemonSetSpec> PARSER =
        new com.google.protobuf.AbstractParser<DaemonSetSpec>() {
          @java.lang.Override
          public DaemonSetSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DaemonSetSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DaemonSetSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DaemonSetSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DaemonSetSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DaemonSetStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DaemonSetStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of nodes that are running at least 1
     * daemon pod and are supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 currentNumberScheduled = 1;</code>
     */
    boolean hasCurrentNumberScheduled();
    /**
     *
     *
     * <pre>
     * The number of nodes that are running at least 1
     * daemon pod and are supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 currentNumberScheduled = 1;</code>
     */
    int getCurrentNumberScheduled();

    /**
     *
     *
     * <pre>
     * The number of nodes that are running the daemon pod, but are
     * not supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 numberMisscheduled = 2;</code>
     */
    boolean hasNumberMisscheduled();
    /**
     *
     *
     * <pre>
     * The number of nodes that are running the daemon pod, but are
     * not supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 numberMisscheduled = 2;</code>
     */
    int getNumberMisscheduled();

    /**
     *
     *
     * <pre>
     * The total number of nodes that should be running the daemon
     * pod (including nodes correctly running the daemon pod).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 desiredNumberScheduled = 3;</code>
     */
    boolean hasDesiredNumberScheduled();
    /**
     *
     *
     * <pre>
     * The total number of nodes that should be running the daemon
     * pod (including nodes correctly running the daemon pod).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 desiredNumberScheduled = 3;</code>
     */
    int getDesiredNumberScheduled();

    /**
     *
     *
     * <pre>
     * numberReady is the number of nodes that should be running the daemon pod and have one
     * or more of the daemon pod running with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 numberReady = 4;</code>
     */
    boolean hasNumberReady();
    /**
     *
     *
     * <pre>
     * numberReady is the number of nodes that should be running the daemon pod and have one
     * or more of the daemon pod running with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 numberReady = 4;</code>
     */
    int getNumberReady();

    /**
     *
     *
     * <pre>
     * The most recent generation observed by the daemon set controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 5;</code>
     */
    boolean hasObservedGeneration();
    /**
     *
     *
     * <pre>
     * The most recent generation observed by the daemon set controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 5;</code>
     */
    long getObservedGeneration();

    /**
     *
     *
     * <pre>
     * The total number of nodes that are running updated daemon pod
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedNumberScheduled = 6;</code>
     */
    boolean hasUpdatedNumberScheduled();
    /**
     *
     *
     * <pre>
     * The total number of nodes that are running updated daemon pod
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedNumberScheduled = 6;</code>
     */
    int getUpdatedNumberScheduled();

    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have one or more of the daemon pod running and
     * available (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberAvailable = 7;</code>
     */
    boolean hasNumberAvailable();
    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have one or more of the daemon pod running and
     * available (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberAvailable = 7;</code>
     */
    int getNumberAvailable();

    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have none of the daemon pod running and available
     * (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberUnavailable = 8;</code>
     */
    boolean hasNumberUnavailable();
    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have none of the daemon pod running and available
     * (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberUnavailable = 8;</code>
     */
    int getNumberUnavailable();

    /**
     *
     *
     * <pre>
     * Count of hash collisions for the DaemonSet. The DaemonSet controller
     * uses this field as a collision avoidance mechanism when it needs to
     * create the name for the newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    boolean hasCollisionCount();
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the DaemonSet. The DaemonSet controller
     * uses this field as a collision avoidance mechanism when it needs to
     * create the name for the newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    int getCollisionCount();

    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSetCondition> getConditionsList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetCondition getConditions(int index);
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    int getConditionsCount();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder>
        getConditionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder getConditionsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * DaemonSetStatus represents the current status of a daemon set.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetStatus}
   */
  public static final class DaemonSetStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DaemonSetStatus)
      DaemonSetStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DaemonSetStatus.newBuilder() to construct.
    private DaemonSetStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DaemonSetStatus() {
      currentNumberScheduled_ = 0;
      numberMisscheduled_ = 0;
      desiredNumberScheduled_ = 0;
      numberReady_ = 0;
      observedGeneration_ = 0L;
      updatedNumberScheduled_ = 0;
      numberAvailable_ = 0;
      numberUnavailable_ = 0;
      collisionCount_ = 0;
      conditions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DaemonSetStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                currentNumberScheduled_ = input.readInt32();
                break;
              }
            case 16:
              {
                bitField0_ |= 0x00000002;
                numberMisscheduled_ = input.readInt32();
                break;
              }
            case 24:
              {
                bitField0_ |= 0x00000004;
                desiredNumberScheduled_ = input.readInt32();
                break;
              }
            case 32:
              {
                bitField0_ |= 0x00000008;
                numberReady_ = input.readInt32();
                break;
              }
            case 40:
              {
                bitField0_ |= 0x00000010;
                observedGeneration_ = input.readInt64();
                break;
              }
            case 48:
              {
                bitField0_ |= 0x00000020;
                updatedNumberScheduled_ = input.readInt32();
                break;
              }
            case 56:
              {
                bitField0_ |= 0x00000040;
                numberAvailable_ = input.readInt32();
                break;
              }
            case 64:
              {
                bitField0_ |= 0x00000080;
                numberUnavailable_ = input.readInt32();
                break;
              }
            case 72:
              {
                bitField0_ |= 0x00000100;
                collisionCount_ = input.readInt32();
                break;
              }
            case 82:
              {
                if (!((mutable_bitField0_ & 0x00000200) == 0x00000200)) {
                  conditions_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Apps.DaemonSetCondition>();
                  mutable_bitField0_ |= 0x00000200;
                }
                conditions_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DaemonSetCondition.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000200) == 0x00000200)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DaemonSetStatus.class,
              io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder.class);
    }

    private int bitField0_;
    public static final int CURRENTNUMBERSCHEDULED_FIELD_NUMBER = 1;
    private int currentNumberScheduled_;
    /**
     *
     *
     * <pre>
     * The number of nodes that are running at least 1
     * daemon pod and are supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 currentNumberScheduled = 1;</code>
     */
    public boolean hasCurrentNumberScheduled() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * The number of nodes that are running at least 1
     * daemon pod and are supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 currentNumberScheduled = 1;</code>
     */
    public int getCurrentNumberScheduled() {
      return currentNumberScheduled_;
    }

    public static final int NUMBERMISSCHEDULED_FIELD_NUMBER = 2;
    private int numberMisscheduled_;
    /**
     *
     *
     * <pre>
     * The number of nodes that are running the daemon pod, but are
     * not supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 numberMisscheduled = 2;</code>
     */
    public boolean hasNumberMisscheduled() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * The number of nodes that are running the daemon pod, but are
     * not supposed to run the daemon pod.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 numberMisscheduled = 2;</code>
     */
    public int getNumberMisscheduled() {
      return numberMisscheduled_;
    }

    public static final int DESIREDNUMBERSCHEDULED_FIELD_NUMBER = 3;
    private int desiredNumberScheduled_;
    /**
     *
     *
     * <pre>
     * The total number of nodes that should be running the daemon
     * pod (including nodes correctly running the daemon pod).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 desiredNumberScheduled = 3;</code>
     */
    public boolean hasDesiredNumberScheduled() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * The total number of nodes that should be running the daemon
     * pod (including nodes correctly running the daemon pod).
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
     * </pre>
     *
     * <code>optional int32 desiredNumberScheduled = 3;</code>
     */
    public int getDesiredNumberScheduled() {
      return desiredNumberScheduled_;
    }

    public static final int NUMBERREADY_FIELD_NUMBER = 4;
    private int numberReady_;
    /**
     *
     *
     * <pre>
     * numberReady is the number of nodes that should be running the daemon pod and have one
     * or more of the daemon pod running with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 numberReady = 4;</code>
     */
    public boolean hasNumberReady() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * numberReady is the number of nodes that should be running the daemon pod and have one
     * or more of the daemon pod running with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 numberReady = 4;</code>
     */
    public int getNumberReady() {
      return numberReady_;
    }

    public static final int OBSERVEDGENERATION_FIELD_NUMBER = 5;
    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * The most recent generation observed by the daemon set controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 5;</code>
     */
    public boolean hasObservedGeneration() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * The most recent generation observed by the daemon set controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 5;</code>
     */
    public long getObservedGeneration() {
      return observedGeneration_;
    }

    public static final int UPDATEDNUMBERSCHEDULED_FIELD_NUMBER = 6;
    private int updatedNumberScheduled_;
    /**
     *
     *
     * <pre>
     * The total number of nodes that are running updated daemon pod
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedNumberScheduled = 6;</code>
     */
    public boolean hasUpdatedNumberScheduled() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * The total number of nodes that are running updated daemon pod
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedNumberScheduled = 6;</code>
     */
    public int getUpdatedNumberScheduled() {
      return updatedNumberScheduled_;
    }

    public static final int NUMBERAVAILABLE_FIELD_NUMBER = 7;
    private int numberAvailable_;
    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have one or more of the daemon pod running and
     * available (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberAvailable = 7;</code>
     */
    public boolean hasNumberAvailable() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have one or more of the daemon pod running and
     * available (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberAvailable = 7;</code>
     */
    public int getNumberAvailable() {
      return numberAvailable_;
    }

    public static final int NUMBERUNAVAILABLE_FIELD_NUMBER = 8;
    private int numberUnavailable_;
    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have none of the daemon pod running and available
     * (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberUnavailable = 8;</code>
     */
    public boolean hasNumberUnavailable() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     *
     *
     * <pre>
     * The number of nodes that should be running the
     * daemon pod and have none of the daemon pod running and available
     * (ready for at least spec.minReadySeconds)
     * +optional
     * </pre>
     *
     * <code>optional int32 numberUnavailable = 8;</code>
     */
    public int getNumberUnavailable() {
      return numberUnavailable_;
    }

    public static final int COLLISIONCOUNT_FIELD_NUMBER = 9;
    private int collisionCount_;
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the DaemonSet. The DaemonSet controller
     * uses this field as a collision avoidance mechanism when it needs to
     * create the name for the newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    public boolean hasCollisionCount() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the DaemonSet. The DaemonSet controller
     * uses this field as a collision avoidance mechanism when it needs to
     * create the name for the newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    public int getCollisionCount() {
      return collisionCount_;
    }

    public static final int CONDITIONS_FIELD_NUMBER = 10;
    private java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSetCondition> conditions_;
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSetCondition>
        getConditionsList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder>
        getConditionsOrBuilderList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetCondition getConditions(int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a DaemonSet's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder getConditionsOrBuilder(
        int index) {
      return conditions_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, currentNumberScheduled_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, numberMisscheduled_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, desiredNumberScheduled_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(4, numberReady_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt64(5, observedGeneration_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeInt32(6, updatedNumberScheduled_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeInt32(7, numberAvailable_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeInt32(8, numberUnavailable_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeInt32(9, collisionCount_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        output.writeMessage(10, conditions_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, currentNumberScheduled_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, numberMisscheduled_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, desiredNumberScheduled_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, numberReady_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, observedGeneration_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, updatedNumberScheduled_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, numberAvailable_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, numberUnavailable_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, collisionCount_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, conditions_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DaemonSetStatus)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DaemonSetStatus other =
          (io.kubernetes.client.proto.V1Apps.DaemonSetStatus) obj;

      boolean result = true;
      result = result && (hasCurrentNumberScheduled() == other.hasCurrentNumberScheduled());
      if (hasCurrentNumberScheduled()) {
        result = result && (getCurrentNumberScheduled() == other.getCurrentNumberScheduled());
      }
      result = result && (hasNumberMisscheduled() == other.hasNumberMisscheduled());
      if (hasNumberMisscheduled()) {
        result = result && (getNumberMisscheduled() == other.getNumberMisscheduled());
      }
      result = result && (hasDesiredNumberScheduled() == other.hasDesiredNumberScheduled());
      if (hasDesiredNumberScheduled()) {
        result = result && (getDesiredNumberScheduled() == other.getDesiredNumberScheduled());
      }
      result = result && (hasNumberReady() == other.hasNumberReady());
      if (hasNumberReady()) {
        result = result && (getNumberReady() == other.getNumberReady());
      }
      result = result && (hasObservedGeneration() == other.hasObservedGeneration());
      if (hasObservedGeneration()) {
        result = result && (getObservedGeneration() == other.getObservedGeneration());
      }
      result = result && (hasUpdatedNumberScheduled() == other.hasUpdatedNumberScheduled());
      if (hasUpdatedNumberScheduled()) {
        result = result && (getUpdatedNumberScheduled() == other.getUpdatedNumberScheduled());
      }
      result = result && (hasNumberAvailable() == other.hasNumberAvailable());
      if (hasNumberAvailable()) {
        result = result && (getNumberAvailable() == other.getNumberAvailable());
      }
      result = result && (hasNumberUnavailable() == other.hasNumberUnavailable());
      if (hasNumberUnavailable()) {
        result = result && (getNumberUnavailable() == other.getNumberUnavailable());
      }
      result = result && (hasCollisionCount() == other.hasCollisionCount());
      if (hasCollisionCount()) {
        result = result && (getCollisionCount() == other.getCollisionCount());
      }
      result = result && getConditionsList().equals(other.getConditionsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCurrentNumberScheduled()) {
        hash = (37 * hash) + CURRENTNUMBERSCHEDULED_FIELD_NUMBER;
        hash = (53 * hash) + getCurrentNumberScheduled();
      }
      if (hasNumberMisscheduled()) {
        hash = (37 * hash) + NUMBERMISSCHEDULED_FIELD_NUMBER;
        hash = (53 * hash) + getNumberMisscheduled();
      }
      if (hasDesiredNumberScheduled()) {
        hash = (37 * hash) + DESIREDNUMBERSCHEDULED_FIELD_NUMBER;
        hash = (53 * hash) + getDesiredNumberScheduled();
      }
      if (hasNumberReady()) {
        hash = (37 * hash) + NUMBERREADY_FIELD_NUMBER;
        hash = (53 * hash) + getNumberReady();
      }
      if (hasObservedGeneration()) {
        hash = (37 * hash) + OBSERVEDGENERATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
      }
      if (hasUpdatedNumberScheduled()) {
        hash = (37 * hash) + UPDATEDNUMBERSCHEDULED_FIELD_NUMBER;
        hash = (53 * hash) + getUpdatedNumberScheduled();
      }
      if (hasNumberAvailable()) {
        hash = (37 * hash) + NUMBERAVAILABLE_FIELD_NUMBER;
        hash = (53 * hash) + getNumberAvailable();
      }
      if (hasNumberUnavailable()) {
        hash = (37 * hash) + NUMBERUNAVAILABLE_FIELD_NUMBER;
        hash = (53 * hash) + getNumberUnavailable();
      }
      if (hasCollisionCount()) {
        hash = (37 * hash) + COLLISIONCOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCollisionCount();
      }
      if (getConditionsCount() > 0) {
        hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.DaemonSetStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DaemonSetStatus represents the current status of a daemon set.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DaemonSetStatus)
        io.kubernetes.client.proto.V1Apps.DaemonSetStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DaemonSetStatus.class,
                io.kubernetes.client.proto.V1Apps.DaemonSetStatus.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DaemonSetStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getConditionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        currentNumberScheduled_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        numberMisscheduled_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        desiredNumberScheduled_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        numberReady_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        observedGeneration_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        updatedNumberScheduled_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        numberAvailable_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        numberUnavailable_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        collisionCount_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000200);
        } else {
          conditionsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetStatus_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetStatus getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DaemonSetStatus.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetStatus build() {
        io.kubernetes.client.proto.V1Apps.DaemonSetStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetStatus buildPartial() {
        io.kubernetes.client.proto.V1Apps.DaemonSetStatus result =
            new io.kubernetes.client.proto.V1Apps.DaemonSetStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.currentNumberScheduled_ = currentNumberScheduled_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.numberMisscheduled_ = numberMisscheduled_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.desiredNumberScheduled_ = desiredNumberScheduled_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.numberReady_ = numberReady_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.observedGeneration_ = observedGeneration_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.updatedNumberScheduled_ = updatedNumberScheduled_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.numberAvailable_ = numberAvailable_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.numberUnavailable_ = numberUnavailable_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.collisionCount_ = collisionCount_;
        if (conditionsBuilder_ == null) {
          if (((bitField0_ & 0x00000200) == 0x00000200)) {
            conditions_ = java.util.Collections.unmodifiableList(conditions_);
            bitField0_ = (bitField0_ & ~0x00000200);
          }
          result.conditions_ = conditions_;
        } else {
          result.conditions_ = conditionsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DaemonSetStatus) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DaemonSetStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DaemonSetStatus other) {
        if (other == io.kubernetes.client.proto.V1Apps.DaemonSetStatus.getDefaultInstance())
          return this;
        if (other.hasCurrentNumberScheduled()) {
          setCurrentNumberScheduled(other.getCurrentNumberScheduled());
        }
        if (other.hasNumberMisscheduled()) {
          setNumberMisscheduled(other.getNumberMisscheduled());
        }
        if (other.hasDesiredNumberScheduled()) {
          setDesiredNumberScheduled(other.getDesiredNumberScheduled());
        }
        if (other.hasNumberReady()) {
          setNumberReady(other.getNumberReady());
        }
        if (other.hasObservedGeneration()) {
          setObservedGeneration(other.getObservedGeneration());
        }
        if (other.hasUpdatedNumberScheduled()) {
          setUpdatedNumberScheduled(other.getUpdatedNumberScheduled());
        }
        if (other.hasNumberAvailable()) {
          setNumberAvailable(other.getNumberAvailable());
        }
        if (other.hasNumberUnavailable()) {
          setNumberUnavailable(other.getNumberUnavailable());
        }
        if (other.hasCollisionCount()) {
          setCollisionCount(other.getCollisionCount());
        }
        if (conditionsBuilder_ == null) {
          if (!other.conditions_.isEmpty()) {
            if (conditions_.isEmpty()) {
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000200);
            } else {
              ensureConditionsIsMutable();
              conditions_.addAll(other.conditions_);
            }
            onChanged();
          }
        } else {
          if (!other.conditions_.isEmpty()) {
            if (conditionsBuilder_.isEmpty()) {
              conditionsBuilder_.dispose();
              conditionsBuilder_ = null;
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000200);
              conditionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionsFieldBuilder()
                      : null;
            } else {
              conditionsBuilder_.addAllMessages(other.conditions_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DaemonSetStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DaemonSetStatus) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int currentNumberScheduled_;
      /**
       *
       *
       * <pre>
       * The number of nodes that are running at least 1
       * daemon pod and are supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 currentNumberScheduled = 1;</code>
       */
      public boolean hasCurrentNumberScheduled() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that are running at least 1
       * daemon pod and are supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 currentNumberScheduled = 1;</code>
       */
      public int getCurrentNumberScheduled() {
        return currentNumberScheduled_;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that are running at least 1
       * daemon pod and are supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 currentNumberScheduled = 1;</code>
       */
      public Builder setCurrentNumberScheduled(int value) {
        bitField0_ |= 0x00000001;
        currentNumberScheduled_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that are running at least 1
       * daemon pod and are supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 currentNumberScheduled = 1;</code>
       */
      public Builder clearCurrentNumberScheduled() {
        bitField0_ = (bitField0_ & ~0x00000001);
        currentNumberScheduled_ = 0;
        onChanged();
        return this;
      }

      private int numberMisscheduled_;
      /**
       *
       *
       * <pre>
       * The number of nodes that are running the daemon pod, but are
       * not supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 numberMisscheduled = 2;</code>
       */
      public boolean hasNumberMisscheduled() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that are running the daemon pod, but are
       * not supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 numberMisscheduled = 2;</code>
       */
      public int getNumberMisscheduled() {
        return numberMisscheduled_;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that are running the daemon pod, but are
       * not supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 numberMisscheduled = 2;</code>
       */
      public Builder setNumberMisscheduled(int value) {
        bitField0_ |= 0x00000002;
        numberMisscheduled_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that are running the daemon pod, but are
       * not supposed to run the daemon pod.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 numberMisscheduled = 2;</code>
       */
      public Builder clearNumberMisscheduled() {
        bitField0_ = (bitField0_ & ~0x00000002);
        numberMisscheduled_ = 0;
        onChanged();
        return this;
      }

      private int desiredNumberScheduled_;
      /**
       *
       *
       * <pre>
       * The total number of nodes that should be running the daemon
       * pod (including nodes correctly running the daemon pod).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 desiredNumberScheduled = 3;</code>
       */
      public boolean hasDesiredNumberScheduled() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * The total number of nodes that should be running the daemon
       * pod (including nodes correctly running the daemon pod).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 desiredNumberScheduled = 3;</code>
       */
      public int getDesiredNumberScheduled() {
        return desiredNumberScheduled_;
      }
      /**
       *
       *
       * <pre>
       * The total number of nodes that should be running the daemon
       * pod (including nodes correctly running the daemon pod).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 desiredNumberScheduled = 3;</code>
       */
      public Builder setDesiredNumberScheduled(int value) {
        bitField0_ |= 0x00000004;
        desiredNumberScheduled_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total number of nodes that should be running the daemon
       * pod (including nodes correctly running the daemon pod).
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
       * </pre>
       *
       * <code>optional int32 desiredNumberScheduled = 3;</code>
       */
      public Builder clearDesiredNumberScheduled() {
        bitField0_ = (bitField0_ & ~0x00000004);
        desiredNumberScheduled_ = 0;
        onChanged();
        return this;
      }

      private int numberReady_;
      /**
       *
       *
       * <pre>
       * numberReady is the number of nodes that should be running the daemon pod and have one
       * or more of the daemon pod running with a Ready Condition.
       * </pre>
       *
       * <code>optional int32 numberReady = 4;</code>
       */
      public boolean hasNumberReady() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * numberReady is the number of nodes that should be running the daemon pod and have one
       * or more of the daemon pod running with a Ready Condition.
       * </pre>
       *
       * <code>optional int32 numberReady = 4;</code>
       */
      public int getNumberReady() {
        return numberReady_;
      }
      /**
       *
       *
       * <pre>
       * numberReady is the number of nodes that should be running the daemon pod and have one
       * or more of the daemon pod running with a Ready Condition.
       * </pre>
       *
       * <code>optional int32 numberReady = 4;</code>
       */
      public Builder setNumberReady(int value) {
        bitField0_ |= 0x00000008;
        numberReady_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * numberReady is the number of nodes that should be running the daemon pod and have one
       * or more of the daemon pod running with a Ready Condition.
       * </pre>
       *
       * <code>optional int32 numberReady = 4;</code>
       */
      public Builder clearNumberReady() {
        bitField0_ = (bitField0_ & ~0x00000008);
        numberReady_ = 0;
        onChanged();
        return this;
      }

      private long observedGeneration_;
      /**
       *
       *
       * <pre>
       * The most recent generation observed by the daemon set controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 5;</code>
       */
      public boolean hasObservedGeneration() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * The most recent generation observed by the daemon set controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 5;</code>
       */
      public long getObservedGeneration() {
        return observedGeneration_;
      }
      /**
       *
       *
       * <pre>
       * The most recent generation observed by the daemon set controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 5;</code>
       */
      public Builder setObservedGeneration(long value) {
        bitField0_ |= 0x00000010;
        observedGeneration_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The most recent generation observed by the daemon set controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 5;</code>
       */
      public Builder clearObservedGeneration() {
        bitField0_ = (bitField0_ & ~0x00000010);
        observedGeneration_ = 0L;
        onChanged();
        return this;
      }

      private int updatedNumberScheduled_;
      /**
       *
       *
       * <pre>
       * The total number of nodes that are running updated daemon pod
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedNumberScheduled = 6;</code>
       */
      public boolean hasUpdatedNumberScheduled() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * The total number of nodes that are running updated daemon pod
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedNumberScheduled = 6;</code>
       */
      public int getUpdatedNumberScheduled() {
        return updatedNumberScheduled_;
      }
      /**
       *
       *
       * <pre>
       * The total number of nodes that are running updated daemon pod
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedNumberScheduled = 6;</code>
       */
      public Builder setUpdatedNumberScheduled(int value) {
        bitField0_ |= 0x00000020;
        updatedNumberScheduled_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total number of nodes that are running updated daemon pod
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedNumberScheduled = 6;</code>
       */
      public Builder clearUpdatedNumberScheduled() {
        bitField0_ = (bitField0_ & ~0x00000020);
        updatedNumberScheduled_ = 0;
        onChanged();
        return this;
      }

      private int numberAvailable_;
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have one or more of the daemon pod running and
       * available (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberAvailable = 7;</code>
       */
      public boolean hasNumberAvailable() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have one or more of the daemon pod running and
       * available (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberAvailable = 7;</code>
       */
      public int getNumberAvailable() {
        return numberAvailable_;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have one or more of the daemon pod running and
       * available (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberAvailable = 7;</code>
       */
      public Builder setNumberAvailable(int value) {
        bitField0_ |= 0x00000040;
        numberAvailable_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have one or more of the daemon pod running and
       * available (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberAvailable = 7;</code>
       */
      public Builder clearNumberAvailable() {
        bitField0_ = (bitField0_ & ~0x00000040);
        numberAvailable_ = 0;
        onChanged();
        return this;
      }

      private int numberUnavailable_;
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have none of the daemon pod running and available
       * (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberUnavailable = 8;</code>
       */
      public boolean hasNumberUnavailable() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have none of the daemon pod running and available
       * (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberUnavailable = 8;</code>
       */
      public int getNumberUnavailable() {
        return numberUnavailable_;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have none of the daemon pod running and available
       * (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberUnavailable = 8;</code>
       */
      public Builder setNumberUnavailable(int value) {
        bitField0_ |= 0x00000080;
        numberUnavailable_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of nodes that should be running the
       * daemon pod and have none of the daemon pod running and available
       * (ready for at least spec.minReadySeconds)
       * +optional
       * </pre>
       *
       * <code>optional int32 numberUnavailable = 8;</code>
       */
      public Builder clearNumberUnavailable() {
        bitField0_ = (bitField0_ & ~0x00000080);
        numberUnavailable_ = 0;
        onChanged();
        return this;
      }

      private int collisionCount_;
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the DaemonSet. The DaemonSet controller
       * uses this field as a collision avoidance mechanism when it needs to
       * create the name for the newest ControllerRevision.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 9;</code>
       */
      public boolean hasCollisionCount() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the DaemonSet. The DaemonSet controller
       * uses this field as a collision avoidance mechanism when it needs to
       * create the name for the newest ControllerRevision.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 9;</code>
       */
      public int getCollisionCount() {
        return collisionCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the DaemonSet. The DaemonSet controller
       * uses this field as a collision avoidance mechanism when it needs to
       * create the name for the newest ControllerRevision.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 9;</code>
       */
      public Builder setCollisionCount(int value) {
        bitField0_ |= 0x00000100;
        collisionCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the DaemonSet. The DaemonSet controller
       * uses this field as a collision avoidance mechanism when it needs to
       * create the name for the newest ControllerRevision.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 9;</code>
       */
      public Builder clearCollisionCount() {
        bitField0_ = (bitField0_ & ~0x00000100);
        collisionCount_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSetCondition> conditions_ =
          java.util.Collections.emptyList();

      private void ensureConditionsIsMutable() {
        if (!((bitField0_ & 0x00000200) == 0x00000200)) {
          conditions_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.DaemonSetCondition>(
                  conditions_);
          bitField0_ |= 0x00000200;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetCondition,
              io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder>
          conditionsBuilder_;

      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSetCondition>
          getConditionsList() {
        if (conditionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditions_);
        } else {
          return conditionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public int getConditionsCount() {
        if (conditionsBuilder_ == null) {
          return conditions_.size();
        } else {
          return conditionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetCondition getConditions(int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder setConditions(
          int index, io.kubernetes.client.proto.V1Apps.DaemonSetCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.set(index, value);
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder setConditions(
          int index, io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder addConditions(io.kubernetes.client.proto.V1Apps.DaemonSetCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder addConditions(
          int index, io.kubernetes.client.proto.V1Apps.DaemonSetCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(index, value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder addConditions(
          io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder addConditions(
          int index, io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder addAllConditions(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Apps.DaemonSetCondition>
              values) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
          onChanged();
        } else {
          conditionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder clearConditions() {
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000200);
          onChanged();
        } else {
          conditionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public Builder removeConditions(int index) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.remove(index);
          onChanged();
        } else {
          conditionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder getConditionsBuilder(
          int index) {
        return getConditionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder getConditionsOrBuilder(
          int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder>
          getConditionsOrBuilderList() {
        if (conditionsBuilder_ != null) {
          return conditionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder addConditionsBuilder() {
        return getConditionsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Apps.DaemonSetCondition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder addConditionsBuilder(
          int index) {
        return getConditionsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Apps.DaemonSetCondition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a DaemonSet's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DaemonSetCondition conditions = 10;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder>
          getConditionsBuilderList() {
        return getConditionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DaemonSetCondition,
              io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder,
              io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder>
          getConditionsFieldBuilder() {
        if (conditionsBuilder_ == null) {
          conditionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DaemonSetCondition,
                  io.kubernetes.client.proto.V1Apps.DaemonSetCondition.Builder,
                  io.kubernetes.client.proto.V1Apps.DaemonSetConditionOrBuilder>(
                  conditions_,
                  ((bitField0_ & 0x00000200) == 0x00000200),
                  getParentForChildren(),
                  isClean());
          conditions_ = null;
        }
        return conditionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DaemonSetStatus)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DaemonSetStatus)
    private static final io.kubernetes.client.proto.V1Apps.DaemonSetStatus DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DaemonSetStatus();
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetStatus getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DaemonSetStatus> PARSER =
        new com.google.protobuf.AbstractParser<DaemonSetStatus>() {
          @java.lang.Override
          public DaemonSetStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DaemonSetStatus(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DaemonSetStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DaemonSetStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DaemonSetStatus getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DaemonSetUpdateStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DaemonSetUpdateStrategy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if type = "RollingUpdate".
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be. Same as Deployment `strategy.rollingUpdate`.
     * See https://github.com/kubernetes/kubernetes/issues/35345
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
     */
    boolean hasRollingUpdate();
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if type = "RollingUpdate".
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be. Same as Deployment `strategy.rollingUpdate`.
     * See https://github.com/kubernetes/kubernetes/issues/35345
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet getRollingUpdate();
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if type = "RollingUpdate".
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be. Same as Deployment `strategy.rollingUpdate`.
     * See https://github.com/kubernetes/kubernetes/issues/35345
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSetOrBuilder getRollingUpdateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetUpdateStrategy}
   */
  public static final class DaemonSetUpdateStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DaemonSetUpdateStrategy)
      DaemonSetUpdateStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DaemonSetUpdateStrategy.newBuilder() to construct.
    private DaemonSetUpdateStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DaemonSetUpdateStrategy() {
      type_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DaemonSetUpdateStrategy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = rollingUpdate_.toBuilder();
                }
                rollingUpdate_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(rollingUpdate_);
                  rollingUpdate_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetUpdateStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DaemonSetUpdateStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.class,
              io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLLINGUPDATE_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet rollingUpdate_;
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if type = "RollingUpdate".
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be. Same as Deployment `strategy.rollingUpdate`.
     * See https://github.com/kubernetes/kubernetes/issues/35345
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
     */
    public boolean hasRollingUpdate() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if type = "RollingUpdate".
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be. Same as Deployment `strategy.rollingUpdate`.
     * See https://github.com/kubernetes/kubernetes/issues/35345
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet getRollingUpdate() {
      return rollingUpdate_ == null
          ? io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.getDefaultInstance()
          : rollingUpdate_;
    }
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if type = "RollingUpdate".
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be. Same as Deployment `strategy.rollingUpdate`.
     * See https://github.com/kubernetes/kubernetes/issues/35345
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSetOrBuilder
        getRollingUpdateOrBuilder() {
      return rollingUpdate_ == null
          ? io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.getDefaultInstance()
          : rollingUpdate_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getRollingUpdate());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRollingUpdate());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy other =
          (io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasRollingUpdate() == other.hasRollingUpdate());
      if (hasRollingUpdate()) {
        result = result && getRollingUpdate().equals(other.getRollingUpdate());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasRollingUpdate()) {
        hash = (37 * hash) + ROLLINGUPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getRollingUpdate().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DaemonSetUpdateStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DaemonSetUpdateStrategy)
        io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetUpdateStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetUpdateStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.class,
                io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRollingUpdateFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = null;
        } else {
          rollingUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DaemonSetUpdateStrategy_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy build() {
        io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy buildPartial() {
        io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy result =
            new io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (rollingUpdateBuilder_ == null) {
          result.rollingUpdate_ = rollingUpdate_;
        } else {
          result.rollingUpdate_ = rollingUpdateBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy other) {
        if (other == io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasRollingUpdate()) {
          mergeRollingUpdate(other.getRollingUpdate());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet rollingUpdate_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.Builder,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSetOrBuilder>
          rollingUpdateBuilder_;
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public boolean hasRollingUpdate() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet getRollingUpdate() {
        if (rollingUpdateBuilder_ == null) {
          return rollingUpdate_ == null
              ? io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.getDefaultInstance()
              : rollingUpdate_;
        } else {
          return rollingUpdateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public Builder setRollingUpdate(
          io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet value) {
        if (rollingUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollingUpdate_ = value;
          onChanged();
        } else {
          rollingUpdateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public Builder setRollingUpdate(
          io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.Builder builderForValue) {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = builderForValue.build();
          onChanged();
        } else {
          rollingUpdateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public Builder mergeRollingUpdate(
          io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet value) {
        if (rollingUpdateBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && rollingUpdate_ != null
              && rollingUpdate_
                  != io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet
                      .getDefaultInstance()) {
            rollingUpdate_ =
                io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.newBuilder(rollingUpdate_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rollingUpdate_ = value;
          }
          onChanged();
        } else {
          rollingUpdateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public Builder clearRollingUpdate() {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = null;
          onChanged();
        } else {
          rollingUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.Builder
          getRollingUpdateBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRollingUpdateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSetOrBuilder
          getRollingUpdateOrBuilder() {
        if (rollingUpdateBuilder_ != null) {
          return rollingUpdateBuilder_.getMessageOrBuilder();
        } else {
          return rollingUpdate_ == null
              ? io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.getDefaultInstance()
              : rollingUpdate_;
        }
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if type = "RollingUpdate".
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be. Same as Deployment `strategy.rollingUpdate`.
       * See https://github.com/kubernetes/kubernetes/issues/35345
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDaemonSet rollingUpdate = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.Builder,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSetOrBuilder>
          getRollingUpdateFieldBuilder() {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet,
                  io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSet.Builder,
                  io.kubernetes.client.proto.V1Apps.RollingUpdateDaemonSetOrBuilder>(
                  getRollingUpdate(), getParentForChildren(), isClean());
          rollingUpdate_ = null;
        }
        return rollingUpdateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DaemonSetUpdateStrategy)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DaemonSetUpdateStrategy)
    private static final io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy();
    }

    public static io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DaemonSetUpdateStrategy> PARSER =
        new com.google.protobuf.AbstractParser<DaemonSetUpdateStrategy>() {
          @java.lang.Override
          public DaemonSetUpdateStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DaemonSetUpdateStrategy(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DaemonSetUpdateStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DaemonSetUpdateStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DaemonSetUpdateStrategy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.Deployment)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentSpec getSpec();
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentSpecOrBuilder getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentStatus getStatus();
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentStatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Deployment enables declarative updates for Pods and ReplicaSets.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.Deployment}
   */
  public static final class Deployment extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.Deployment)
      DeploymentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Deployment.newBuilder() to construct.
    private Deployment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Deployment() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Deployment(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DeploymentSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = status_.toBuilder();
                }
                status_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DeploymentStatus.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(status_);
                  status_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_Deployment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_Deployment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.Deployment.class,
              io.kubernetes.client.proto.V1Apps.Deployment.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Apps.DeploymentSpec spec_;
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Apps.DeploymentSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Apps.DeploymentSpec.getDefaultInstance()
          : spec_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1Apps.DeploymentStatus status_;
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentStatus getStatus() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Apps.DeploymentStatus.getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentStatusOrBuilder getStatusOrBuilder() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Apps.DeploymentStatus.getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getStatus());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStatus());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.Deployment)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.Deployment other =
          (io.kubernetes.client.proto.V1Apps.Deployment) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.Deployment prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Deployment enables declarative updates for Pods and ReplicaSets.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.Deployment}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.Deployment)
        io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_Deployment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_Deployment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.Deployment.class,
                io.kubernetes.client.proto.V1Apps.Deployment.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.Deployment.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_Deployment_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.Deployment getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.Deployment.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.Deployment build() {
        io.kubernetes.client.proto.V1Apps.Deployment result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.Deployment buildPartial() {
        io.kubernetes.client.proto.V1Apps.Deployment result =
            new io.kubernetes.client.proto.V1Apps.Deployment(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.Deployment) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.Deployment) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.Deployment other) {
        if (other == io.kubernetes.client.proto.V1Apps.Deployment.getDefaultInstance()) return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.Deployment parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.kubernetes.client.proto.V1Apps.Deployment) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.DeploymentSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentSpec,
              io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Apps.DeploymentSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1Apps.DeploymentSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1Apps.DeploymentSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_ != io.kubernetes.client.proto.V1Apps.DeploymentSpec.getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1Apps.DeploymentSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Apps.DeploymentSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentSpec,
              io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DeploymentSpec,
                  io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder,
                  io.kubernetes.client.proto.V1Apps.DeploymentSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.DeploymentStatus status_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentStatus,
              io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? io.kubernetes.client.proto.V1Apps.DeploymentStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public Builder setStatus(io.kubernetes.client.proto.V1Apps.DeploymentStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public Builder setStatus(
          io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public Builder mergeStatus(io.kubernetes.client.proto.V1Apps.DeploymentStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && status_ != null
              && status_
                  != io.kubernetes.client.proto.V1Apps.DeploymentStatus.getDefaultInstance()) {
            status_ =
                io.kubernetes.client.proto.V1Apps.DeploymentStatus.newBuilder(status_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder getStatusBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentStatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? io.kubernetes.client.proto.V1Apps.DeploymentStatus.getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStatus status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentStatus,
              io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DeploymentStatus,
                  io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder,
                  io.kubernetes.client.proto.V1Apps.DeploymentStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.Deployment)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.Deployment)
    private static final io.kubernetes.client.proto.V1Apps.Deployment DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.Deployment();
    }

    public static io.kubernetes.client.proto.V1Apps.Deployment getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<Deployment> PARSER =
        new com.google.protobuf.AbstractParser<Deployment>() {
          @java.lang.Override
          public Deployment parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Deployment(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Deployment> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Deployment> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.Deployment getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DeploymentCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    java.lang.String getStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    com.google.protobuf.ByteString getStatusBytes();

    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    boolean hasLastUpdateTime();
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    io.kubernetes.client.proto.Meta.Time getLastUpdateTime();
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    io.kubernetes.client.proto.Meta.TimeOrBuilder getLastUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    boolean hasLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    io.kubernetes.client.proto.Meta.Time getLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    boolean hasReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    java.lang.String getReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    com.google.protobuf.ByteString getReasonBytes();

    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    boolean hasMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * DeploymentCondition describes the state of a deployment at a certain point.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DeploymentCondition}
   */
  public static final class DeploymentCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DeploymentCondition)
      DeploymentConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentCondition.newBuilder() to construct.
    private DeploymentCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentCondition() {
      type_ = "";
      status_ = "";
      reason_ = "";
      message_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentCondition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                status_ = bs;
                break;
              }
            case 34:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                reason_ = bs;
                break;
              }
            case 42:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000020;
                message_ = bs;
                break;
              }
            case 50:
              {
                io.kubernetes.client.proto.Meta.Time.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = lastUpdateTime_.toBuilder();
                }
                lastUpdateTime_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.Time.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(lastUpdateTime_);
                  lastUpdateTime_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 58:
              {
                io.kubernetes.client.proto.Meta.Time.Builder subBuilder = null;
                if (((bitField0_ & 0x00000008) == 0x00000008)) {
                  subBuilder = lastTransitionTime_.toBuilder();
                }
                lastTransitionTime_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.Time.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(lastTransitionTime_);
                  lastTransitionTime_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000008;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DeploymentCondition.class,
              io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private volatile java.lang.Object status_;
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          status_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LASTUPDATETIME_FIELD_NUMBER = 6;
    private io.kubernetes.client.proto.Meta.Time lastUpdateTime_;
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    public boolean hasLastUpdateTime() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    public io.kubernetes.client.proto.Meta.Time getLastUpdateTime() {
      return lastUpdateTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastUpdateTime_;
    }
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastUpdateTimeOrBuilder() {
      return lastUpdateTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastUpdateTime_;
    }

    public static final int LASTTRANSITIONTIME_FIELD_NUMBER = 7;
    private io.kubernetes.client.proto.Meta.Time lastTransitionTime_;
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    public boolean hasLastTransitionTime() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }

    public static final int REASON_FIELD_NUMBER = 4;
    private volatile java.lang.Object reason_;
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public boolean hasReason() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          reason_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MESSAGE_FIELD_NUMBER = 5;
    private volatile java.lang.Object message_;
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          message_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, status_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reason_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, message_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(6, getLastUpdateTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(7, getLastTransitionTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, status_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reason_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, message_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLastUpdateTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLastTransitionTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DeploymentCondition)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DeploymentCondition other =
          (io.kubernetes.client.proto.V1Apps.DeploymentCondition) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && (hasLastUpdateTime() == other.hasLastUpdateTime());
      if (hasLastUpdateTime()) {
        result = result && getLastUpdateTime().equals(other.getLastUpdateTime());
      }
      result = result && (hasLastTransitionTime() == other.hasLastTransitionTime());
      if (hasLastTransitionTime()) {
        result = result && getLastTransitionTime().equals(other.getLastTransitionTime());
      }
      result = result && (hasReason() == other.hasReason());
      if (hasReason()) {
        result = result && getReason().equals(other.getReason());
      }
      result = result && (hasMessage() == other.hasMessage());
      if (hasMessage()) {
        result = result && getMessage().equals(other.getMessage());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (hasLastUpdateTime()) {
        hash = (37 * hash) + LASTUPDATETIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastUpdateTime().hashCode();
      }
      if (hasLastTransitionTime()) {
        hash = (37 * hash) + LASTTRANSITIONTIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastTransitionTime().hashCode();
      }
      if (hasReason()) {
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + getReason().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Apps.DeploymentCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentCondition describes the state of a deployment at a certain point.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DeploymentCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DeploymentCondition)
        io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DeploymentCondition.class,
                io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DeploymentCondition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLastUpdateTimeFieldBuilder();
          getLastTransitionTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = null;
        } else {
          lastUpdateTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        reason_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        message_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentCondition_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentCondition getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DeploymentCondition.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentCondition build() {
        io.kubernetes.client.proto.V1Apps.DeploymentCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentCondition buildPartial() {
        io.kubernetes.client.proto.V1Apps.DeploymentCondition result =
            new io.kubernetes.client.proto.V1Apps.DeploymentCondition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (lastUpdateTimeBuilder_ == null) {
          result.lastUpdateTime_ = lastUpdateTime_;
        } else {
          result.lastUpdateTime_ = lastUpdateTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (lastTransitionTimeBuilder_ == null) {
          result.lastTransitionTime_ = lastTransitionTime_;
        } else {
          result.lastTransitionTime_ = lastTransitionTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.reason_ = reason_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.message_ = message_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DeploymentCondition) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DeploymentCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DeploymentCondition other) {
        if (other == io.kubernetes.client.proto.V1Apps.DeploymentCondition.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasStatus()) {
          bitField0_ |= 0x00000002;
          status_ = other.status_;
          onChanged();
        }
        if (other.hasLastUpdateTime()) {
          mergeLastUpdateTime(other.getLastUpdateTime());
        }
        if (other.hasLastTransitionTime()) {
          mergeLastTransitionTime(other.getLastTransitionTime());
        }
        if (other.hasReason()) {
          bitField0_ |= 0x00000010;
          reason_ = other.reason_;
          onChanged();
        }
        if (other.hasMessage()) {
          bitField0_ |= 0x00000020;
          message_ = other.message_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DeploymentCondition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DeploymentCondition) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object status_ = "";
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public java.lang.String getStatus() {
        java.lang.Object ref = status_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            status_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public com.google.protobuf.ByteString getStatusBytes() {
        java.lang.Object ref = status_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          status_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatus(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = getDefaultInstance().getStatus();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatusBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.Time lastUpdateTime_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          lastUpdateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public boolean hasLastUpdateTime() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public io.kubernetes.client.proto.Meta.Time getLastUpdateTime() {
        if (lastUpdateTimeBuilder_ == null) {
          return lastUpdateTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastUpdateTime_;
        } else {
          return lastUpdateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder setLastUpdateTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastUpdateTime_ = value;
          onChanged();
        } else {
          lastUpdateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder setLastUpdateTime(
          io.kubernetes.client.proto.Meta.Time.Builder builderForValue) {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = builderForValue.build();
          onChanged();
        } else {
          lastUpdateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder mergeLastUpdateTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && lastUpdateTime_ != null
              && lastUpdateTime_ != io.kubernetes.client.proto.Meta.Time.getDefaultInstance()) {
            lastUpdateTime_ =
                io.kubernetes.client.proto.Meta.Time.newBuilder(lastUpdateTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastUpdateTime_ = value;
          }
          onChanged();
        } else {
          lastUpdateTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder clearLastUpdateTime() {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = null;
          onChanged();
        } else {
          lastUpdateTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public io.kubernetes.client.proto.Meta.Time.Builder getLastUpdateTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLastUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastUpdateTimeOrBuilder() {
        if (lastUpdateTimeBuilder_ != null) {
          return lastUpdateTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastUpdateTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastUpdateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          getLastUpdateTimeFieldBuilder() {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.Time,
                  io.kubernetes.client.proto.Meta.Time.Builder,
                  io.kubernetes.client.proto.Meta.TimeOrBuilder>(
                  getLastUpdateTime(), getParentForChildren(), isClean());
          lastUpdateTime_ = null;
        }
        return lastUpdateTimeBuilder_;
      }

      private io.kubernetes.client.proto.Meta.Time lastTransitionTime_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          lastTransitionTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public boolean hasLastTransitionTime() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        } else {
          return lastTransitionTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder setLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastTransitionTime_ = value;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder setLastTransitionTime(
          io.kubernetes.client.proto.Meta.Time.Builder builderForValue) {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = builderForValue.build();
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder mergeLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)
              && lastTransitionTime_ != null
              && lastTransitionTime_ != io.kubernetes.client.proto.Meta.Time.getDefaultInstance()) {
            lastTransitionTime_ =
                io.kubernetes.client.proto.Meta.Time.newBuilder(lastTransitionTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastTransitionTime_ = value;
          }
          onChanged();
        } else {
          lastTransitionTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder clearLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public io.kubernetes.client.proto.Meta.Time.Builder getLastTransitionTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getLastTransitionTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
        if (lastTransitionTimeBuilder_ != null) {
          return lastTransitionTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          getLastTransitionTimeFieldBuilder() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.Time,
                  io.kubernetes.client.proto.Meta.Time.Builder,
                  io.kubernetes.client.proto.Meta.TimeOrBuilder>(
                  getLastTransitionTime(), getParentForChildren(), isClean());
          lastTransitionTime_ = null;
        }
        return lastTransitionTimeBuilder_;
      }

      private java.lang.Object reason_ = "";
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public boolean hasReason() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public java.lang.String getReason() {
        java.lang.Object ref = reason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            reason_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public com.google.protobuf.ByteString getReasonBytes() {
        java.lang.Object ref = reason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        reason_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder clearReason() {
        bitField0_ = (bitField0_ & ~0x00000010);
        reason_ = getDefaultInstance().getReason();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        reason_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            message_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        message_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000020);
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        message_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DeploymentCondition)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DeploymentCondition)
    private static final io.kubernetes.client.proto.V1Apps.DeploymentCondition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DeploymentCondition();
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentCondition> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentCondition>() {
          @java.lang.Override
          public DeploymentCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentCondition(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DeploymentCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DeploymentList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Apps.Deployment> getItemsList();
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.Deployment getItems(int index);
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * DeploymentList is a list of Deployments.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DeploymentList}
   */
  public static final class DeploymentList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DeploymentList)
      DeploymentListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentList.newBuilder() to construct.
    private DeploymentList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.Deployment>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.Deployment.PARSER, extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DeploymentList.class,
              io.kubernetes.client.proto.V1Apps.DeploymentList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Apps.Deployment> items_;
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Apps.Deployment> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.Deployment getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder getItemsOrBuilder(int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DeploymentList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DeploymentList other =
          (io.kubernetes.client.proto.V1Apps.DeploymentList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.DeploymentList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentList is a list of Deployments.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DeploymentList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DeploymentList)
        io.kubernetes.client.proto.V1Apps.DeploymentListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DeploymentList.class,
                io.kubernetes.client.proto.V1Apps.DeploymentList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DeploymentList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DeploymentList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentList build() {
        io.kubernetes.client.proto.V1Apps.DeploymentList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentList buildPartial() {
        io.kubernetes.client.proto.V1Apps.DeploymentList result =
            new io.kubernetes.client.proto.V1Apps.DeploymentList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DeploymentList) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DeploymentList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DeploymentList other) {
        if (other == io.kubernetes.client.proto.V1Apps.DeploymentList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DeploymentList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DeploymentList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Apps.Deployment> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.Deployment>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.Deployment,
              io.kubernetes.client.proto.V1Apps.Deployment.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.Deployment> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.Deployment getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder setItems(int index, io.kubernetes.client.proto.V1Apps.Deployment value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Apps.Deployment.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Apps.Deployment value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder addItems(int index, io.kubernetes.client.proto.V1Apps.Deployment value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1Apps.Deployment.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Apps.Deployment.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Apps.Deployment> values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.Deployment.Builder getItemsBuilder(int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder getItemsOrBuilder(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.Deployment.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Apps.Deployment.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.Deployment.Builder addItemsBuilder(int index) {
        return getItemsFieldBuilder()
            .addBuilder(index, io.kubernetes.client.proto.V1Apps.Deployment.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.Deployment items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.Deployment.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.Deployment,
              io.kubernetes.client.proto.V1Apps.Deployment.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.Deployment,
                  io.kubernetes.client.proto.V1Apps.Deployment.Builder,
                  io.kubernetes.client.proto.V1Apps.DeploymentOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DeploymentList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DeploymentList)
    private static final io.kubernetes.client.proto.V1Apps.DeploymentList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DeploymentList();
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentList> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentList>() {
          @java.lang.Override
          public DeploymentList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DeploymentList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DeploymentSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * It must match the pod template's labels.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    boolean hasSelector();
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * It must match the pod template's labels.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelector getSelector();
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * It must match the pod template's labels.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    boolean hasTemplate();
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate();
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder();

    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
     */
    boolean hasStrategy();
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentStrategy getStrategy();
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentStrategyOrBuilder getStrategyOrBuilder();

    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    boolean hasMinReadySeconds();
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    int getMinReadySeconds();

    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    boolean hasRevisionHistoryLimit();
    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    int getRevisionHistoryLimit();

    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    boolean hasPaused();
    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    boolean getPaused();

    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    boolean hasProgressDeadlineSeconds();
    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    int getProgressDeadlineSeconds();
  }
  /**
   *
   *
   * <pre>
   * DeploymentSpec is the specification of the desired behavior of the Deployment.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DeploymentSpec}
   */
  public static final class DeploymentSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DeploymentSpec)
      DeploymentSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentSpec.newBuilder() to construct.
    private DeploymentSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentSpec() {
      replicas_ = 0;
      minReadySeconds_ = 0;
      revisionHistoryLimit_ = 0;
      paused_ = false;
      progressDeadlineSeconds_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                replicas_ = input.readInt32();
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.Meta.LabelSelector.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = selector_.toBuilder();
                }
                selector_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.LabelSelector.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(selector_);
                  selector_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1.PodTemplateSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = template_.toBuilder();
                }
                template_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1.PodTemplateSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(template_);
                  template_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 34:
              {
                io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder subBuilder = null;
                if (((bitField0_ & 0x00000008) == 0x00000008)) {
                  subBuilder = strategy_.toBuilder();
                }
                strategy_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DeploymentStrategy.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(strategy_);
                  strategy_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000008;
                break;
              }
            case 40:
              {
                bitField0_ |= 0x00000010;
                minReadySeconds_ = input.readInt32();
                break;
              }
            case 48:
              {
                bitField0_ |= 0x00000020;
                revisionHistoryLimit_ = input.readInt32();
                break;
              }
            case 56:
              {
                bitField0_ |= 0x00000040;
                paused_ = input.readBool();
                break;
              }
            case 72:
              {
                bitField0_ |= 0x00000080;
                progressDeadlineSeconds_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DeploymentSpec.class,
              io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder.class);
    }

    private int bitField0_;
    public static final int REPLICAS_FIELD_NUMBER = 1;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int SELECTOR_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.Meta.LabelSelector selector_;
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * It must match the pod template's labels.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public boolean hasSelector() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * It must match the pod template's labels.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * It must match the pod template's labels.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }

    public static final int TEMPLATE_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1.PodTemplateSpec template_;
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }

    public static final int STRATEGY_FIELD_NUMBER = 4;
    private io.kubernetes.client.proto.V1Apps.DeploymentStrategy strategy_;
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
     */
    public boolean hasStrategy() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentStrategy getStrategy() {
      return strategy_ == null
          ? io.kubernetes.client.proto.V1Apps.DeploymentStrategy.getDefaultInstance()
          : strategy_;
    }
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentStrategyOrBuilder getStrategyOrBuilder() {
      return strategy_ == null
          ? io.kubernetes.client.proto.V1Apps.DeploymentStrategy.getDefaultInstance()
          : strategy_;
    }

    public static final int MINREADYSECONDS_FIELD_NUMBER = 5;
    private int minReadySeconds_;
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    public boolean hasMinReadySeconds() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    public int getMinReadySeconds() {
      return minReadySeconds_;
    }

    public static final int REVISIONHISTORYLIMIT_FIELD_NUMBER = 6;
    private int revisionHistoryLimit_;
    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    public boolean hasRevisionHistoryLimit() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 10.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    public int getRevisionHistoryLimit() {
      return revisionHistoryLimit_;
    }

    public static final int PAUSED_FIELD_NUMBER = 7;
    private boolean paused_;
    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    public boolean hasPaused() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    public boolean getPaused() {
      return paused_;
    }

    public static final int PROGRESSDEADLINESECONDS_FIELD_NUMBER = 9;
    private int progressDeadlineSeconds_;
    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    public boolean hasProgressDeadlineSeconds() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    public int getProgressDeadlineSeconds() {
      return progressDeadlineSeconds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getTemplate());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, getStrategy());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(5, minReadySeconds_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeInt32(6, revisionHistoryLimit_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(7, paused_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeInt32(9, progressDeadlineSeconds_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTemplate());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStrategy());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, minReadySeconds_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, revisionHistoryLimit_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, paused_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, progressDeadlineSeconds_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DeploymentSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DeploymentSpec other =
          (io.kubernetes.client.proto.V1Apps.DeploymentSpec) obj;

      boolean result = true;
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasSelector() == other.hasSelector());
      if (hasSelector()) {
        result = result && getSelector().equals(other.getSelector());
      }
      result = result && (hasTemplate() == other.hasTemplate());
      if (hasTemplate()) {
        result = result && getTemplate().equals(other.getTemplate());
      }
      result = result && (hasStrategy() == other.hasStrategy());
      if (hasStrategy()) {
        result = result && getStrategy().equals(other.getStrategy());
      }
      result = result && (hasMinReadySeconds() == other.hasMinReadySeconds());
      if (hasMinReadySeconds()) {
        result = result && (getMinReadySeconds() == other.getMinReadySeconds());
      }
      result = result && (hasRevisionHistoryLimit() == other.hasRevisionHistoryLimit());
      if (hasRevisionHistoryLimit()) {
        result = result && (getRevisionHistoryLimit() == other.getRevisionHistoryLimit());
      }
      result = result && (hasPaused() == other.hasPaused());
      if (hasPaused()) {
        result = result && (getPaused() == other.getPaused());
      }
      result = result && (hasProgressDeadlineSeconds() == other.hasProgressDeadlineSeconds());
      if (hasProgressDeadlineSeconds()) {
        result = result && (getProgressDeadlineSeconds() == other.getProgressDeadlineSeconds());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasSelector()) {
        hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getSelector().hashCode();
      }
      if (hasTemplate()) {
        hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
        hash = (53 * hash) + getTemplate().hashCode();
      }
      if (hasStrategy()) {
        hash = (37 * hash) + STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getStrategy().hashCode();
      }
      if (hasMinReadySeconds()) {
        hash = (37 * hash) + MINREADYSECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getMinReadySeconds();
      }
      if (hasRevisionHistoryLimit()) {
        hash = (37 * hash) + REVISIONHISTORYLIMIT_FIELD_NUMBER;
        hash = (53 * hash) + getRevisionHistoryLimit();
      }
      if (hasPaused()) {
        hash = (37 * hash) + PAUSED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPaused());
      }
      if (hasProgressDeadlineSeconds()) {
        hash = (37 * hash) + PROGRESSDEADLINESECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getProgressDeadlineSeconds();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.DeploymentSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentSpec is the specification of the desired behavior of the Deployment.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DeploymentSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DeploymentSpec)
        io.kubernetes.client.proto.V1Apps.DeploymentSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DeploymentSpec.class,
                io.kubernetes.client.proto.V1Apps.DeploymentSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DeploymentSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSelectorFieldBuilder();
          getTemplateFieldBuilder();
          getStrategyFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (selectorBuilder_ == null) {
          selector_ = null;
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (templateBuilder_ == null) {
          template_ = null;
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (strategyBuilder_ == null) {
          strategy_ = null;
        } else {
          strategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        minReadySeconds_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        revisionHistoryLimit_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        paused_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        progressDeadlineSeconds_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DeploymentSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentSpec build() {
        io.kubernetes.client.proto.V1Apps.DeploymentSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentSpec buildPartial() {
        io.kubernetes.client.proto.V1Apps.DeploymentSpec result =
            new io.kubernetes.client.proto.V1Apps.DeploymentSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.replicas_ = replicas_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (selectorBuilder_ == null) {
          result.selector_ = selector_;
        } else {
          result.selector_ = selectorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (templateBuilder_ == null) {
          result.template_ = template_;
        } else {
          result.template_ = templateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (strategyBuilder_ == null) {
          result.strategy_ = strategy_;
        } else {
          result.strategy_ = strategyBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.minReadySeconds_ = minReadySeconds_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.revisionHistoryLimit_ = revisionHistoryLimit_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.paused_ = paused_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.progressDeadlineSeconds_ = progressDeadlineSeconds_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DeploymentSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DeploymentSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DeploymentSpec other) {
        if (other == io.kubernetes.client.proto.V1Apps.DeploymentSpec.getDefaultInstance())
          return this;
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        if (other.hasSelector()) {
          mergeSelector(other.getSelector());
        }
        if (other.hasTemplate()) {
          mergeTemplate(other.getTemplate());
        }
        if (other.hasStrategy()) {
          mergeStrategy(other.getStrategy());
        }
        if (other.hasMinReadySeconds()) {
          setMinReadySeconds(other.getMinReadySeconds());
        }
        if (other.hasRevisionHistoryLimit()) {
          setRevisionHistoryLimit(other.getRevisionHistoryLimit());
        }
        if (other.hasPaused()) {
          setPaused(other.getPaused());
        }
        if (other.hasProgressDeadlineSeconds()) {
          setProgressDeadlineSeconds(other.getProgressDeadlineSeconds());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DeploymentSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DeploymentSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicas_;
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000001;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.LabelSelector selector_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          selectorBuilder_;
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public boolean hasSelector() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
        if (selectorBuilder_ == null) {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        } else {
          return selectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          selector_ = value;
          onChanged();
        } else {
          selectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(
          io.kubernetes.client.proto.Meta.LabelSelector.Builder builderForValue) {
        if (selectorBuilder_ == null) {
          selector_ = builderForValue.build();
          onChanged();
        } else {
          selectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder mergeSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && selector_ != null
              && selector_ != io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()) {
            selector_ =
                io.kubernetes.client.proto.Meta.LabelSelector.newBuilder(selector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            selector_ = value;
          }
          onChanged();
        } else {
          selectorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder clearSelector() {
        if (selectorBuilder_ == null) {
          selector_ = null;
          onChanged();
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector.Builder getSelectorBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
        if (selectorBuilder_ != null) {
          return selectorBuilder_.getMessageOrBuilder();
        } else {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        }
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * It must match the pod template's labels.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          getSelectorFieldBuilder() {
        if (selectorBuilder_ == null) {
          selectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.LabelSelector,
                  io.kubernetes.client.proto.Meta.LabelSelector.Builder,
                  io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>(
                  getSelector(), getParentForChildren(), isClean());
          selector_ = null;
        }
        return selectorBuilder_;
      }

      private io.kubernetes.client.proto.V1.PodTemplateSpec template_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          templateBuilder_;
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public boolean hasTemplate() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
        if (templateBuilder_ == null) {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        } else {
          return templateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          template_ = value;
          onChanged();
        } else {
          templateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(
          io.kubernetes.client.proto.V1.PodTemplateSpec.Builder builderForValue) {
        if (templateBuilder_ == null) {
          template_ = builderForValue.build();
          onChanged();
        } else {
          templateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder mergeTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && template_ != null
              && template_ != io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()) {
            template_ =
                io.kubernetes.client.proto.V1.PodTemplateSpec.newBuilder(template_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            template_ = value;
          }
          onChanged();
        } else {
          templateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder clearTemplate() {
        if (templateBuilder_ == null) {
          template_ = null;
          onChanged();
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec.Builder getTemplateBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTemplateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
        if (templateBuilder_ != null) {
          return templateBuilder_.getMessageOrBuilder();
        } else {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        }
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          getTemplateFieldBuilder() {
        if (templateBuilder_ == null) {
          templateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1.PodTemplateSpec,
                  io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
                  io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>(
                  getTemplate(), getParentForChildren(), isClean());
          template_ = null;
        }
        return templateBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.DeploymentStrategy strategy_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentStrategy,
              io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentStrategyOrBuilder>
          strategyBuilder_;
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public boolean hasStrategy() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentStrategy getStrategy() {
        if (strategyBuilder_ == null) {
          return strategy_ == null
              ? io.kubernetes.client.proto.V1Apps.DeploymentStrategy.getDefaultInstance()
              : strategy_;
        } else {
          return strategyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder setStrategy(io.kubernetes.client.proto.V1Apps.DeploymentStrategy value) {
        if (strategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          strategy_ = value;
          onChanged();
        } else {
          strategyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder setStrategy(
          io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder builderForValue) {
        if (strategyBuilder_ == null) {
          strategy_ = builderForValue.build();
          onChanged();
        } else {
          strategyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder mergeStrategy(io.kubernetes.client.proto.V1Apps.DeploymentStrategy value) {
        if (strategyBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)
              && strategy_ != null
              && strategy_
                  != io.kubernetes.client.proto.V1Apps.DeploymentStrategy.getDefaultInstance()) {
            strategy_ =
                io.kubernetes.client.proto.V1Apps.DeploymentStrategy.newBuilder(strategy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            strategy_ = value;
          }
          onChanged();
        } else {
          strategyBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder clearStrategy() {
        if (strategyBuilder_ == null) {
          strategy_ = null;
          onChanged();
        } else {
          strategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder getStrategyBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getStrategyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentStrategyOrBuilder getStrategyOrBuilder() {
        if (strategyBuilder_ != null) {
          return strategyBuilder_.getMessageOrBuilder();
        } else {
          return strategy_ == null
              ? io.kubernetes.client.proto.V1Apps.DeploymentStrategy.getDefaultInstance()
              : strategy_;
        }
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.DeploymentStrategy strategy = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentStrategy,
              io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentStrategyOrBuilder>
          getStrategyFieldBuilder() {
        if (strategyBuilder_ == null) {
          strategyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DeploymentStrategy,
                  io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder,
                  io.kubernetes.client.proto.V1Apps.DeploymentStrategyOrBuilder>(
                  getStrategy(), getParentForChildren(), isClean());
          strategy_ = null;
        }
        return strategyBuilder_;
      }

      private int minReadySeconds_;
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public boolean hasMinReadySeconds() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public int getMinReadySeconds() {
        return minReadySeconds_;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public Builder setMinReadySeconds(int value) {
        bitField0_ |= 0x00000010;
        minReadySeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public Builder clearMinReadySeconds() {
        bitField0_ = (bitField0_ & ~0x00000010);
        minReadySeconds_ = 0;
        onChanged();
        return this;
      }

      private int revisionHistoryLimit_;
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public boolean hasRevisionHistoryLimit() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public int getRevisionHistoryLimit() {
        return revisionHistoryLimit_;
      }
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public Builder setRevisionHistoryLimit(int value) {
        bitField0_ |= 0x00000020;
        revisionHistoryLimit_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 10.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public Builder clearRevisionHistoryLimit() {
        bitField0_ = (bitField0_ & ~0x00000020);
        revisionHistoryLimit_ = 0;
        onChanged();
        return this;
      }

      private boolean paused_;
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public boolean hasPaused() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public boolean getPaused() {
        return paused_;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public Builder setPaused(boolean value) {
        bitField0_ |= 0x00000040;
        paused_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public Builder clearPaused() {
        bitField0_ = (bitField0_ & ~0x00000040);
        paused_ = false;
        onChanged();
        return this;
      }

      private int progressDeadlineSeconds_;
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public boolean hasProgressDeadlineSeconds() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public int getProgressDeadlineSeconds() {
        return progressDeadlineSeconds_;
      }
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public Builder setProgressDeadlineSeconds(int value) {
        bitField0_ |= 0x00000080;
        progressDeadlineSeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public Builder clearProgressDeadlineSeconds() {
        bitField0_ = (bitField0_ & ~0x00000080);
        progressDeadlineSeconds_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DeploymentSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DeploymentSpec)
    private static final io.kubernetes.client.proto.V1Apps.DeploymentSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DeploymentSpec();
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentSpec> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentSpec>() {
          @java.lang.Override
          public DeploymentSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DeploymentSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DeploymentStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    boolean hasObservedGeneration();
    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    long getObservedGeneration();

    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    boolean hasUpdatedReplicas();
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    int getUpdatedReplicas();

    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    boolean hasReadyReplicas();
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    int getReadyReplicas();

    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    boolean hasAvailableReplicas();
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    int getAvailableReplicas();

    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    boolean hasUnavailableReplicas();
    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    int getUnavailableReplicas();

    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Apps.DeploymentCondition> getConditionsList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentCondition getConditions(int index);
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    int getConditionsCount();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder>
        getConditionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder getConditionsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    boolean hasCollisionCount();
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    int getCollisionCount();
  }
  /**
   *
   *
   * <pre>
   * DeploymentStatus is the most recently observed status of the Deployment.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DeploymentStatus}
   */
  public static final class DeploymentStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DeploymentStatus)
      DeploymentStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentStatus.newBuilder() to construct.
    private DeploymentStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentStatus() {
      observedGeneration_ = 0L;
      replicas_ = 0;
      updatedReplicas_ = 0;
      readyReplicas_ = 0;
      availableReplicas_ = 0;
      unavailableReplicas_ = 0;
      conditions_ = java.util.Collections.emptyList();
      collisionCount_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                observedGeneration_ = input.readInt64();
                break;
              }
            case 16:
              {
                bitField0_ |= 0x00000002;
                replicas_ = input.readInt32();
                break;
              }
            case 24:
              {
                bitField0_ |= 0x00000004;
                updatedReplicas_ = input.readInt32();
                break;
              }
            case 32:
              {
                bitField0_ |= 0x00000010;
                availableReplicas_ = input.readInt32();
                break;
              }
            case 40:
              {
                bitField0_ |= 0x00000020;
                unavailableReplicas_ = input.readInt32();
                break;
              }
            case 50:
              {
                if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                  conditions_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Apps.DeploymentCondition>();
                  mutable_bitField0_ |= 0x00000040;
                }
                conditions_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.DeploymentCondition.PARSER,
                        extensionRegistry));
                break;
              }
            case 56:
              {
                bitField0_ |= 0x00000008;
                readyReplicas_ = input.readInt32();
                break;
              }
            case 64:
              {
                bitField0_ |= 0x00000040;
                collisionCount_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DeploymentStatus.class,
              io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder.class);
    }

    private int bitField0_;
    public static final int OBSERVEDGENERATION_FIELD_NUMBER = 1;
    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    public boolean hasObservedGeneration() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    public long getObservedGeneration() {
      return observedGeneration_;
    }

    public static final int REPLICAS_FIELD_NUMBER = 2;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int UPDATEDREPLICAS_FIELD_NUMBER = 3;
    private int updatedReplicas_;
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    public boolean hasUpdatedReplicas() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    public int getUpdatedReplicas() {
      return updatedReplicas_;
    }

    public static final int READYREPLICAS_FIELD_NUMBER = 7;
    private int readyReplicas_;
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    public boolean hasReadyReplicas() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    public int getReadyReplicas() {
      return readyReplicas_;
    }

    public static final int AVAILABLEREPLICAS_FIELD_NUMBER = 4;
    private int availableReplicas_;
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    public boolean hasAvailableReplicas() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    public int getAvailableReplicas() {
      return availableReplicas_;
    }

    public static final int UNAVAILABLEREPLICAS_FIELD_NUMBER = 5;
    private int unavailableReplicas_;
    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    public boolean hasUnavailableReplicas() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    public int getUnavailableReplicas() {
      return unavailableReplicas_;
    }

    public static final int CONDITIONS_FIELD_NUMBER = 6;
    private java.util.List<io.kubernetes.client.proto.V1Apps.DeploymentCondition> conditions_;
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Apps.DeploymentCondition>
        getConditionsList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder>
        getConditionsOrBuilderList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentCondition getConditions(int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
     */
    public io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder getConditionsOrBuilder(
        int index) {
      return conditions_.get(index);
    }

    public static final int COLLISIONCOUNT_FIELD_NUMBER = 8;
    private int collisionCount_;
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    public boolean hasCollisionCount() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    public int getCollisionCount() {
      return collisionCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt64(1, observedGeneration_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, updatedReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(4, availableReplicas_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeInt32(5, unavailableReplicas_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        output.writeMessage(6, conditions_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(7, readyReplicas_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeInt32(8, collisionCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, observedGeneration_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, updatedReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, availableReplicas_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, unavailableReplicas_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, conditions_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, readyReplicas_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, collisionCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DeploymentStatus)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DeploymentStatus other =
          (io.kubernetes.client.proto.V1Apps.DeploymentStatus) obj;

      boolean result = true;
      result = result && (hasObservedGeneration() == other.hasObservedGeneration());
      if (hasObservedGeneration()) {
        result = result && (getObservedGeneration() == other.getObservedGeneration());
      }
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasUpdatedReplicas() == other.hasUpdatedReplicas());
      if (hasUpdatedReplicas()) {
        result = result && (getUpdatedReplicas() == other.getUpdatedReplicas());
      }
      result = result && (hasReadyReplicas() == other.hasReadyReplicas());
      if (hasReadyReplicas()) {
        result = result && (getReadyReplicas() == other.getReadyReplicas());
      }
      result = result && (hasAvailableReplicas() == other.hasAvailableReplicas());
      if (hasAvailableReplicas()) {
        result = result && (getAvailableReplicas() == other.getAvailableReplicas());
      }
      result = result && (hasUnavailableReplicas() == other.hasUnavailableReplicas());
      if (hasUnavailableReplicas()) {
        result = result && (getUnavailableReplicas() == other.getUnavailableReplicas());
      }
      result = result && getConditionsList().equals(other.getConditionsList());
      result = result && (hasCollisionCount() == other.hasCollisionCount());
      if (hasCollisionCount()) {
        result = result && (getCollisionCount() == other.getCollisionCount());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasObservedGeneration()) {
        hash = (37 * hash) + OBSERVEDGENERATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
      }
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasUpdatedReplicas()) {
        hash = (37 * hash) + UPDATEDREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getUpdatedReplicas();
      }
      if (hasReadyReplicas()) {
        hash = (37 * hash) + READYREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReadyReplicas();
      }
      if (hasAvailableReplicas()) {
        hash = (37 * hash) + AVAILABLEREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getAvailableReplicas();
      }
      if (hasUnavailableReplicas()) {
        hash = (37 * hash) + UNAVAILABLEREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getUnavailableReplicas();
      }
      if (getConditionsCount() > 0) {
        hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionsList().hashCode();
      }
      if (hasCollisionCount()) {
        hash = (37 * hash) + COLLISIONCOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCollisionCount();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.DeploymentStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentStatus is the most recently observed status of the Deployment.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DeploymentStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DeploymentStatus)
        io.kubernetes.client.proto.V1Apps.DeploymentStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DeploymentStatus.class,
                io.kubernetes.client.proto.V1Apps.DeploymentStatus.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DeploymentStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getConditionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        observedGeneration_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        updatedReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        readyReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        availableReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        unavailableReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          conditionsBuilder_.clear();
        }
        collisionCount_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentStatus_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentStatus getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DeploymentStatus.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentStatus build() {
        io.kubernetes.client.proto.V1Apps.DeploymentStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentStatus buildPartial() {
        io.kubernetes.client.proto.V1Apps.DeploymentStatus result =
            new io.kubernetes.client.proto.V1Apps.DeploymentStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.observedGeneration_ = observedGeneration_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.replicas_ = replicas_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.updatedReplicas_ = updatedReplicas_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.readyReplicas_ = readyReplicas_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.availableReplicas_ = availableReplicas_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.unavailableReplicas_ = unavailableReplicas_;
        if (conditionsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)) {
            conditions_ = java.util.Collections.unmodifiableList(conditions_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.conditions_ = conditions_;
        } else {
          result.conditions_ = conditionsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000040;
        }
        result.collisionCount_ = collisionCount_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DeploymentStatus) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DeploymentStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DeploymentStatus other) {
        if (other == io.kubernetes.client.proto.V1Apps.DeploymentStatus.getDefaultInstance())
          return this;
        if (other.hasObservedGeneration()) {
          setObservedGeneration(other.getObservedGeneration());
        }
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        if (other.hasUpdatedReplicas()) {
          setUpdatedReplicas(other.getUpdatedReplicas());
        }
        if (other.hasReadyReplicas()) {
          setReadyReplicas(other.getReadyReplicas());
        }
        if (other.hasAvailableReplicas()) {
          setAvailableReplicas(other.getAvailableReplicas());
        }
        if (other.hasUnavailableReplicas()) {
          setUnavailableReplicas(other.getUnavailableReplicas());
        }
        if (conditionsBuilder_ == null) {
          if (!other.conditions_.isEmpty()) {
            if (conditions_.isEmpty()) {
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureConditionsIsMutable();
              conditions_.addAll(other.conditions_);
            }
            onChanged();
          }
        } else {
          if (!other.conditions_.isEmpty()) {
            if (conditionsBuilder_.isEmpty()) {
              conditionsBuilder_.dispose();
              conditionsBuilder_ = null;
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000040);
              conditionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionsFieldBuilder()
                      : null;
            } else {
              conditionsBuilder_.addAllMessages(other.conditions_);
            }
          }
        }
        if (other.hasCollisionCount()) {
          setCollisionCount(other.getCollisionCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DeploymentStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DeploymentStatus) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private long observedGeneration_;
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public boolean hasObservedGeneration() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public long getObservedGeneration() {
        return observedGeneration_;
      }
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public Builder setObservedGeneration(long value) {
        bitField0_ |= 0x00000001;
        observedGeneration_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public Builder clearObservedGeneration() {
        bitField0_ = (bitField0_ & ~0x00000001);
        observedGeneration_ = 0L;
        onChanged();
        return this;
      }

      private int replicas_;
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000002;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000002);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private int updatedReplicas_;
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public boolean hasUpdatedReplicas() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public int getUpdatedReplicas() {
        return updatedReplicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public Builder setUpdatedReplicas(int value) {
        bitField0_ |= 0x00000004;
        updatedReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public Builder clearUpdatedReplicas() {
        bitField0_ = (bitField0_ & ~0x00000004);
        updatedReplicas_ = 0;
        onChanged();
        return this;
      }

      private int readyReplicas_;
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public boolean hasReadyReplicas() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public int getReadyReplicas() {
        return readyReplicas_;
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public Builder setReadyReplicas(int value) {
        bitField0_ |= 0x00000008;
        readyReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public Builder clearReadyReplicas() {
        bitField0_ = (bitField0_ & ~0x00000008);
        readyReplicas_ = 0;
        onChanged();
        return this;
      }

      private int availableReplicas_;
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public boolean hasAvailableReplicas() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public int getAvailableReplicas() {
        return availableReplicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public Builder setAvailableReplicas(int value) {
        bitField0_ |= 0x00000010;
        availableReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public Builder clearAvailableReplicas() {
        bitField0_ = (bitField0_ & ~0x00000010);
        availableReplicas_ = 0;
        onChanged();
        return this;
      }

      private int unavailableReplicas_;
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public boolean hasUnavailableReplicas() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public int getUnavailableReplicas() {
        return unavailableReplicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public Builder setUnavailableReplicas(int value) {
        bitField0_ |= 0x00000020;
        unavailableReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public Builder clearUnavailableReplicas() {
        bitField0_ = (bitField0_ & ~0x00000020);
        unavailableReplicas_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<io.kubernetes.client.proto.V1Apps.DeploymentCondition> conditions_ =
          java.util.Collections.emptyList();

      private void ensureConditionsIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          conditions_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.DeploymentCondition>(
                  conditions_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentCondition,
              io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder>
          conditionsBuilder_;

      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.DeploymentCondition>
          getConditionsList() {
        if (conditionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditions_);
        } else {
          return conditionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public int getConditionsCount() {
        if (conditionsBuilder_ == null) {
          return conditions_.size();
        } else {
          return conditionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentCondition getConditions(int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder setConditions(
          int index, io.kubernetes.client.proto.V1Apps.DeploymentCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.set(index, value);
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder setConditions(
          int index,
          io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(io.kubernetes.client.proto.V1Apps.DeploymentCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(
          int index, io.kubernetes.client.proto.V1Apps.DeploymentCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(index, value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(
          io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(
          int index,
          io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addAllConditions(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Apps.DeploymentCondition>
              values) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
          onChanged();
        } else {
          conditionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder clearConditions() {
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          conditionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public Builder removeConditions(int index) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.remove(index);
          onChanged();
        } else {
          conditionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder getConditionsBuilder(
          int index) {
        return getConditionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder getConditionsOrBuilder(
          int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder>
          getConditionsOrBuilderList() {
        if (conditionsBuilder_ != null) {
          return conditionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder addConditionsBuilder() {
        return getConditionsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Apps.DeploymentCondition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder addConditionsBuilder(
          int index) {
        return getConditionsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Apps.DeploymentCondition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.DeploymentCondition conditions = 6;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder>
          getConditionsBuilderList() {
        return getConditionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.DeploymentCondition,
              io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder,
              io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder>
          getConditionsFieldBuilder() {
        if (conditionsBuilder_ == null) {
          conditionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.DeploymentCondition,
                  io.kubernetes.client.proto.V1Apps.DeploymentCondition.Builder,
                  io.kubernetes.client.proto.V1Apps.DeploymentConditionOrBuilder>(
                  conditions_,
                  ((bitField0_ & 0x00000040) == 0x00000040),
                  getParentForChildren(),
                  isClean());
          conditions_ = null;
        }
        return conditionsBuilder_;
      }

      private int collisionCount_;
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public boolean hasCollisionCount() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public int getCollisionCount() {
        return collisionCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public Builder setCollisionCount(int value) {
        bitField0_ |= 0x00000080;
        collisionCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public Builder clearCollisionCount() {
        bitField0_ = (bitField0_ & ~0x00000080);
        collisionCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DeploymentStatus)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DeploymentStatus)
    private static final io.kubernetes.client.proto.V1Apps.DeploymentStatus DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DeploymentStatus();
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStatus getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentStatus> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentStatus>() {
          @java.lang.Override
          public DeploymentStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentStatus(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DeploymentStatus getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.DeploymentStrategy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    boolean hasRollingUpdate();
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment getRollingUpdate();
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.RollingUpdateDeploymentOrBuilder getRollingUpdateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * DeploymentStrategy describes how to replace existing pods with new ones.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.DeploymentStrategy}
   */
  public static final class DeploymentStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.DeploymentStrategy)
      DeploymentStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentStrategy.newBuilder() to construct.
    private DeploymentStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentStrategy() {
      type_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentStrategy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = rollingUpdate_.toBuilder();
                }
                rollingUpdate_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(rollingUpdate_);
                  rollingUpdate_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_DeploymentStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.DeploymentStrategy.class,
              io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLLINGUPDATE_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment rollingUpdate_;
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    public boolean hasRollingUpdate() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment getRollingUpdate() {
      return rollingUpdate_ == null
          ? io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.getDefaultInstance()
          : rollingUpdate_;
    }
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.RollingUpdateDeploymentOrBuilder
        getRollingUpdateOrBuilder() {
      return rollingUpdate_ == null
          ? io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.getDefaultInstance()
          : rollingUpdate_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getRollingUpdate());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRollingUpdate());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.DeploymentStrategy)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.DeploymentStrategy other =
          (io.kubernetes.client.proto.V1Apps.DeploymentStrategy) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasRollingUpdate() == other.hasRollingUpdate());
      if (hasRollingUpdate()) {
        result = result && getRollingUpdate().equals(other.getRollingUpdate());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasRollingUpdate()) {
        hash = (37 * hash) + ROLLINGUPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getRollingUpdate().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Apps.DeploymentStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentStrategy describes how to replace existing pods with new ones.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.DeploymentStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.DeploymentStrategy)
        io.kubernetes.client.proto.V1Apps.DeploymentStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.DeploymentStrategy.class,
                io.kubernetes.client.proto.V1Apps.DeploymentStrategy.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.DeploymentStrategy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRollingUpdateFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = null;
        } else {
          rollingUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_DeploymentStrategy_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentStrategy getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.DeploymentStrategy.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentStrategy build() {
        io.kubernetes.client.proto.V1Apps.DeploymentStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.DeploymentStrategy buildPartial() {
        io.kubernetes.client.proto.V1Apps.DeploymentStrategy result =
            new io.kubernetes.client.proto.V1Apps.DeploymentStrategy(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (rollingUpdateBuilder_ == null) {
          result.rollingUpdate_ = rollingUpdate_;
        } else {
          result.rollingUpdate_ = rollingUpdateBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.DeploymentStrategy) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.DeploymentStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.DeploymentStrategy other) {
        if (other == io.kubernetes.client.proto.V1Apps.DeploymentStrategy.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasRollingUpdate()) {
          mergeRollingUpdate(other.getRollingUpdate());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.DeploymentStrategy parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.DeploymentStrategy) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment rollingUpdate_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.Builder,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDeploymentOrBuilder>
          rollingUpdateBuilder_;
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public boolean hasRollingUpdate() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment getRollingUpdate() {
        if (rollingUpdateBuilder_ == null) {
          return rollingUpdate_ == null
              ? io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.getDefaultInstance()
              : rollingUpdate_;
        } else {
          return rollingUpdateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder setRollingUpdate(
          io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment value) {
        if (rollingUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollingUpdate_ = value;
          onChanged();
        } else {
          rollingUpdateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder setRollingUpdate(
          io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.Builder builderForValue) {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = builderForValue.build();
          onChanged();
        } else {
          rollingUpdateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder mergeRollingUpdate(
          io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment value) {
        if (rollingUpdateBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && rollingUpdate_ != null
              && rollingUpdate_
                  != io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment
                      .getDefaultInstance()) {
            rollingUpdate_ =
                io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.newBuilder(rollingUpdate_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rollingUpdate_ = value;
          }
          onChanged();
        } else {
          rollingUpdateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder clearRollingUpdate() {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = null;
          onChanged();
        } else {
          rollingUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.Builder
          getRollingUpdateBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRollingUpdateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.RollingUpdateDeploymentOrBuilder
          getRollingUpdateOrBuilder() {
        if (rollingUpdateBuilder_ != null) {
          return rollingUpdateBuilder_.getMessageOrBuilder();
        } else {
          return rollingUpdate_ == null
              ? io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.getDefaultInstance()
              : rollingUpdate_;
        }
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.Builder,
              io.kubernetes.client.proto.V1Apps.RollingUpdateDeploymentOrBuilder>
          getRollingUpdateFieldBuilder() {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment,
                  io.kubernetes.client.proto.V1Apps.RollingUpdateDeployment.Builder,
                  io.kubernetes.client.proto.V1Apps.RollingUpdateDeploymentOrBuilder>(
                  getRollingUpdate(), getParentForChildren(), isClean());
          rollingUpdate_ = null;
        }
        return rollingUpdateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.DeploymentStrategy)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.DeploymentStrategy)
    private static final io.kubernetes.client.proto.V1Apps.DeploymentStrategy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.DeploymentStrategy();
    }

    public static io.kubernetes.client.proto.V1Apps.DeploymentStrategy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentStrategy> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentStrategy>() {
          @java.lang.Override
          public DeploymentStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentStrategy(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.DeploymentStrategy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReplicaSetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.ReplicaSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If the Labels of a ReplicaSet are empty, they are defaulted to
     * be the same as the Pod(s) that the ReplicaSet manages.
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * If the Labels of a ReplicaSet are empty, they are defaulted to
     * be the same as the Pod(s) that the ReplicaSet manages.
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * If the Labels of a ReplicaSet are empty, they are defaulted to
     * be the same as the Pod(s) that the ReplicaSet manages.
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Spec defines the specification of the desired behavior of the ReplicaSet.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * Spec defines the specification of the desired behavior of the ReplicaSet.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSetSpec getSpec();
    /**
     *
     *
     * <pre>
     * Spec defines the specification of the desired behavior of the ReplicaSet.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSetSpecOrBuilder getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Status is the most recently observed status of the ReplicaSet.
     * This data may be out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status is the most recently observed status of the ReplicaSet.
     * This data may be out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSetStatus getStatus();
    /**
     *
     *
     * <pre>
     * Status is the most recently observed status of the ReplicaSet.
     * This data may be out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSetStatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * ReplicaSet ensures that a specified number of pod replicas are running at any given time.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSet}
   */
  public static final class ReplicaSet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.ReplicaSet)
      ReplicaSetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReplicaSet.newBuilder() to construct.
    private ReplicaSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReplicaSet() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ReplicaSet(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = status_.toBuilder();
                }
                status_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(status_);
                  status_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.ReplicaSet.class,
              io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * If the Labels of a ReplicaSet are empty, they are defaulted to
     * be the same as the Pod(s) that the ReplicaSet manages.
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * If the Labels of a ReplicaSet are empty, they are defaulted to
     * be the same as the Pod(s) that the ReplicaSet manages.
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * If the Labels of a ReplicaSet are empty, they are defaulted to
     * be the same as the Pod(s) that the ReplicaSet manages.
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Apps.ReplicaSetSpec spec_;
    /**
     *
     *
     * <pre>
     * Spec defines the specification of the desired behavior of the ReplicaSet.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Spec defines the specification of the desired behavior of the ReplicaSet.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSetSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * Spec defines the specification of the desired behavior of the ReplicaSet.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSetSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.getDefaultInstance()
          : spec_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1Apps.ReplicaSetStatus status_;
    /**
     *
     *
     * <pre>
     * Status is the most recently observed status of the ReplicaSet.
     * This data may be out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Status is the most recently observed status of the ReplicaSet.
     * This data may be out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSetStatus getStatus() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * Status is the most recently observed status of the ReplicaSet.
     * This data may be out of date by some window of time.
     * Populated by the system.
     * Read-only.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSetStatusOrBuilder getStatusOrBuilder() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getStatus());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStatus());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.ReplicaSet)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.ReplicaSet other =
          (io.kubernetes.client.proto.V1Apps.ReplicaSet) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.ReplicaSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReplicaSet ensures that a specified number of pod replicas are running at any given time.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.ReplicaSet)
        io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.ReplicaSet.class,
                io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.ReplicaSet.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSet_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSet getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.ReplicaSet.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSet build() {
        io.kubernetes.client.proto.V1Apps.ReplicaSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSet buildPartial() {
        io.kubernetes.client.proto.V1Apps.ReplicaSet result =
            new io.kubernetes.client.proto.V1Apps.ReplicaSet(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.ReplicaSet) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.ReplicaSet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.ReplicaSet other) {
        if (other == io.kubernetes.client.proto.V1Apps.ReplicaSet.getDefaultInstance()) return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.ReplicaSet parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.kubernetes.client.proto.V1Apps.ReplicaSet) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * If the Labels of a ReplicaSet are empty, they are defaulted to
       * be the same as the Pod(s) that the ReplicaSet manages.
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.ReplicaSetSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpec,
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder,
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1Apps.ReplicaSetSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1Apps.ReplicaSetSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_ != io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Spec defines the specification of the desired behavior of the ReplicaSet.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpec,
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder,
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.ReplicaSetSpec,
                  io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder,
                  io.kubernetes.client.proto.V1Apps.ReplicaSetSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.kubernetes.client.proto.V1Apps.ReplicaSetStatus status_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatus,
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder,
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public Builder setStatus(io.kubernetes.client.proto.V1Apps.ReplicaSetStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public Builder setStatus(
          io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public Builder mergeStatus(io.kubernetes.client.proto.V1Apps.ReplicaSetStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && status_ != null
              && status_
                  != io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.getDefaultInstance()) {
            status_ =
                io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.newBuilder(status_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder getStatusBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetStatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * Status is the most recently observed status of the ReplicaSet.
       * This data may be out of date by some window of time.
       * Populated by the system.
       * Read-only.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1.ReplicaSetStatus status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatus,
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder,
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.ReplicaSetStatus,
                  io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder,
                  io.kubernetes.client.proto.V1Apps.ReplicaSetStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.ReplicaSet)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.ReplicaSet)
    private static final io.kubernetes.client.proto.V1Apps.ReplicaSet DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.ReplicaSet();
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ReplicaSet> PARSER =
        new com.google.protobuf.AbstractParser<ReplicaSet>() {
          @java.lang.Override
          public ReplicaSet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ReplicaSet(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ReplicaSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReplicaSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.ReplicaSet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReplicaSetConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.ReplicaSetCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of replica set condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of replica set condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of replica set condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    java.lang.String getStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    com.google.protobuf.ByteString getStatusBytes();

    /**
     *
     *
     * <pre>
     * The last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    boolean hasLastTransitionTime();
    /**
     *
     *
     * <pre>
     * The last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    io.kubernetes.client.proto.Meta.Time getLastTransitionTime();
    /**
     *
     *
     * <pre>
     * The last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    boolean hasReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    java.lang.String getReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    com.google.protobuf.ByteString getReasonBytes();

    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    boolean hasMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * ReplicaSetCondition describes the state of a replica set at a certain point.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetCondition}
   */
  public static final class ReplicaSetCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.ReplicaSetCondition)
      ReplicaSetConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReplicaSetCondition.newBuilder() to construct.
    private ReplicaSetCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReplicaSetCondition() {
      type_ = "";
      status_ = "";
      reason_ = "";
      message_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ReplicaSetCondition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                status_ = bs;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.Meta.Time.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = lastTransitionTime_.toBuilder();
                }
                lastTransitionTime_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.Time.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(lastTransitionTime_);
                  lastTransitionTime_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 34:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                reason_ = bs;
                break;
              }
            case 42:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                message_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.class,
              io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of replica set condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of replica set condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of replica set condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private volatile java.lang.Object status_;
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          status_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LASTTRANSITIONTIME_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.Meta.Time lastTransitionTime_;
    /**
     *
     *
     * <pre>
     * The last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public boolean hasLastTransitionTime() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * The last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }
    /**
     *
     *
     * <pre>
     * The last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }

    public static final int REASON_FIELD_NUMBER = 4;
    private volatile java.lang.Object reason_;
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public boolean hasReason() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          reason_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MESSAGE_FIELD_NUMBER = 5;
    private volatile java.lang.Object message_;
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          message_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, status_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getLastTransitionTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reason_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, message_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, status_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLastTransitionTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reason_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, message_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetCondition)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.ReplicaSetCondition other =
          (io.kubernetes.client.proto.V1Apps.ReplicaSetCondition) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && (hasLastTransitionTime() == other.hasLastTransitionTime());
      if (hasLastTransitionTime()) {
        result = result && getLastTransitionTime().equals(other.getLastTransitionTime());
      }
      result = result && (hasReason() == other.hasReason());
      if (hasReason()) {
        result = result && getReason().equals(other.getReason());
      }
      result = result && (hasMessage() == other.hasMessage());
      if (hasMessage()) {
        result = result && getMessage().equals(other.getMessage());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (hasLastTransitionTime()) {
        hash = (37 * hash) + LASTTRANSITIONTIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastTransitionTime().hashCode();
      }
      if (hasReason()) {
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + getReason().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Apps.ReplicaSetCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReplicaSetCondition describes the state of a replica set at a certain point.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.ReplicaSetCondition)
        io.kubernetes.client.proto.V1Apps.ReplicaSetConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.class,
                io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLastTransitionTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        reason_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        message_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetCondition_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetCondition getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetCondition build() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetCondition buildPartial() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetCondition result =
            new io.kubernetes.client.proto.V1Apps.ReplicaSetCondition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (lastTransitionTimeBuilder_ == null) {
          result.lastTransitionTime_ = lastTransitionTime_;
        } else {
          result.lastTransitionTime_ = lastTransitionTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.reason_ = reason_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.message_ = message_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetCondition) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.ReplicaSetCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.ReplicaSetCondition other) {
        if (other == io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasStatus()) {
          bitField0_ |= 0x00000002;
          status_ = other.status_;
          onChanged();
        }
        if (other.hasLastTransitionTime()) {
          mergeLastTransitionTime(other.getLastTransitionTime());
        }
        if (other.hasReason()) {
          bitField0_ |= 0x00000008;
          reason_ = other.reason_;
          onChanged();
        }
        if (other.hasMessage()) {
          bitField0_ |= 0x00000010;
          message_ = other.message_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.ReplicaSetCondition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.ReplicaSetCondition) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of replica set condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of replica set condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of replica set condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of replica set condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of replica set condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of replica set condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object status_ = "";
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public java.lang.String getStatus() {
        java.lang.Object ref = status_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            status_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public com.google.protobuf.ByteString getStatusBytes() {
        java.lang.Object ref = status_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          status_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatus(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = getDefaultInstance().getStatus();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatusBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.Time lastTransitionTime_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          lastTransitionTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public boolean hasLastTransitionTime() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        } else {
          return lastTransitionTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder setLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastTransitionTime_ = value;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder setLastTransitionTime(
          io.kubernetes.client.proto.Meta.Time.Builder builderForValue) {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = builderForValue.build();
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder mergeLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && lastTransitionTime_ != null
              && lastTransitionTime_ != io.kubernetes.client.proto.Meta.Time.getDefaultInstance()) {
            lastTransitionTime_ =
                io.kubernetes.client.proto.Meta.Time.newBuilder(lastTransitionTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastTransitionTime_ = value;
          }
          onChanged();
        } else {
          lastTransitionTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder clearLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.Time.Builder getLastTransitionTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLastTransitionTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
        if (lastTransitionTimeBuilder_ != null) {
          return lastTransitionTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          getLastTransitionTimeFieldBuilder() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.Time,
                  io.kubernetes.client.proto.Meta.Time.Builder,
                  io.kubernetes.client.proto.Meta.TimeOrBuilder>(
                  getLastTransitionTime(), getParentForChildren(), isClean());
          lastTransitionTime_ = null;
        }
        return lastTransitionTimeBuilder_;
      }

      private java.lang.Object reason_ = "";
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public boolean hasReason() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public java.lang.String getReason() {
        java.lang.Object ref = reason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            reason_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public com.google.protobuf.ByteString getReasonBytes() {
        java.lang.Object ref = reason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        reason_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder clearReason() {
        bitField0_ = (bitField0_ & ~0x00000008);
        reason_ = getDefaultInstance().getReason();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        reason_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            message_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        message_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000010);
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        message_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.ReplicaSetCondition)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.ReplicaSetCondition)
    private static final io.kubernetes.client.proto.V1Apps.ReplicaSetCondition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.ReplicaSetCondition();
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ReplicaSetCondition> PARSER =
        new com.google.protobuf.AbstractParser<ReplicaSetCondition>() {
          @java.lang.Override
          public ReplicaSetCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ReplicaSetCondition(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ReplicaSetCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReplicaSetCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.ReplicaSetCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReplicaSetListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.ReplicaSetList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSet> getItemsList();
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSet getItems(int index);
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * ReplicaSetList is a collection of ReplicaSets.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetList}
   */
  public static final class ReplicaSetList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.ReplicaSetList)
      ReplicaSetListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReplicaSetList.newBuilder() to construct.
    private ReplicaSetList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReplicaSetList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ReplicaSetList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.ReplicaSet>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.ReplicaSet.PARSER, extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.ReplicaSetList.class,
              io.kubernetes.client.proto.V1Apps.ReplicaSetList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSet> items_;
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSet> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSet getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of ReplicaSets.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder getItemsOrBuilder(int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.ReplicaSetList other =
          (io.kubernetes.client.proto.V1Apps.ReplicaSetList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.ReplicaSetList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReplicaSetList is a collection of ReplicaSets.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.ReplicaSetList)
        io.kubernetes.client.proto.V1Apps.ReplicaSetListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.ReplicaSetList.class,
                io.kubernetes.client.proto.V1Apps.ReplicaSetList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.ReplicaSetList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.ReplicaSetList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetList build() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetList buildPartial() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetList result =
            new io.kubernetes.client.proto.V1Apps.ReplicaSetList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetList) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.ReplicaSetList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.ReplicaSetList other) {
        if (other == io.kubernetes.client.proto.V1Apps.ReplicaSetList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.ReplicaSetList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.ReplicaSetList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSet> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.ReplicaSet>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ReplicaSet,
              io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder,
              io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSet> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSet getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder setItems(int index, io.kubernetes.client.proto.V1Apps.ReplicaSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Apps.ReplicaSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder addItems(int index, io.kubernetes.client.proto.V1Apps.ReplicaSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Apps.ReplicaSet> values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder getItemsBuilder(int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder getItemsOrBuilder(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Apps.ReplicaSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder addItemsBuilder(int index) {
        return getItemsFieldBuilder()
            .addBuilder(index, io.kubernetes.client.proto.V1Apps.ReplicaSet.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of ReplicaSets.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSet items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ReplicaSet,
              io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder,
              io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Apps.ReplicaSet,
                  io.kubernetes.client.proto.V1Apps.ReplicaSet.Builder,
                  io.kubernetes.client.proto.V1Apps.ReplicaSetOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.ReplicaSetList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.ReplicaSetList)
    private static final io.kubernetes.client.proto.V1Apps.ReplicaSetList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.ReplicaSetList();
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ReplicaSetList> PARSER =
        new com.google.protobuf.AbstractParser<ReplicaSetList>() {
          @java.lang.Override
          public ReplicaSetList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ReplicaSetList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ReplicaSetList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReplicaSetList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.ReplicaSetList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReplicaSetSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.ReplicaSetSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Replicas is the number of desired replicas.
     * This is a pointer to distinguish between explicit zero and unspecified.
     * Defaults to 1.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * Replicas is the number of desired replicas.
     * This is a pointer to distinguish between explicit zero and unspecified.
     * Defaults to 1.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    boolean hasMinReadySeconds();
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    int getMinReadySeconds();

    /**
     *
     *
     * <pre>
     * Selector is a label query over pods that should match the replica count.
     * Label keys and values that must match in order to be controlled by this replica set.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    boolean hasSelector();
    /**
     *
     *
     * <pre>
     * Selector is a label query over pods that should match the replica count.
     * Label keys and values that must match in order to be controlled by this replica set.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelector getSelector();
    /**
     *
     *
     * <pre>
     * Selector is a label query over pods that should match the replica count.
     * Label keys and values that must match in order to be controlled by this replica set.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * Template is the object that describes the pod that will be created if
     * insufficient replicas are detected.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    boolean hasTemplate();
    /**
     *
     *
     * <pre>
     * Template is the object that describes the pod that will be created if
     * insufficient replicas are detected.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate();
    /**
     *
     *
     * <pre>
     * Template is the object that describes the pod that will be created if
     * insufficient replicas are detected.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * ReplicaSetSpec is the specification of a ReplicaSet.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetSpec}
   */
  public static final class ReplicaSetSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.ReplicaSetSpec)
      ReplicaSetSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReplicaSetSpec.newBuilder() to construct.
    private ReplicaSetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReplicaSetSpec() {
      replicas_ = 0;
      minReadySeconds_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ReplicaSetSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                replicas_ = input.readInt32();
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.Meta.LabelSelector.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = selector_.toBuilder();
                }
                selector_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.LabelSelector.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(selector_);
                  selector_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1.PodTemplateSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000008) == 0x00000008)) {
                  subBuilder = template_.toBuilder();
                }
                template_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1.PodTemplateSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(template_);
                  template_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000008;
                break;
              }
            case 32:
              {
                bitField0_ |= 0x00000002;
                minReadySeconds_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.class,
              io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder.class);
    }

    private int bitField0_;
    public static final int REPLICAS_FIELD_NUMBER = 1;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * Replicas is the number of desired replicas.
     * This is a pointer to distinguish between explicit zero and unspecified.
     * Defaults to 1.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Replicas is the number of desired replicas.
     * This is a pointer to distinguish between explicit zero and unspecified.
     * Defaults to 1.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int MINREADYSECONDS_FIELD_NUMBER = 4;
    private int minReadySeconds_;
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    public boolean hasMinReadySeconds() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 4;</code>
     */
    public int getMinReadySeconds() {
      return minReadySeconds_;
    }

    public static final int SELECTOR_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.Meta.LabelSelector selector_;
    /**
     *
     *
     * <pre>
     * Selector is a label query over pods that should match the replica count.
     * Label keys and values that must match in order to be controlled by this replica set.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public boolean hasSelector() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Selector is a label query over pods that should match the replica count.
     * Label keys and values that must match in order to be controlled by this replica set.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }
    /**
     *
     *
     * <pre>
     * Selector is a label query over pods that should match the replica count.
     * Label keys and values that must match in order to be controlled by this replica set.
     * It must match the pod template's labels.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }

    public static final int TEMPLATE_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1.PodTemplateSpec template_;
    /**
     *
     *
     * <pre>
     * Template is the object that describes the pod that will be created if
     * insufficient replicas are detected.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * Template is the object that describes the pod that will be created if
     * insufficient replicas are detected.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }
    /**
     *
     *
     * <pre>
     * Template is the object that describes the pod that will be created if
     * insufficient replicas are detected.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(2, getSelector());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(3, getTemplate());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(4, minReadySeconds_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSelector());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTemplate());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, minReadySeconds_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.ReplicaSetSpec other =
          (io.kubernetes.client.proto.V1Apps.ReplicaSetSpec) obj;

      boolean result = true;
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasMinReadySeconds() == other.hasMinReadySeconds());
      if (hasMinReadySeconds()) {
        result = result && (getMinReadySeconds() == other.getMinReadySeconds());
      }
      result = result && (hasSelector() == other.hasSelector());
      if (hasSelector()) {
        result = result && getSelector().equals(other.getSelector());
      }
      result = result && (hasTemplate() == other.hasTemplate());
      if (hasTemplate()) {
        result = result && getTemplate().equals(other.getTemplate());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasMinReadySeconds()) {
        hash = (37 * hash) + MINREADYSECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getMinReadySeconds();
      }
      if (hasSelector()) {
        hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getSelector().hashCode();
      }
      if (hasTemplate()) {
        hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
        hash = (53 * hash) + getTemplate().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.ReplicaSetSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReplicaSetSpec is the specification of a ReplicaSet.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.ReplicaSetSpec)
        io.kubernetes.client.proto.V1Apps.ReplicaSetSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.class,
                io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSelectorFieldBuilder();
          getTemplateFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        minReadySeconds_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (selectorBuilder_ == null) {
          selector_ = null;
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (templateBuilder_ == null) {
          template_ = null;
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetSpec build() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetSpec buildPartial() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetSpec result =
            new io.kubernetes.client.proto.V1Apps.ReplicaSetSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.replicas_ = replicas_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.minReadySeconds_ = minReadySeconds_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (selectorBuilder_ == null) {
          result.selector_ = selector_;
        } else {
          result.selector_ = selectorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (templateBuilder_ == null) {
          result.template_ = template_;
        } else {
          result.template_ = templateBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.ReplicaSetSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.ReplicaSetSpec other) {
        if (other == io.kubernetes.client.proto.V1Apps.ReplicaSetSpec.getDefaultInstance())
          return this;
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        if (other.hasMinReadySeconds()) {
          setMinReadySeconds(other.getMinReadySeconds());
        }
        if (other.hasSelector()) {
          mergeSelector(other.getSelector());
        }
        if (other.hasTemplate()) {
          mergeTemplate(other.getTemplate());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.ReplicaSetSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.ReplicaSetSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicas_;
      /**
       *
       *
       * <pre>
       * Replicas is the number of desired replicas.
       * This is a pointer to distinguish between explicit zero and unspecified.
       * Defaults to 1.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Replicas is the number of desired replicas.
       * This is a pointer to distinguish between explicit zero and unspecified.
       * Defaults to 1.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * Replicas is the number of desired replicas.
       * This is a pointer to distinguish between explicit zero and unspecified.
       * Defaults to 1.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000001;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Replicas is the number of desired replicas.
       * This is a pointer to distinguish between explicit zero and unspecified.
       * Defaults to 1.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private int minReadySeconds_;
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public boolean hasMinReadySeconds() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public int getMinReadySeconds() {
        return minReadySeconds_;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public Builder setMinReadySeconds(int value) {
        bitField0_ |= 0x00000002;
        minReadySeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 4;</code>
       */
      public Builder clearMinReadySeconds() {
        bitField0_ = (bitField0_ & ~0x00000002);
        minReadySeconds_ = 0;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.LabelSelector selector_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          selectorBuilder_;
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public boolean hasSelector() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
        if (selectorBuilder_ == null) {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        } else {
          return selectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          selector_ = value;
          onChanged();
        } else {
          selectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(
          io.kubernetes.client.proto.Meta.LabelSelector.Builder builderForValue) {
        if (selectorBuilder_ == null) {
          selector_ = builderForValue.build();
          onChanged();
        } else {
          selectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder mergeSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && selector_ != null
              && selector_ != io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()) {
            selector_ =
                io.kubernetes.client.proto.Meta.LabelSelector.newBuilder(selector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            selector_ = value;
          }
          onChanged();
        } else {
          selectorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder clearSelector() {
        if (selectorBuilder_ == null) {
          selector_ = null;
          onChanged();
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector.Builder getSelectorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
        if (selectorBuilder_ != null) {
          return selectorBuilder_.getMessageOrBuilder();
        } else {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        }
      }
      /**
       *
       *
       * <pre>
       * Selector is a label query over pods that should match the replica count.
       * Label keys and values that must match in order to be controlled by this replica set.
       * It must match the pod template's labels.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          getSelectorFieldBuilder() {
        if (selectorBuilder_ == null) {
          selectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.LabelSelector,
                  io.kubernetes.client.proto.Meta.LabelSelector.Builder,
                  io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>(
                  getSelector(), getParentForChildren(), isClean());
          selector_ = null;
        }
        return selectorBuilder_;
      }

      private io.kubernetes.client.proto.V1.PodTemplateSpec template_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          templateBuilder_;
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public boolean hasTemplate() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
        if (templateBuilder_ == null) {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        } else {
          return templateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          template_ = value;
          onChanged();
        } else {
          templateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(
          io.kubernetes.client.proto.V1.PodTemplateSpec.Builder builderForValue) {
        if (templateBuilder_ == null) {
          template_ = builderForValue.build();
          onChanged();
        } else {
          templateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder mergeTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)
              && template_ != null
              && template_ != io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()) {
            template_ =
                io.kubernetes.client.proto.V1.PodTemplateSpec.newBuilder(template_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            template_ = value;
          }
          onChanged();
        } else {
          templateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder clearTemplate() {
        if (templateBuilder_ == null) {
          template_ = null;
          onChanged();
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec.Builder getTemplateBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getTemplateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
        if (templateBuilder_ != null) {
          return templateBuilder_.getMessageOrBuilder();
        } else {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        }
      }
      /**
       *
       *
       * <pre>
       * Template is the object that describes the pod that will be created if
       * insufficient replicas are detected.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          getTemplateFieldBuilder() {
        if (templateBuilder_ == null) {
          templateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1.PodTemplateSpec,
                  io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
                  io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>(
                  getTemplate(), getParentForChildren(), isClean());
          template_ = null;
        }
        return templateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1.ReplicaSetSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1.ReplicaSetSpec)
    private static final io.kubernetes.client.proto.V1Apps.ReplicaSetSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Apps.ReplicaSetSpec();
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ReplicaSetSpec> PARSER =
        new com.google.protobuf.AbstractParser<ReplicaSetSpec>() {
          @java.lang.Override
          public ReplicaSetSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ReplicaSetSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ReplicaSetSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReplicaSetSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Apps.ReplicaSetSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReplicaSetStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1.ReplicaSetStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Replicas is the most recently oberved number of replicas.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * Replicas is the most recently oberved number of replicas.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * The number of pods that have labels matching the labels of the pod template of the replicaset.
     * +optional
     * </pre>
     *
     * <code>optional int32 fullyLabeledReplicas = 2;</code>
     */
    boolean hasFullyLabeledReplicas();
    /**
     *
     *
     * <pre>
     * The number of pods that have labels matching the labels of the pod template of the replicaset.
     * +optional
     * </pre>
     *
     * <code>optional int32 fullyLabeledReplicas = 2;</code>
     */
    int getFullyLabeledReplicas();

    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 4;</code>
     */
    boolean hasReadyReplicas();
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 4;</code>
     */
    int getReadyReplicas();

    /**
     *
     *
     * <pre>
     * The number of available replicas (ready for at least minReadySeconds) for this replica set.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 5;</code>
     */
    boolean hasAvailableReplicas();
    /**
     *
     *
     * <pre>
     * The number of available replicas (ready for at least minReadySeconds) for this replica set.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 5;</code>
     */
    int getAvailableReplicas();

    /**
     *
     *
     * <pre>
     * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 3;</code>
     */
    boolean hasObservedGeneration();
    /**
     *
     *
     * <pre>
     * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 3;</code>
     */
    long getObservedGeneration();

    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSetCondition> getConditionsList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSetCondition getConditions(int index);
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    int getConditionsCount();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Apps.ReplicaSetConditionOrBuilder>
        getConditionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    io.kubernetes.client.proto.V1Apps.ReplicaSetConditionOrBuilder getConditionsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * ReplicaSetStatus represents the current status of a ReplicaSet.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetStatus}
   */
  public static final class ReplicaSetStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1.ReplicaSetStatus)
      ReplicaSetStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReplicaSetStatus.newBuilder() to construct.
    private ReplicaSetStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReplicaSetStatus() {
      replicas_ = 0;
      fullyLabeledReplicas_ = 0;
      readyReplicas_ = 0;
      availableReplicas_ = 0;
      observedGeneration_ = 0L;
      conditions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ReplicaSetStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                replicas_ = input.readInt32();
                break;
              }
            case 16:
              {
                bitField0_ |= 0x00000002;
                fullyLabeledReplicas_ = input.readInt32();
                break;
              }
            case 24:
              {
                bitField0_ |= 0x00000010;
                observedGeneration_ = input.readInt64();
                break;
              }
            case 32:
              {
                bitField0_ |= 0x00000004;
                readyReplicas_ = input.readInt32();
                break;
              }
            case 40:
              {
                bitField0_ |= 0x00000008;
                availableReplicas_ = input.readInt32();
                break;
              }
            case 50:
              {
                if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                  conditions_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Apps.ReplicaSetCondition>();
                  mutable_bitField0_ |= 0x00000020;
                }
                conditions_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Apps
          .internal_static_k8s_io_api_apps_v1_ReplicaSetStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.class,
              io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder.class);
    }

    private int bitField0_;
    public static final int REPLICAS_FIELD_NUMBER = 1;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * Replicas is the most recently oberved number of replicas.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Replicas is the most recently oberved number of replicas.
     * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int FULLYLABELEDREPLICAS_FIELD_NUMBER = 2;
    private int fullyLabeledReplicas_;
    /**
     *
     *
     * <pre>
     * The number of pods that have labels matching the labels of the pod template of the replicaset.
     * +optional
     * </pre>
     *
     * <code>optional int32 fullyLabeledReplicas = 2;</code>
     */
    public boolean hasFullyLabeledReplicas() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * The number of pods that have labels matching the labels of the pod template of the replicaset.
     * +optional
     * </pre>
     *
     * <code>optional int32 fullyLabeledReplicas = 2;</code>
     */
    public int getFullyLabeledReplicas() {
      return fullyLabeledReplicas_;
    }

    public static final int READYREPLICAS_FIELD_NUMBER = 4;
    private int readyReplicas_;
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 4;</code>
     */
    public boolean hasReadyReplicas() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 4;</code>
     */
    public int getReadyReplicas() {
      return readyReplicas_;
    }

    public static final int AVAILABLEREPLICAS_FIELD_NUMBER = 5;
    private int availableReplicas_;
    /**
     *
     *
     * <pre>
     * The number of available replicas (ready for at least minReadySeconds) for this replica set.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 5;</code>
     */
    public boolean hasAvailableReplicas() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * The number of available replicas (ready for at least minReadySeconds) for this replica set.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 5;</code>
     */
    public int getAvailableReplicas() {
      return availableReplicas_;
    }

    public static final int OBSERVEDGENERATION_FIELD_NUMBER = 3;
    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 3;</code>
     */
    public boolean hasObservedGeneration() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 3;</code>
     */
    public long getObservedGeneration() {
      return observedGeneration_;
    }

    public static final int CONDITIONS_FIELD_NUMBER = 6;
    private java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSetCondition> conditions_;
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSetCondition>
        getConditionsList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Apps.ReplicaSetConditionOrBuilder>
        getConditionsOrBuilderList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSetCondition getConditions(int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a replica set's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
     */
    public io.kubernetes.client.proto.V1Apps.ReplicaSetConditionOrBuilder getConditionsOrBuilder(
        int index) {
      return conditions_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, fullyLabeledReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt64(3, observedGeneration_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(4, readyReplicas_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(5, availableReplicas_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        output.writeMessage(6, conditions_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, fullyLabeledReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, observedGeneration_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, readyReplicas_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, availableReplicas_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, conditions_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetStatus)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Apps.ReplicaSetStatus other =
          (io.kubernetes.client.proto.V1Apps.ReplicaSetStatus) obj;

      boolean result = true;
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasFullyLabeledReplicas() == other.hasFullyLabeledReplicas());
      if (hasFullyLabeledReplicas()) {
        result = result && (getFullyLabeledReplicas() == other.getFullyLabeledReplicas());
      }
      result = result && (hasReadyReplicas() == other.hasReadyReplicas());
      if (hasReadyReplicas()) {
        result = result && (getReadyReplicas() == other.getReadyReplicas());
      }
      result = result && (hasAvailableReplicas() == other.hasAvailableReplicas());
      if (hasAvailableReplicas()) {
        result = result && (getAvailableReplicas() == other.getAvailableReplicas());
      }
      result = result && (hasObservedGeneration() == other.hasObservedGeneration());
      if (hasObservedGeneration()) {
        result = result && (getObservedGeneration() == other.getObservedGeneration());
      }
      result = result && getConditionsList().equals(other.getConditionsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasFullyLabeledReplicas()) {
        hash = (37 * hash) + FULLYLABELEDREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getFullyLabeledReplicas();
      }
      if (hasReadyReplicas()) {
        hash = (37 * hash) + READYREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReadyReplicas();
      }
      if (hasAvailableReplicas()) {
        hash = (37 * hash) + AVAILABLEREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getAvailableReplicas();
      }
      if (hasObservedGeneration()) {
        hash = (37 * hash) + OBSERVEDGENERATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
      }
      if (getConditionsCount() > 0) {
        hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Apps.ReplicaSetStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReplicaSetStatus represents the current status of a ReplicaSet.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1.ReplicaSetStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1.ReplicaSetStatus)
        io.kubernetes.client.proto.V1Apps.ReplicaSetStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.class,
                io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getConditionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        fullyLabeledReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        readyReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        availableReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        observedGeneration_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          conditionsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Apps
            .internal_static_k8s_io_api_apps_v1_ReplicaSetStatus_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetStatus getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetStatus build() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Apps.ReplicaSetStatus buildPartial() {
        io.kubernetes.client.proto.V1Apps.ReplicaSetStatus result =
            new io.kubernetes.client.proto.V1Apps.ReplicaSetStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.replicas_ = replicas_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.fullyLabeledReplicas_ = fullyLabeledReplicas_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.readyReplicas_ = readyReplicas_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.availableReplicas_ = availableReplicas_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.observedGeneration_ = observedGeneration_;
        if (conditionsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020)) {
            conditions_ = java.util.Collections.unmodifiableList(conditions_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.conditions_ = conditions_;
        } else {
          result.conditions_ = conditionsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Apps.ReplicaSetStatus) {
          return mergeFrom((io.kubernetes.client.proto.V1Apps.ReplicaSetStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Apps.ReplicaSetStatus other) {
        if (other == io.kubernetes.client.proto.V1Apps.ReplicaSetStatus.getDefaultInstance())
          return this;
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        if (other.hasFullyLabeledReplicas()) {
          setFullyLabeledReplicas(other.getFullyLabeledReplicas());
        }
        if (other.hasReadyReplicas()) {
          setReadyReplicas(other.getReadyReplicas());
        }
        if (other.hasAvailableReplicas()) {
          setAvailableReplicas(other.getAvailableReplicas());
        }
        if (other.hasObservedGeneration()) {
          setObservedGeneration(other.getObservedGeneration());
        }
        if (conditionsBuilder_ == null) {
          if (!other.conditions_.isEmpty()) {
            if (conditions_.isEmpty()) {
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureConditionsIsMutable();
              conditions_.addAll(other.conditions_);
            }
            onChanged();
          }
        } else {
          if (!other.conditions_.isEmpty()) {
            if (conditionsBuilder_.isEmpty()) {
              conditionsBuilder_.dispose();
              conditionsBuilder_ = null;
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000020);
              conditionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionsFieldBuilder()
                      : null;
            } else {
              conditionsBuilder_.addAllMessages(other.conditions_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Apps.ReplicaSetStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Apps.ReplicaSetStatus) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicas_;
      /**
       *
       *
       * <pre>
       * Replicas is the most recently oberved number of replicas.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Replicas is the most recently oberved number of replicas.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * Replicas is the most recently oberved number of replicas.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000001;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Replicas is the most recently oberved number of replicas.
       * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private int fullyLabeledReplicas_;
      /**
       *
       *
       * <pre>
       * The number of pods that have labels matching the labels of the pod template of the replicaset.
       * +optional
       * </pre>
       *
       * <code>optional int32 fullyLabeledReplicas = 2;</code>
       */
      public boolean hasFullyLabeledReplicas() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * The number of pods that have labels matching the labels of the pod template of the replicaset.
       * +optional
       * </pre>
       *
       * <code>optional int32 fullyLabeledReplicas = 2;</code>
       */
      public int getFullyLabeledReplicas() {
        return fullyLabeledReplicas_;
      }
      /**
       *
       *
       * <pre>
       * The number of pods that have labels matching the labels of the pod template of the replicaset.
       * +optional
       * </pre>
       *
       * <code>optional int32 fullyLabeledReplicas = 2;</code>
       */
      public Builder setFullyLabeledReplicas(int value) {
        bitField0_ |= 0x00000002;
        fullyLabeledReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pods that have labels matching the labels of the pod template of the replicaset.
       * +optional
       * </pre>
       *
       * <code>optional int32 fullyLabeledReplicas = 2;</code>
       */
      public Builder clearFullyLabeledReplicas() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fullyLabeledReplicas_ = 0;
        onChanged();
        return this;
      }

      private int readyReplicas_;
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 4;</code>
       */
      public boolean hasReadyReplicas() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 4;</code>
       */
      public int getReadyReplicas() {
        return readyReplicas_;
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 4;</code>
       */
      public Builder setReadyReplicas(int value) {
        bitField0_ |= 0x00000004;
        readyReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 4;</code>
       */
      public Builder clearReadyReplicas() {
        bitField0_ = (bitField0_ & ~0x00000004);
        readyReplicas_ = 0;
        onChanged();
        return this;
      }

      private int availableReplicas_;
      /**
       *
       *
       * <pre>
       * The number of available replicas (ready for at least minReadySeconds) for this replica set.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 5;</code>
       */
      public boolean hasAvailableReplicas() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * The number of available replicas (ready for at least minReadySeconds) for this replica set.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 5;</code>
       */
      public int getAvailableReplicas() {
        return availableReplicas_;
      }
      /**
       *
       *
       * <pre>
       * The number of available replicas (ready for at least minReadySeconds) for this replica set.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 5;</code>
       */
      public Builder setAvailableReplicas(int value) {
        bitField0_ |= 0x00000008;
        availableReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of available replicas (ready for at least minReadySeconds) for this replica set.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 5;</code>
       */
      public Builder clearAvailableReplicas() {
        bitField0_ = (bitField0_ & ~0x00000008);
        availableReplicas_ = 0;
        onChanged();
        return this;
      }

      private long observedGeneration_;
      /**
       *
       *
       * <pre>
       * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 3;</code>
       */
      public boolean hasObservedGeneration() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 3;</code>
       */
      public long getObservedGeneration() {
        return observedGeneration_;
      }
      /**
       *
       *
       * <pre>
       * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 3;</code>
       */
      public Builder setObservedGeneration(long value) {
        bitField0_ |= 0x00000010;
        observedGeneration_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 3;</code>
       */
      public Builder clearObservedGeneration() {
        bitField0_ = (bitField0_ & ~0x00000010);
        observedGeneration_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSetCondition> conditions_ =
          java.util.Collections.emptyList();

      private void ensureConditionsIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          conditions_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Apps.ReplicaSetCondition>(
                  conditions_);
          bitField0_ |= 0x00000020;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Apps.ReplicaSetCondition,
              io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.Builder,
              io.kubernetes.client.proto.V1Apps.ReplicaSetConditionOrBuilder>
          conditionsBuilder_;

      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a replica set's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Apps.ReplicaSetCondition>
          getConditionsList() {
        if (conditionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditions_);
        } else {
          return conditionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a replica set's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
       */
      public int getConditionsCount() {
        if (conditionsBuilder_ == null) {
          return conditions_.size();
        } else {
          return conditionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a replica set's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1Apps.ReplicaSetCondition getConditions(int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a replica set's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
       */
      public Builder setConditions(
          int index, io.kubernetes.client.proto.V1Apps.ReplicaSetCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.set(index, value);
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a replica set's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
       */
      public Builder setConditions(
          int index,
          io.kubernetes.client.proto.V1Apps.ReplicaSetCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a replica set's current state.
       * +optional
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1.ReplicaSetCondition conditions = 6;</code>
       */
      public Builder addConditions(io.kubernetes.client.proto.V1Apps.ReplicaSetCondition value) {
        if (conditionsBuilder_ == null) {
 