/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.ApiClient;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.SSLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.net.ssl.KeyManager;
import org.apache.log4j.Logger;

public class Config {
    public static final String SERVICEACCOUNT_ROOT = "/var/run/secrets/kubernetes.io/serviceaccount";
    public static final String SERVICEACCOUNT_CA_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String SERVICEACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String ENV_KUBECONFIG = "KUBECONFIG";
    public static final String ENV_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    public static final String ENV_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
    public static final String DEFAULT_FALLBACK_HOST = "http://localhost:8080";
    private static final Logger log = Logger.getLogger(Config.class);

    public static ApiClient fromCluster() throws IOException {
        String host = System.getenv(ENV_SERVICE_HOST);
        String port = System.getenv(ENV_SERVICE_PORT);
        FileInputStream caCert = new FileInputStream(SERVICEACCOUNT_CA_PATH);
        BufferedReader tokenReader = new BufferedReader(new FileReader(SERVICEACCOUNT_TOKEN_PATH));
        StringBuilder builder = new StringBuilder();
        String line = tokenReader.readLine();
        while (line != null) {
            builder.append(line);
            line = tokenReader.readLine();
        }
        ApiClient result = new ApiClient();
        result.setBasePath("https://" + host + ":" + port);
        result.setSslCaCert((InputStream)caCert);
        result.setAccessToken(builder.toString());
        return result;
    }

    public static ApiClient fromUrl(String url) {
        return Config.fromUrl(url, true);
    }

    public static ApiClient fromUrl(String url, boolean validateSSL) {
        return new ApiClient().setBasePath(url).setVerifyingSsl(validateSSL);
    }

    public static ApiClient fromUserPassword(String url, String user, String password) {
        return Config.fromUserPassword(url, user, password, true);
    }

    public static ApiClient fromUserPassword(String url, String user, String password, boolean validateSSL) {
        ApiClient client = Config.fromUrl(url, validateSSL);
        client.setUsername(user);
        client.setPassword(password);
        return client;
    }

    public static ApiClient fromToken(String url, String token) {
        return Config.fromToken(url, token, true);
    }

    public static ApiClient fromToken(String url, String token, boolean validateSSL) {
        ApiClient client = Config.fromUrl(url, validateSSL);
        client.setAccessToken(token);
        return client;
    }

    public static ApiClient fromConfig(String fileName) throws IOException {
        return Config.fromConfig(new FileReader(fileName));
    }

    public static ApiClient fromConfig(InputStream stream) {
        return Config.fromConfig(new InputStreamReader(stream));
    }

    public static ApiClient fromConfig(Reader input) {
        String password;
        String username;
        KubeConfig config = KubeConfig.loadKubeConfig(input);
        ApiClient client = new ApiClient();
        client.setBasePath(config.getServer());
        try {
            KeyManager[] mgrs = SSLUtils.keyManagers(config.getClientCertificateData(), config.getClientCertificateFile(), config.getClientKeyData(), config.getClientKeyFile(), "RSA", "", null, null);
            client.setKeyManagers(mgrs);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to invoke build key managers", (Throwable)ex);
        }
        if (config.verifySSL()) {
            String caCert = config.getCertificateAuthorityData();
            String caCertFile = config.getCertificateAuthorityFile();
            if (caCert != null || caCertFile != null) {
                try {
                    client.setSslCaCert(SSLUtils.getInputStreamFromDataOrFile(caCert, caCertFile));
                }
                catch (FileNotFoundException ex) {
                    log.error((Object)"Failed to find CA Cert file", (Throwable)ex);
                }
            }
        } else {
            client.setVerifyingSsl(false);
        }
        String token = config.getAccessToken();
        if (token != null) {
            client.setApiKey("Bearer " + token);
        }
        if ((username = config.getUsername()) != null) {
            client.setUsername(username);
        }
        if ((password = config.getPassword()) != null) {
            client.setPassword(password);
        }
        return client;
    }

    public static ApiClient defaultClient() throws IOException {
        String kubeConfig = System.getenv(ENV_KUBECONFIG);
        if (kubeConfig != null) {
            return Config.fromConfig(new FileReader(kubeConfig));
        }
        File config = new File(new File(System.getenv("HOME"), ".kube"), "config");
        if (config.exists()) {
            return Config.fromConfig(new FileReader(config));
        }
        File clusterCA = new File(SERVICEACCOUNT_CA_PATH);
        if (clusterCA.exists()) {
            return Config.fromCluster();
        }
        ApiClient client = new ApiClient();
        client.setBasePath(DEFAULT_FALLBACK_HOST);
        return client;
    }
}

