/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.eks.AWS4STSSigner;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EKSAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(EKSAuthentication.class);
    private static final int MAX_EXPIRY_SECONDS = 900;
    private final AWSSessionCredentialsProvider provider;
    private final String region;
    private final String clusterName;
    private final int expirySeconds;

    public EKSAuthentication(AWSSessionCredentialsProvider provider, String region, String clusterName) {
        this(provider, region, clusterName, 900);
    }

    public EKSAuthentication(AWSSessionCredentialsProvider provider, String region, String clusterName, int expirySeconds) {
        this.provider = provider;
        this.region = region;
        this.clusterName = clusterName;
        if (expirySeconds > 900) {
            expirySeconds = 900;
        }
        this.expirySeconds = expirySeconds;
    }

    @Override
    public void provide(ApiClient client) {
        URI uri = URI.create("https://sts." + this.region + ".amazonaws.com/");
        AWSSessionCredentials cred = this.provider.getCredentials();
        try {
            AWS4STSSigner signer = new AWS4STSSigner(uri.toURL(), "GET", "sts", this.region);
            String token = "k8s-aws-v1." + Base64.getEncoder().withoutPadding().encodeToString(signer.computeSignature(uri, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("x-k8s-aws-id", EKSAuthentication.this.clusterName);
                }
            }, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("Action", "GetCallerIdentity");
                    this.put("Version", "2011-06-15");
                }
            }, this.expirySeconds, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", cred.getAWSAccessKeyId(), cred.getAWSSecretKey(), cred.getSessionToken()).getBytes());
            client.setApiKeyPrefix("Bearer");
            client.setApiKey(token);
            log.info("Generated BEARER token for ApiClient, expiring at {}", (Object)Instant.now().plus((long)this.expirySeconds, ChronoUnit.SECONDS));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

