/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.OptionsBase;
import io.kurrent.dbclient.PersistentSubscriptionSettings;
import io.kurrent.dbclient.UnsupportedFeatureException;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractUpdatePersistentSubscription {
    private final GrpcClient client;
    private final String group;
    private final PersistentSubscriptionSettings settings;
    private final OptionsBase<?> options;
    private static final Logger logger = LoggerFactory.getLogger(AbstractUpdatePersistentSubscription.class);

    public AbstractUpdatePersistentSubscription(GrpcClient client, String group, PersistentSubscriptionSettings settings, OptionsBase<?> options) {
        this.client = client;
        this.group = group;
        this.settings = settings;
        this.options = options;
    }

    protected Persistent.UpdateReq.Settings.Builder createSettings() {
        return Persistent.UpdateReq.Settings.newBuilder();
    }

    protected abstract Persistent.UpdateReq.Options.Builder createOptions();

    public CompletableFuture execute() {
        return this.client.runWithArgs(args -> {
            CompletableFuture result = new CompletableFuture();
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), this.client.getSettings(), this.options);
            Persistent.UpdateReq.Settings.Builder settingsBuilder = this.createSettings();
            settingsBuilder.setResolveLinks(this.settings.shouldResolveLinkTos()).setReadBatchSize(this.settings.getReadBatchSize()).setMinCheckpointCount(this.settings.getCheckpointLowerBound()).setMaxCheckpointCount(this.settings.getCheckpointUpperBound()).setMessageTimeoutMs(this.settings.getMessageTimeoutMs()).setMaxSubscriberCount(this.settings.getMaxSubscriberCount()).setMaxRetryCount(this.settings.getMaxRetryCount()).setLiveBufferSize(this.settings.getLiveBufferSize()).setHistoryBufferSize(this.settings.getHistoryBufferSize()).setExtraStatistics(this.settings.isExtraStatistics()).setCheckpointAfterMs(this.settings.getCheckpointAfterInMs());
            if (this.settings.getNamedConsumerStrategy().isDispatchToSingle()) {
                settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.DispatchToSingle);
            } else if (this.settings.getNamedConsumerStrategy().isRoundRobin()) {
                settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.RoundRobin);
            } else if (this.settings.getNamedConsumerStrategy().isPinned()) {
                settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.Pinned);
            } else {
                logger.error(String.format("Unsupported named consumer strategy: '%s'", this.settings.getNamedConsumerStrategy().toString()));
                throw new UnsupportedFeatureException();
            }
            Persistent.UpdateReq req = Persistent.UpdateReq.newBuilder().setOptions(this.createOptions().setSettings(settingsBuilder).setGroupName(this.group)).build();
            if (req.getOptions().hasAll() && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeatureException());
            } else {
                client.update(req, (StreamObserver<Persistent.UpdateResp>)GrpcUtils.convertSingleResponse(result));
            }
            return result;
        });
    }
}

