/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.AppendToStreamOptions;
import io.kurrent.dbclient.ClientTelemetry;
import io.kurrent.dbclient.EventData;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.NotLeaderException;
import io.kurrent.dbclient.Position;
import io.kurrent.dbclient.StreamState;
import io.kurrent.dbclient.WriteResult;
import io.kurrent.dbclient.WrongExpectedVersionException;
import io.kurrent.dbclient.proto.shared.Shared;
import io.kurrent.dbclient.proto.streams.StreamsGrpc;
import io.kurrent.dbclient.proto.streams.StreamsOuterClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class AppendToStream {
    private final GrpcClient client;
    private final String streamName;
    private final List<EventData> events;
    private final AppendToStreamOptions options;

    public AppendToStream(GrpcClient client, String streamName, Iterator<EventData> events, AppendToStreamOptions options) {
        this.client = client;
        this.streamName = streamName;
        this.events = new ArrayList<EventData>();
        while (events.hasNext()) {
            this.events.add(events.next());
        }
        this.options = options;
    }

    public CompletableFuture<WriteResult> execute() {
        return this.client.run(channel -> ClientTelemetry.traceAppend(this::append, channel, this.events, this.streamName, this.client.getSettings(), this.options.getCredentials()));
    }

    private CompletableFuture<WriteResult> append(ManagedChannel channel, List<EventData> events) {
        CompletableFuture<WriteResult> result = new CompletableFuture<WriteResult>();
        StreamsOuterClass.AppendReq.Options.Builder options = this.options.getStreamState().applyOnWire(StreamsOuterClass.AppendReq.Options.newBuilder().setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)this.streamName)).build()));
        StreamsGrpc.StreamsStub client = GrpcUtils.configureStub(StreamsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
        StreamObserver<StreamsOuterClass.AppendReq> requestStream = client.append((StreamObserver<StreamsOuterClass.AppendResp>)GrpcUtils.convertSingleResponse(result, resp -> {
            if (resp.hasSuccess()) {
                StreamsOuterClass.AppendResp.Success success = resp.getSuccess();
                Position logPosition = null;
                if (success.getPositionOptionCase() == StreamsOuterClass.AppendResp.Success.PositionOptionCase.POSITION) {
                    StreamsOuterClass.AppendResp.Position p = success.getPosition();
                    logPosition = new Position(p.getCommitPosition(), p.getPreparePosition());
                }
                StreamState nextExpectedRevision = success.hasNoStream() ? StreamState.noStream() : StreamState.streamRevision(success.getCurrentRevision());
                return new WriteResult(nextExpectedRevision, logPosition);
            }
            if (resp.hasWrongExpectedVersion()) {
                StreamsOuterClass.AppendResp.WrongExpectedVersion wev = resp.getWrongExpectedVersion();
                StreamState expectedRevision = wev.getExpectedRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.ExpectedRevisionOptionCase.EXPECTED_ANY ? StreamState.any() : (wev.getExpectedRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.ExpectedRevisionOptionCase.EXPECTED_STREAM_EXISTS ? StreamState.streamExists() : StreamState.streamRevision(wev.getExpectedRevision()));
                StreamState streamState = wev.getCurrentRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.CurrentRevisionOptionCase.CURRENT_NO_STREAM ? StreamState.noStream() : StreamState.streamRevision(wev.getCurrentRevision());
                String streamName = options.getStreamIdentifier().getStreamName().toStringUtf8();
                throw new WrongExpectedVersionException(streamName, expectedRevision, streamState);
            }
            throw new IllegalStateException("AppendResponse has neither Success or WrongExpectedVersion variants");
        }));
        try {
            requestStream.onNext((Object)StreamsOuterClass.AppendReq.newBuilder().setOptions(options).build());
            for (EventData e : events) {
                StreamsOuterClass.AppendReq.ProposedMessage.Builder msgBuilder = StreamsOuterClass.AppendReq.ProposedMessage.newBuilder().setId(Shared.UUID.newBuilder().setStructured(Shared.UUID.Structured.newBuilder().setMostSignificantBits(e.getEventId().getMostSignificantBits()).setLeastSignificantBits(e.getEventId().getLeastSignificantBits()))).setData(ByteString.copyFrom((byte[])e.getEventData())).putMetadata("content-type", e.getContentType()).putMetadata("type", e.getEventType());
                if (e.getUserMetadata() != null) {
                    msgBuilder.setCustomMetadata(ByteString.copyFrom((byte[])e.getUserMetadata()));
                }
                requestStream.onNext((Object)StreamsOuterClass.AppendReq.newBuilder().setProposedMessage(msgBuilder).build());
            }
            requestStream.onCompleted();
        }
        catch (StatusRuntimeException e) {
            String leaderHost = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            String leaderPort = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            if (leaderHost != null && leaderPort != null) {
                NotLeaderException reason = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                result.completeExceptionally(reason);
            } else {
                result.completeExceptionally(e);
            }
        }
        catch (RuntimeException e) {
            result.completeExceptionally(e);
        }
        return result;
    }
}

