/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.ClusterInfo;
import io.kurrent.dbclient.ConnectionState;
import io.kurrent.dbclient.Discovery;
import io.kurrent.dbclient.GossipClient;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.NoClusterNodeFoundException;
import io.kurrent.dbclient.NodeSelector;
import io.kurrent.dbclient.resolution.DeferredNodeResolution;
import io.kurrent.dbclient.resolution.DeprecatedNodeResolution;
import io.kurrent.dbclient.resolution.FixedSeedsNodeResolution;
import io.kurrent.dbclient.resolution.NodeResolution;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterDiscovery
implements Discovery {
    private static final Logger logger = LoggerFactory.getLogger(ClusterDiscovery.class);
    private final NodeSelector nodeSelector;
    private final NodeResolution resolution;

    ClusterDiscovery(KurrentDBClientSettings settings) {
        this.nodeSelector = new NodeSelector(settings.getNodePreference());
        this.resolution = settings.isDnsDiscover() ? (settings.getFeatures().contains("dns-lookup") ? new DeprecatedNodeResolution(settings.getHosts()[0]) : new DeferredNodeResolution(settings.getHosts()[0])) : new FixedSeedsNodeResolution(settings.getHosts());
    }

    private static CompletableFuture<Optional<ClusterInfo.Member>> attemptDiscovery(NodeSelector selector, ConnectionState factory, InetSocketAddress seed) {
        factory.connect(seed);
        GossipClient client = new GossipClient(factory.getSettings(), factory.getCurrentChannel());
        return client.read().thenApply(info -> {
            if (factory.getLastConnectedEndpoint() != null) {
                info.getMembers().removeIf(member -> member.getHttpEndpoint().equals(factory.getLastConnectedEndpoint()));
            }
            return selector.determineBestFitNode((ClusterInfo)info);
        });
    }

    @Override
    public CompletableFuture<Void> run(ConnectionState state) {
        return CompletableFuture.runAsync(() -> this.discover(state));
    }

    void discover(ConnectionState state) {
        List<InetSocketAddress> candidates = this.resolution.resolve();
        if (candidates.size() > 1) {
            Collections.shuffle(candidates);
            if (state.getLastConnectedEndpoint() != null) {
                candidates.removeIf(candidate -> candidate.equals(state.getLastConnectedEndpoint()));
            }
        }
        for (InetSocketAddress seed : candidates) {
            logger.debug("Using seed node [{}] for cluster node discovery.", (Object)seed);
            try {
                Optional<ClusterInfo.Member> optionalMember = ClusterDiscovery.attemptDiscovery(this.nodeSelector, state, seed).get(state.getSettings().getGossipTimeout(), TimeUnit.MILLISECONDS);
                if (!optionalMember.isPresent()) continue;
                ClusterInfo.Member member = optionalMember.get();
                if (!member.getHttpEndpoint().equals(state.getLastConnectedEndpoint())) {
                    state.connect(member.getHttpEndpoint());
                }
                logger.debug("Selected cluster node [{}] in state [{}] for connection attempt.", (Object)member.getHttpEndpoint(), (Object)member.getState());
                return;
            }
            catch (ExecutionException | TimeoutException e) {
                logger.error("Exception during the node selection process", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new NoClusterNodeFoundException();
    }
}

