/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.CreateProjectionOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.UpdateProjection;
import io.kurrent.dbclient.UpdateProjectionOptions;
import io.kurrent.dbclient.proto.projections.Projectionmanagement;
import io.kurrent.dbclient.proto.projections.ProjectionsGrpc;
import java.util.concurrent.CompletableFuture;

class CreateProjection {
    private final GrpcClient client;
    private final String projectionName;
    private final String query;
    private final boolean trackEmittedStreams;
    private final boolean emitEnabled;
    private final CreateProjectionOptions options;

    public CreateProjection(GrpcClient client, String projectionName, String query, CreateProjectionOptions options) {
        this.client = client;
        this.projectionName = projectionName;
        this.query = query;
        this.trackEmittedStreams = options.isTrackingEmittedStreams();
        this.emitEnabled = options.isEmitEnabled();
        this.options = options;
    }

    public CompletableFuture execute() {
        return this.client.run(channel -> {
            Projectionmanagement.CreateReq.Options.Continuous.Builder continuousBuilder = Projectionmanagement.CreateReq.Options.Continuous.newBuilder().setName(this.projectionName).setTrackEmittedStreams(this.trackEmittedStreams);
            Projectionmanagement.CreateReq.Options.Builder optionsBuilder = Projectionmanagement.CreateReq.Options.newBuilder().setQuery(this.query).setContinuous(continuousBuilder);
            Projectionmanagement.CreateReq request = Projectionmanagement.CreateReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            CompletableFuture result = new CompletableFuture();
            client.create(request, (StreamObserver<Projectionmanagement.CreateResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        }).thenApplyAsync(result -> {
            if (this.emitEnabled) {
                UpdateProjectionOptions options = UpdateProjectionOptions.get().emitEnabled(true);
                UpdateProjection update = new UpdateProjection(this.client, this.projectionName, this.query, options);
                return update.execute().thenApply(x -> result);
            }
            return CompletableFuture.completedFuture(result);
        });
    }
}

