/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.DeleteResult;
import io.kurrent.dbclient.DeleteStreamOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.Position;
import io.kurrent.dbclient.proto.shared.Shared;
import io.kurrent.dbclient.proto.streams.StreamsGrpc;
import io.kurrent.dbclient.proto.streams.StreamsOuterClass;
import java.util.concurrent.CompletableFuture;

class DeleteStream {
    private final GrpcClient client;
    private final String streamName;
    private final boolean softDelete;
    private final DeleteStreamOptions options;

    public DeleteStream(GrpcClient client, String streamName, boolean softDelete, DeleteStreamOptions options) {
        this.client = client;
        this.streamName = streamName;
        this.softDelete = softDelete;
        this.options = options;
    }

    public CompletableFuture<DeleteResult> execute() {
        return this.client.run(channel -> {
            StreamsGrpc.StreamsStub client = GrpcUtils.configureStub(StreamsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            if (this.softDelete) {
                StreamsOuterClass.DeleteReq req = StreamsOuterClass.DeleteReq.newBuilder().setOptions(this.options.getStreamState().applyOnWire(StreamsOuterClass.DeleteReq.Options.newBuilder().setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)this.streamName)).build()))).build();
                CompletableFuture result = new CompletableFuture();
                client.delete(req, (StreamObserver<StreamsOuterClass.DeleteResp>)GrpcUtils.convertSingleResponse(result, resp -> {
                    long commitUnsigned = resp.getPosition().getCommitPosition();
                    long prepareUnsigned = resp.getPosition().getPreparePosition();
                    return new DeleteResult(new Position(commitUnsigned, prepareUnsigned));
                }));
                return result;
            }
            StreamsOuterClass.TombstoneReq req = StreamsOuterClass.TombstoneReq.newBuilder().setOptions(this.options.getStreamState().applyOnWire(StreamsOuterClass.TombstoneReq.Options.newBuilder().setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)this.streamName)).build()))).build();
            CompletableFuture result = new CompletableFuture();
            client.tombstone(req, (StreamObserver<StreamsOuterClass.TombstoneResp>)GrpcUtils.convertSingleResponse(result, resp -> {
                long commitUnsigned = resp.getPosition().getCommitPosition();
                long prepareUnsigned = resp.getPosition().getPreparePosition();
                return new DeleteResult(new Position(commitUnsigned, prepareUnsigned));
            }));
            return result;
        });
    }
}

