/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.EventData;
import java.util.UUID;

public class EventDataBuilder {
    private byte[] eventData;
    private byte[] metadata;
    private String eventType;
    private boolean isJson;
    private UUID id;

    EventDataBuilder() {
    }

    public static EventDataBuilder json(String eventType, byte[] eventData) {
        return EventDataBuilder.json(null, eventType, eventData);
    }

    public static EventDataBuilder json(UUID id, String eventType, byte[] eventData) {
        return EventDataBuilder.binary(id, eventType, eventData, true);
    }

    public static EventDataBuilder binary(String eventType, byte[] eventData) {
        return EventDataBuilder.binary(null, eventType, eventData);
    }

    public static EventDataBuilder binary(UUID id, String eventType, byte[] eventData) {
        return EventDataBuilder.binary(id, eventType, eventData, false);
    }

    public static EventDataBuilder binary(UUID id, String eventType, byte[] eventData, boolean isJson) {
        EventDataBuilder self = new EventDataBuilder();
        self.eventData = eventData;
        self.eventType = eventType;
        self.isJson = isJson;
        self.id = id;
        return self;
    }

    public EventDataBuilder eventId(UUID id) {
        this.id = id;
        return this;
    }

    public EventDataBuilder metadataAsBytes(byte[] value) {
        this.metadata = value;
        return this;
    }

    public EventData build() {
        UUID eventId = this.id == null ? UUID.randomUUID() : this.id;
        String contentType = this.isJson ? "application/json" : "application/octet-stream";
        return new EventData(eventId, this.eventType, contentType, this.eventData, this.metadata);
    }
}

