/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GetProjectionStateOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.ThrowingBiFunction;
import io.kurrent.dbclient.ThrowingFunction;
import io.kurrent.dbclient.proto.projections.Projectionmanagement;
import io.kurrent.dbclient.proto.projections.ProjectionsGrpc;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

class GetProjectionState<TResult> {
    private final GrpcClient client;
    private final String projectionName;
    private final GetProjectionStateOptions options;
    private ThrowingBiFunction<JsonMapper, String, TResult, JsonProcessingException> deserializationStrategy;

    GetProjectionState(GrpcClient client, String projectionName, GetProjectionStateOptions options, Class<TResult> resultType) {
        this(client, projectionName, options, (JsonMapper jsonMapper, String json) -> jsonMapper.readValue(json, resultType));
    }

    GetProjectionState(GrpcClient client, String projectionName, GetProjectionStateOptions options, Function<TypeFactory, JavaType> javaTypeFunction) {
        this(client, projectionName, options, (JsonMapper jsonMapper, String json) -> jsonMapper.readValue(json, (JavaType)javaTypeFunction.apply(jsonMapper.getTypeFactory())));
    }

    public GetProjectionState(GrpcClient client, String projectionName, GetProjectionStateOptions options, ThrowingBiFunction<JsonMapper, String, TResult, JsonProcessingException> deserializationStrategy) {
        this.client = client;
        this.projectionName = projectionName;
        this.options = options;
        this.deserializationStrategy = deserializationStrategy;
    }

    public CompletableFuture<TResult> execute() {
        return this.client.run(channel -> {
            Projectionmanagement.StateReq.Options.Builder optionsBuilder = Projectionmanagement.StateReq.Options.newBuilder().setName(this.projectionName);
            if (!this.options.getPartition().isEmpty()) {
                optionsBuilder.setPartition(this.options.getPartition());
            }
            Projectionmanagement.StateReq request = Projectionmanagement.StateReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            CompletableFuture result = new CompletableFuture();
            ThrowingFunction converter = source -> {
                String json = JsonFormat.printer().print((MessageOrBuilder)source.getState());
                return this.deserializationStrategy.apply(new JsonMapper(), json);
            };
            client.state(request, (StreamObserver<Projectionmanagement.StateResp>)GrpcUtils.convertSingleResponse(result, converter));
            return result;
        });
    }
}

