/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GetProjectionStatusOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.ProjectionDetails;
import io.kurrent.dbclient.proto.projections.Projectionmanagement;
import io.kurrent.dbclient.proto.projections.ProjectionsGrpc;
import java.util.concurrent.CompletableFuture;

class GetProjectionStatus {
    private final GrpcClient client;
    private final String projectionName;
    private final GetProjectionStatusOptions options;

    public GetProjectionStatus(GrpcClient client, String projectionName, GetProjectionStatusOptions options) {
        this.client = client;
        this.projectionName = projectionName;
        this.options = options;
    }

    public CompletableFuture<ProjectionDetails> execute() {
        return this.client.run(channel -> {
            Projectionmanagement.StatisticsReq.Options.Builder optionsBuilder = Projectionmanagement.StatisticsReq.Options.newBuilder().setName(this.projectionName);
            Projectionmanagement.StatisticsReq request = Projectionmanagement.StatisticsReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            CompletableFuture result = new CompletableFuture();
            client.statistics(request, (StreamObserver<Projectionmanagement.StatisticsResp>)GrpcUtils.convertSingleResponse(result, resp -> {
                Projectionmanagement.StatisticsResp.Details details = resp.getDetails();
                return ProjectionDetails.fromWire(details);
            }));
            return result;
        });
    }
}

