/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.kurrent.dbclient.ConnectionShutdownException;
import io.kurrent.dbclient.CreateChannel;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.Msg;
import io.kurrent.dbclient.NotLeaderException;
import io.kurrent.dbclient.RunWorkItem;
import io.kurrent.dbclient.ServerVersion;
import io.kurrent.dbclient.Shutdown;
import io.kurrent.dbclient.WorkItemArgs;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcClient {
    private static final Logger logger = LoggerFactory.getLogger(GrpcClient.class);
    private final AtomicBoolean closed;
    private final LinkedBlockingQueue<Msg> queue;
    private final KurrentDBClientSettings settings;

    GrpcClient(KurrentDBClientSettings settings, AtomicBoolean closed, LinkedBlockingQueue<Msg> queue) {
        this.settings = settings;
        this.closed = closed;
        this.queue = queue;
    }

    public boolean isShutdown() {
        return this.closed.get();
    }

    private void push(Msg msg) {
        try {
            if (this.closed.get()) {
                if (msg instanceof RunWorkItem) {
                    RunWorkItem args = (RunWorkItem)msg;
                    args.reportError(new ConnectionShutdownException());
                }
                if (msg instanceof Shutdown) {
                    ((Shutdown)msg).complete();
                }
                return;
            }
            this.queue.put(msg);
            logger.debug("Scheduled msg: {}", (Object)msg);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<WorkItemArgs> getWorkItemArgs() {
        CompletableFuture<WorkItemArgs> result = new CompletableFuture<WorkItemArgs>();
        this.push(new RunWorkItem(UUID.randomUUID(), (args, error) -> {
            if (error != null) {
                result.completeExceptionally(error);
                return;
            }
            result.complete(args);
        }));
        return result;
    }

    public CompletableFuture<Optional<ServerVersion>> getServerVersion() {
        return this.runWithArgs(args -> CompletableFuture.completedFuture(args.getServerVersion()));
    }

    public <A> CompletableFuture<A> run(Function<ManagedChannel, CompletableFuture<A>> action) {
        return this.runWithArgs(args -> (CompletableFuture)action.apply(args.getChannel()));
    }

    public <A> CompletableFuture<A> runWithArgs(Function<WorkItemArgs, CompletableFuture<A>> action) {
        return this.getWorkItemArgs().thenComposeAsync(args -> ((CompletableFuture)action.apply((WorkItemArgs)args)).handleAsync((outcome, e) -> {
            if (e != null) {
                NotLeaderException ex;
                if (e instanceof CompletionException) {
                    e = e.getCause();
                }
                if (e instanceof NotLeaderException) {
                    ex = (NotLeaderException)e;
                    this.push(new CreateChannel(args.getId(), ex.getLeaderEndpoint()));
                }
                if (e instanceof StatusRuntimeException && (ex = (StatusRuntimeException)e).getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                    this.push(new CreateChannel(args.getId()));
                }
                logger.debug("RunWorkItem[{}] completed exceptionally: {}", (Object)args.getId(), (Object)e.toString());
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException((Throwable)e);
            }
            return outcome;
        }));
    }

    public CompletableFuture<Void> shutdown() {
        CompletableFuture<Void> completion = new CompletableFuture<Void>();
        this.push(new Shutdown(completion::complete));
        return completion;
    }

    public KurrentDBClientSettings getSettings() {
        return this.settings;
    }
}

