/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.CreatePersistentSubscriptionToAll;
import io.kurrent.dbclient.CreatePersistentSubscriptionToAllOptions;
import io.kurrent.dbclient.CreatePersistentSubscriptionToStream;
import io.kurrent.dbclient.CreatePersistentSubscriptionToStreamOptions;
import io.kurrent.dbclient.DeletePersistentSubscriptionOptions;
import io.kurrent.dbclient.DeletePersistentSubscriptionToAll;
import io.kurrent.dbclient.DeletePersistentSubscriptionToStream;
import io.kurrent.dbclient.GetPersistentSubscriptionInfo;
import io.kurrent.dbclient.GetPersistentSubscriptionInfoOptions;
import io.kurrent.dbclient.KurrentDBClientBase;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.ListPersistentSubscriptions;
import io.kurrent.dbclient.ListPersistentSubscriptionsOptions;
import io.kurrent.dbclient.PersistentSubscription;
import io.kurrent.dbclient.PersistentSubscriptionInfo;
import io.kurrent.dbclient.PersistentSubscriptionListener;
import io.kurrent.dbclient.PersistentSubscriptionToAllInfo;
import io.kurrent.dbclient.PersistentSubscriptionToStreamInfo;
import io.kurrent.dbclient.ReplayParkedMessages;
import io.kurrent.dbclient.ReplayParkedMessagesOptions;
import io.kurrent.dbclient.RestartPersistentSubscriptionSubsystem;
import io.kurrent.dbclient.RestartPersistentSubscriptionSubsystemOptions;
import io.kurrent.dbclient.SubscribePersistentSubscriptionOptions;
import io.kurrent.dbclient.SubscribePersistentSubscriptionToAll;
import io.kurrent.dbclient.SubscribePersistentSubscriptionToStream;
import io.kurrent.dbclient.UpdatePersistentSubscriptionToAll;
import io.kurrent.dbclient.UpdatePersistentSubscriptionToAllOptions;
import io.kurrent.dbclient.UpdatePersistentSubscriptionToStream;
import io.kurrent.dbclient.UpdatePersistentSubscriptionToStreamOptions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class KurrentDBPersistentSubscriptionsClient {
    private final KurrentDBClientBase inner;

    private KurrentDBPersistentSubscriptionsClient(KurrentDBClientSettings settings) {
        this.inner = new KurrentDBClientBase(settings);
    }

    private KurrentDBPersistentSubscriptionsClient(KurrentDBClientBase inner) {
        this.inner = inner;
    }

    public static KurrentDBPersistentSubscriptionsClient create(KurrentDBClientSettings settings) {
        return new KurrentDBPersistentSubscriptionsClient(settings);
    }

    public static KurrentDBPersistentSubscriptionsClient from(KurrentDBClientBase existingClient) {
        return new KurrentDBPersistentSubscriptionsClient(existingClient);
    }

    public CompletableFuture createToStream(String stream, String group) {
        return this.createToStream(stream, group, CreatePersistentSubscriptionToStreamOptions.get());
    }

    public CompletableFuture createToAll(String group) {
        return this.createToAll(group, CreatePersistentSubscriptionToAllOptions.get());
    }

    public CompletableFuture createToStream(String stream, String group, CreatePersistentSubscriptionToStreamOptions options) {
        if (options == null) {
            options = CreatePersistentSubscriptionToStreamOptions.get();
        }
        return new CreatePersistentSubscriptionToStream(this.inner.getGrpcClient(), stream, group, options).execute();
    }

    public CompletableFuture createToAll(String group, CreatePersistentSubscriptionToAllOptions options) {
        if (options == null) {
            options = CreatePersistentSubscriptionToAllOptions.get();
        }
        return new CreatePersistentSubscriptionToAll(this.inner.getGrpcClient(), group, options).execute();
    }

    public CompletableFuture updateToStream(String stream, String group) {
        return this.updateToStream(stream, group, UpdatePersistentSubscriptionToStreamOptions.get());
    }

    public CompletableFuture updateToAll(String group) {
        return this.updateToAll(group, UpdatePersistentSubscriptionToAllOptions.get());
    }

    public CompletableFuture updateToStream(String stream, String group, UpdatePersistentSubscriptionToStreamOptions options) {
        if (options == null) {
            options = UpdatePersistentSubscriptionToStreamOptions.get();
        }
        return new UpdatePersistentSubscriptionToStream(this.inner.getGrpcClient(), stream, group, options).execute();
    }

    public CompletableFuture updateToAll(String group, UpdatePersistentSubscriptionToAllOptions options) {
        if (options == null) {
            options = UpdatePersistentSubscriptionToAllOptions.get();
        }
        return new UpdatePersistentSubscriptionToAll(this.inner.getGrpcClient(), group, options).execute();
    }

    public CompletableFuture deleteToStream(String stream, String group) {
        return this.deleteToStream(stream, group, DeletePersistentSubscriptionOptions.get());
    }

    public CompletableFuture deleteToAll(String group) {
        return this.deleteToAll(group, DeletePersistentSubscriptionOptions.get());
    }

    public CompletableFuture deleteToStream(String stream, String group, DeletePersistentSubscriptionOptions options) {
        if (options == null) {
            options = DeletePersistentSubscriptionOptions.get();
        }
        return new DeletePersistentSubscriptionToStream(this.inner.getGrpcClient(), stream, group, options).execute();
    }

    public CompletableFuture deleteToAll(String group, DeletePersistentSubscriptionOptions options) {
        if (options == null) {
            options = DeletePersistentSubscriptionOptions.get();
        }
        return new DeletePersistentSubscriptionToAll(this.inner.getGrpcClient(), group, options).execute();
    }

    public CompletableFuture<PersistentSubscription> subscribeToStream(String stream, String group, PersistentSubscriptionListener listener) {
        return this.subscribeToStream(stream, group, SubscribePersistentSubscriptionOptions.get(), listener);
    }

    public CompletableFuture<PersistentSubscription> subscribeToAll(String group, PersistentSubscriptionListener listener) {
        return this.subscribeToAll(group, SubscribePersistentSubscriptionOptions.get(), listener);
    }

    public CompletableFuture<PersistentSubscription> subscribeToStream(String stream, String group, SubscribePersistentSubscriptionOptions options, PersistentSubscriptionListener listener) {
        if (options == null) {
            options = SubscribePersistentSubscriptionOptions.get();
        }
        return new SubscribePersistentSubscriptionToStream(this.inner.getGrpcClient(), stream, group, options, listener).execute();
    }

    public CompletableFuture<PersistentSubscription> subscribeToAll(String group, SubscribePersistentSubscriptionOptions options, PersistentSubscriptionListener listener) {
        if (options == null) {
            options = SubscribePersistentSubscriptionOptions.get();
        }
        return new SubscribePersistentSubscriptionToAll(this.inner.getGrpcClient(), group, options, listener).execute();
    }

    public CompletableFuture<List<PersistentSubscriptionInfo>> listAll(ListPersistentSubscriptionsOptions options) {
        return ListPersistentSubscriptions.execute(this.inner.getGrpcClient(), options, "", Function.identity());
    }

    public CompletableFuture<List<PersistentSubscriptionInfo>> listAll() {
        return this.listAll(ListPersistentSubscriptionsOptions.get());
    }

    public CompletableFuture<List<PersistentSubscriptionToStreamInfo>> listToStream(String stream, ListPersistentSubscriptionsOptions options) {
        return ListPersistentSubscriptions.execute(this.inner.getGrpcClient(), options, stream, info -> (PersistentSubscriptionToStreamInfo)info);
    }

    public CompletableFuture<List<PersistentSubscriptionToStreamInfo>> listToStream(String stream) {
        return this.listToStream(stream, ListPersistentSubscriptionsOptions.get());
    }

    public CompletableFuture<List<PersistentSubscriptionToAllInfo>> listToAll() {
        return this.listToAll(ListPersistentSubscriptionsOptions.get());
    }

    public CompletableFuture<List<PersistentSubscriptionToAllInfo>> listToAll(ListPersistentSubscriptionsOptions options) {
        return ListPersistentSubscriptions.execute(this.inner.getGrpcClient(), options, "$all", info -> (PersistentSubscriptionToAllInfo)info);
    }

    public CompletableFuture<Optional<PersistentSubscriptionToStreamInfo>> getInfoToStream(String stream, String groupName, GetPersistentSubscriptionInfoOptions options) {
        return GetPersistentSubscriptionInfo.execute(this.inner.getGrpcClient(), options, stream, groupName).thenApply(res -> res.map(PersistentSubscriptionToStreamInfo.class::cast));
    }

    public CompletableFuture<Optional<PersistentSubscriptionToStreamInfo>> getInfoToStream(String stream, String groupName) {
        return this.getInfoToStream(stream, groupName, GetPersistentSubscriptionInfoOptions.get());
    }

    public CompletableFuture<Optional<PersistentSubscriptionToAllInfo>> getInfoToAll(String groupName, GetPersistentSubscriptionInfoOptions options) {
        return GetPersistentSubscriptionInfo.execute(this.inner.getGrpcClient(), options, "$all", groupName).thenApply(res -> res.map(PersistentSubscriptionToAllInfo.class::cast));
    }

    public CompletableFuture<Optional<PersistentSubscriptionToAllInfo>> getInfoToAll(String groupName) {
        return this.getInfoToAll(groupName, GetPersistentSubscriptionInfoOptions.get());
    }

    public CompletableFuture replayParkedMessagesToStream(String stream, String groupName, ReplayParkedMessagesOptions options) {
        return ReplayParkedMessages.execute(this.inner.getGrpcClient(), options, stream, groupName);
    }

    public CompletableFuture replayParkedMessagesToStream(String stream, String groupName) {
        return this.replayParkedMessagesToStream(stream, groupName, ReplayParkedMessagesOptions.get());
    }

    public CompletableFuture replayParkedMessagesToAll(String groupName, ReplayParkedMessagesOptions options) {
        return this.replayParkedMessagesToStream("$all", groupName, options);
    }

    public CompletableFuture replayParkedMessagesToAll(String groupName) throws ExecutionException, InterruptedException {
        return this.replayParkedMessagesToAll(groupName, ReplayParkedMessagesOptions.get());
    }

    public CompletableFuture restartSubsystem() {
        return this.restartSubsystem(RestartPersistentSubscriptionSubsystemOptions.get());
    }

    public CompletableFuture restartSubsystem(RestartPersistentSubscriptionSubsystemOptions options) {
        return RestartPersistentSubscriptionSubsystem.execute(this.inner.getGrpcClient(), options);
    }

    public CompletableFuture<Void> shutdown() {
        return this.inner.shutdown();
    }

    public boolean isShutdown() {
        return this.inner.isShutdown();
    }
}

