/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.OperationKind;
import io.kurrent.dbclient.OptionsWithResolveLinkTosBase;

class OptionsWithBackPressure<T>
extends OptionsWithResolveLinkTosBase<T> {
    private int batchSize = 512;
    private float thresholdRatio = 0.25f;

    protected OptionsWithBackPressure(OperationKind kind) {
        super(kind);
    }

    protected OptionsWithBackPressure() {
        this(OperationKind.Streaming);
    }

    int getBatchSize() {
        return this.batchSize;
    }

    int computeRequestThreshold() {
        return (int)((float)this.batchSize * this.thresholdRatio);
    }

    public T batchSize(int batchSize) {
        this.batchSize = batchSize;
        return (T)this;
    }

    public T thresholdRatio(float ratio) {
        this.thresholdRatio = ratio;
        return (T)this;
    }
}

