/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.NamedConsumerStrategy;
import io.kurrent.dbclient.PersistentSubscriptionToAllSettings;
import io.kurrent.dbclient.PersistentSubscriptionToStreamSettings;
import io.kurrent.dbclient.StreamPosition;
import java.time.Duration;

public abstract class PersistentSubscriptionSettings {
    private int checkpointAfter;
    private boolean extraStatistics;
    private boolean resolveLinkTos;
    private int historyBufferSize;
    private int liveBufferSize;
    private int checkpointUpperBound;
    private int maxRetryCount;
    private int maxSubscriberCount;
    private int messageTimeoutMs;
    private int checkpointLowerBound;
    private int readBatchSize;
    private NamedConsumerStrategy namedConsumerStrategy;

    PersistentSubscriptionSettings() {
    }

    static PersistentSubscriptionToStreamSettings defaultRegular() {
        PersistentSubscriptionToStreamSettings settings = new PersistentSubscriptionToStreamSettings();
        PersistentSubscriptionSettings.defaultCommon(settings);
        settings.setStartFrom(StreamPosition.end());
        return settings;
    }

    static PersistentSubscriptionToAllSettings defaultToAll() {
        PersistentSubscriptionToAllSettings settings = new PersistentSubscriptionToAllSettings();
        PersistentSubscriptionSettings.defaultCommon(settings);
        settings.setStartFrom(StreamPosition.end());
        return settings;
    }

    private static <A extends PersistentSubscriptionSettings> void defaultCommon(A settings) {
        settings.setMessageTimeoutMs(30000);
        settings.setMaxRetryCount(10);
        settings.setLiveBufferSize(500);
        settings.setReadBatchSize(20);
        settings.setHistoryBufferSize(500);
        settings.setCheckpointAfter(2000);
        settings.setCheckpointLowerBound(10);
        settings.setCheckpointUpperBound(1000);
        settings.setMaxSubscriberCount(0);
        settings.setNamedConsumerStrategy(NamedConsumerStrategy.ROUND_ROBIN);
    }

    PersistentSubscriptionSettings(int checkpointAfter, boolean extraStatistics, boolean resolveLinks, int historyBufferSize, int liveBufferSize, int checkpointUpperBound, int maxRetryCount, int maxSubscriberCount, int messageTimeoutMs, int minCheckpointCount, int readBatchSize, NamedConsumerStrategy namedConsumerStrategy) {
        this.checkpointAfter = checkpointAfter;
        this.extraStatistics = extraStatistics;
        this.resolveLinkTos = resolveLinks;
        this.historyBufferSize = historyBufferSize;
        this.liveBufferSize = liveBufferSize;
        this.checkpointUpperBound = checkpointUpperBound;
        this.maxRetryCount = maxRetryCount;
        this.maxSubscriberCount = maxSubscriberCount;
        this.messageTimeoutMs = messageTimeoutMs;
        this.checkpointLowerBound = minCheckpointCount;
        this.readBatchSize = readBatchSize;
        this.namedConsumerStrategy = namedConsumerStrategy;
    }

    public int getCheckpointAfterInMs() {
        return this.checkpointAfter;
    }

    public Duration getCheckpointAfter() {
        return Duration.ofMillis(this.checkpointAfter);
    }

    public boolean isExtraStatistics() {
        return this.extraStatistics;
    }

    public boolean shouldResolveLinkTos() {
        return this.resolveLinkTos;
    }

    public int getHistoryBufferSize() {
        return this.historyBufferSize;
    }

    public int getLiveBufferSize() {
        return this.liveBufferSize;
    }

    public int getCheckpointUpperBound() {
        return this.checkpointUpperBound;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public int getMaxSubscriberCount() {
        return this.maxSubscriberCount;
    }

    public Duration getMessageTimeout() {
        return Duration.ofMillis(this.messageTimeoutMs);
    }

    public int getMessageTimeoutMs() {
        return this.messageTimeoutMs;
    }

    public int getCheckpointLowerBound() {
        return this.checkpointLowerBound;
    }

    public int getReadBatchSize() {
        return this.readBatchSize;
    }

    public NamedConsumerStrategy getNamedConsumerStrategy() {
        return this.namedConsumerStrategy;
    }

    void setCheckpointAfter(int checkpointAfter) {
        this.checkpointAfter = checkpointAfter;
    }

    void setExtraStatistics(boolean extraStatistics) {
        this.extraStatistics = extraStatistics;
    }

    public boolean isResolveLinkTos() {
        return this.resolveLinkTos;
    }

    void setResolveLinkTos(boolean resolveLinkTos) {
        this.resolveLinkTos = resolveLinkTos;
    }

    void setHistoryBufferSize(int historyBufferSize) {
        this.historyBufferSize = historyBufferSize;
    }

    void setLiveBufferSize(int liveBufferSize) {
        this.liveBufferSize = liveBufferSize;
    }

    void setCheckpointUpperBound(int checkpointUpperBound) {
        this.checkpointUpperBound = checkpointUpperBound;
    }

    void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    void setMaxSubscriberCount(int maxSubscriberCount) {
        this.maxSubscriberCount = maxSubscriberCount;
    }

    void setMessageTimeoutMs(int messageTimeoutMs) {
        this.messageTimeoutMs = messageTimeoutMs;
    }

    void setCheckpointLowerBound(int checkpointLowerBound) {
        this.checkpointLowerBound = checkpointLowerBound;
    }

    void setReadBatchSize(int readBatchSize) {
        this.readBatchSize = readBatchSize;
    }

    void setNamedConsumerStrategy(NamedConsumerStrategy namedConsumerStrategy) {
        this.namedConsumerStrategy = namedConsumerStrategy;
    }
}

