/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.HttpUtils;
import io.kurrent.dbclient.RestartPersistentSubscriptionSubsystemOptions;
import io.kurrent.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.kurrent.dbclient.proto.shared.Shared;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.concurrent.CompletableFuture;

class RestartPersistentSubscriptionSubsystem {
    RestartPersistentSubscriptionSubsystem() {
    }

    public static CompletableFuture execute(GrpcClient client, RestartPersistentSubscriptionSubsystemOptions options) {
        return client.runWithArgs(args -> {
            CompletableFuture<Integer> result = new CompletableFuture<Integer>();
            if (args.supportFeature(30)) {
                PersistentSubscriptionsGrpc.PersistentSubscriptionsStub stub = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), client.getSettings(), options);
                stub.restartSubsystem(Shared.Empty.getDefaultInstance(), (StreamObserver<Shared.Empty>)GrpcUtils.convertSingleResponse(result, resp -> 42));
            } else {
                HttpURLConnection http = args.getHttpConnection(options, client.getSettings(), "/subscriptions/restart");
                try {
                    http.setDoOutput(true);
                    http.setRequestMethod("POST");
                    http.setFixedLengthStreamingMode(0);
                    Exception error = HttpUtils.checkForError(http.getResponseCode());
                    if (error != null) {
                        result.completeExceptionally(error);
                    } else {
                        result.complete(42);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    http.disconnect();
                }
            }
            return result;
        });
    }
}

