/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

public class ServerVersion {
    private final int major;
    private final int minor;
    private final int patch;

    public ServerVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isGreaterThan(int major, int minor, int patch) {
        return !this.isLessThan(major, minor, patch) && !this.equals(major, minor, patch);
    }

    public boolean equals(int major, int minor, int patch) {
        return this.major == major && this.minor == minor && this.patch == patch;
    }

    public boolean isLessThan(int major, int minor, int patch) {
        int cmp = Integer.compare(this.major, major);
        if (cmp != 0) {
            return cmp < 0;
        }
        cmp = Integer.compare(this.minor, minor);
        if (cmp != 0) {
            return cmp < 0;
        }
        cmp = Integer.compare(this.patch, patch);
        if (cmp != 0) {
            return cmp < 0;
        }
        return false;
    }

    public boolean isLessOrEqualThan(int major, int minor) {
        int cmp = Integer.compare(this.major, major);
        if (cmp != 0) {
            return cmp < 0;
        }
        cmp = Integer.compare(this.minor, minor);
        if (cmp != 0) {
            return cmp < 0;
        }
        return true;
    }

    public String toString() {
        return "ServerVersion{major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + '}';
    }
}

