/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.google.protobuf.ByteString;
import io.kurrent.dbclient.AbstractUpdatePersistentSubscription;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.PersistentSubscriptionSettings;
import io.kurrent.dbclient.PersistentSubscriptionToStreamSettings;
import io.kurrent.dbclient.StreamPosition;
import io.kurrent.dbclient.UpdatePersistentSubscriptionToStreamOptions;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.shared.Shared;

class UpdatePersistentSubscriptionToStream
extends AbstractUpdatePersistentSubscription {
    private final PersistentSubscriptionToStreamSettings settings;
    private final String stream;

    public UpdatePersistentSubscriptionToStream(GrpcClient connection, String stream, String group, UpdatePersistentSubscriptionToStreamOptions options) {
        super(connection, group, (PersistentSubscriptionSettings)options.getSettings(), options);
        this.stream = stream;
        this.settings = (PersistentSubscriptionToStreamSettings)options.getSettings();
    }

    @Override
    protected Persistent.UpdateReq.Settings.Builder createSettings() {
        return Persistent.UpdateReq.Settings.newBuilder();
    }

    @Override
    protected Persistent.UpdateReq.Options.Builder createOptions() {
        Persistent.UpdateReq.Options.Builder optionsBuilder = Persistent.UpdateReq.Options.newBuilder();
        Shared.StreamIdentifier.Builder streamIdentifierBuilder = Shared.StreamIdentifier.newBuilder();
        Persistent.UpdateReq.StreamOptions.Builder streamOptionsBuilder = Persistent.UpdateReq.StreamOptions.newBuilder();
        StreamPosition<Long> position = this.settings.getStartFrom();
        if (position instanceof StreamPosition.Start) {
            streamOptionsBuilder.setStart(Shared.Empty.newBuilder());
        } else if (position instanceof StreamPosition.End) {
            streamOptionsBuilder.setEnd(Shared.Empty.newBuilder());
        } else {
            streamOptionsBuilder.setRevision(position.getPositionOrThrow());
        }
        streamIdentifierBuilder.setStreamName(ByteString.copyFromUtf8((String)this.stream));
        streamOptionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        optionsBuilder.setStream(streamOptionsBuilder);
        optionsBuilder.setStreamIdentifier(streamIdentifierBuilder);
        return optionsBuilder;
    }
}

