/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.ClientTelemetry;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.NotLeaderException;
import io.kurrent.dbclient.PersistentSubscription;
import io.kurrent.dbclient.PersistentSubscriptionListener;
import io.kurrent.dbclient.ResolvedEvent;
import io.kurrent.dbclient.SubscribePersistentSubscriptionOptions;
import io.kurrent.dbclient.UnsupportedFeatureException;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.kurrent.dbclient.proto.shared.Shared;
import java.util.concurrent.CompletableFuture;

abstract class AbstractSubscribePersistentSubscription {
    protected static final Persistent.ReadReq.Options.Builder defaultReadOptions = Persistent.ReadReq.Options.newBuilder().setUuidOption(Persistent.ReadReq.Options.UUIDOption.newBuilder().setStructured(Shared.Empty.getDefaultInstance()));
    private final GrpcClient client;
    private final String group;
    private final PersistentSubscriptionListener listener;
    private final SubscribePersistentSubscriptionOptions options;

    public AbstractSubscribePersistentSubscription(GrpcClient client, String group, SubscribePersistentSubscriptionOptions options, PersistentSubscriptionListener listener) {
        this.client = client;
        this.group = group;
        this.options = options;
        this.listener = listener;
    }

    protected abstract Persistent.ReadReq.Options.Builder createOptions();

    public CompletableFuture<PersistentSubscription> execute() {
        return this.client.runWithArgs(args -> {
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub persistentSubscriptionsClient = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), this.client.getSettings(), this.options);
            final CompletableFuture result = new CompletableFuture();
            int bufferSize = this.options.getBufferSize();
            Persistent.ReadReq req = Persistent.ReadReq.newBuilder().setOptions(this.createOptions().setBufferSize(bufferSize).setGroupName(this.group)).build();
            if (req.getOptions().hasAll() && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeatureException());
            } else {
                ClientResponseObserver<Persistent.ReadReq, Persistent.ReadResp> observer = new ClientResponseObserver<Persistent.ReadReq, Persistent.ReadResp>(){
                    private boolean _confirmed;
                    private PersistentSubscription _subscription;
                    private ClientCallStreamObserver _requestStream;

                    public void beforeStart(ClientCallStreamObserver<Persistent.ReadReq> requestStream) {
                        this._requestStream = requestStream;
                    }

                    public void onNext(Persistent.ReadResp readResp) {
                        if (!this._confirmed && readResp.hasSubscriptionConfirmation()) {
                            this._confirmed = true;
                            this._subscription = new PersistentSubscription((ClientCallStreamObserver<Persistent.ReadReq>)this._requestStream, readResp.getSubscriptionConfirmation().getSubscriptionId());
                            result.complete(this._subscription);
                            AbstractSubscribePersistentSubscription.this.listener.onConfirmation(this._subscription);
                            return;
                        }
                        if (!this._confirmed && readResp.hasEvent()) {
                            this.onError(new IllegalStateException("Unconfirmed persistent subscription received event"));
                            return;
                        }
                        if (this._confirmed && !readResp.hasEvent()) {
                            this.onError(new IllegalStateException(String.format("Confirmed persistent subscription %s received non-{event,checkpoint} variant", this._subscription.getSubscriptionId())));
                            return;
                        }
                        int retryCount = readResp.getEvent().hasNoRetryCount() ? 0 : readResp.getEvent().getRetryCount();
                        try {
                            ResolvedEvent resolvedEvent = ResolvedEvent.fromWire(readResp.getEvent());
                            ClientTelemetry.traceSubscribe(() -> AbstractSubscribePersistentSubscription.this.listener.onEvent(this._subscription, retryCount, resolvedEvent), this._subscription.getSubscriptionId(), args.getChannel(), AbstractSubscribePersistentSubscription.this.client.getSettings(), AbstractSubscribePersistentSubscription.this.options.getCredentials(), resolvedEvent.getEvent());
                        }
                        catch (Exception e) {
                            this.onError(e);
                        }
                    }

                    public void onError(Throwable throwable) {
                        Throwable error;
                        if (!this._confirmed) {
                            result.completeExceptionally(throwable);
                        }
                        if ((error = throwable) instanceof StatusRuntimeException) {
                            StatusRuntimeException sre = (StatusRuntimeException)error;
                            String desc = sre.getStatus().getDescription();
                            if (sre.getStatus().getCode() == Status.Code.CANCELLED && desc != null && desc.equals("user-initiated")) {
                                AbstractSubscribePersistentSubscription.this.listener.onCancelled(this._subscription, null);
                                return;
                            }
                            String leaderHost = (String)sre.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                            String leaderPort = (String)sre.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                            if (leaderHost != null && leaderPort != null) {
                                error = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                            }
                        }
                        AbstractSubscribePersistentSubscription.this.listener.onCancelled(this._subscription, error);
                    }

                    public void onCompleted() {
                    }
                };
                StreamObserver<Persistent.ReadReq> wireStream = persistentSubscriptionsClient.read((StreamObserver<Persistent.ReadResp>)observer);
                wireStream.onNext((Object)req);
            }
            return result;
        });
    }
}

