/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.grpc.ManagedChannel;
import io.kurrent.dbclient.ClientTelemetryAttributes;
import io.kurrent.dbclient.ClientTelemetryTags;
import io.kurrent.dbclient.EventData;
import io.kurrent.dbclient.EventDataBuilder;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.RecordedEvent;
import io.kurrent.dbclient.UserCredentials;
import io.kurrent.dbclient.WriteResult;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

class ClientTelemetry {
    private static final ClientTelemetryTags DEFAULT_ATTRIBUTES = new ClientTelemetryTags(){
        {
            this.put(ClientTelemetryAttributes.Database.SYSTEM, "kurrentdb");
        }
    };

    ClientTelemetry() {
    }

    private static Tracer getTracer() {
        return GlobalOpenTelemetry.getTracer((String)ClientTelemetry.class.getPackage().getName(), (String)ClientTelemetry.class.getPackage().getImplementationVersion());
    }

    private static List<EventData> tryInjectTracingContext(Span span, List<EventData> events) {
        ArrayList<EventData> injectedEvents = new ArrayList<EventData>();
        for (EventData event : events) {
            boolean isJsonEvent = Objects.equals(event.getContentType(), "application/json");
            injectedEvents.add(EventDataBuilder.binary(event.getEventId(), event.getEventType(), event.getEventData(), isJsonEvent).metadataAsBytes(ClientTelemetry.tryInjectTracingContext(span, event.getUserMetadata())).build());
        }
        return injectedEvents;
    }

    private static byte[] tryInjectTracingContext(Span span, byte[] userMetadataBytes) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode userMetadata = userMetadataBytes != null ? (ObjectNode)objectMapper.readValue(userMetadataBytes, ObjectNode.class) : objectMapper.createObjectNode();
            userMetadata.put("$traceId", span.getSpanContext().getTraceId());
            userMetadata.put("$spanId", span.getSpanContext().getSpanId());
            return objectMapper.writeValueAsBytes((Object)userMetadata);
        }
        catch (Throwable t) {
            return userMetadataBytes;
        }
    }

    private static SpanContext tryExtractTracingContext(byte[] userMetadataBytes) {
        if (userMetadataBytes == null) {
            return null;
        }
        try {
            ObjectNode userMetadata = (ObjectNode)new ObjectMapper().readValue(userMetadataBytes, ObjectNode.class);
            JsonNode traceIdNode = userMetadata.get("$traceId");
            JsonNode spanIdNode = userMetadata.get("$spanId");
            if (traceIdNode == null || spanIdNode == null) {
                return null;
            }
            String traceId = traceIdNode.asText();
            String spanId = spanIdNode.asText();
            if (!TraceId.isValid((CharSequence)traceId) || !SpanId.isValid((CharSequence)spanId)) {
                return null;
            }
            return SpanContext.createFromRemoteParent((String)traceId, (String)spanId, (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
        }
        catch (Throwable t) {
            return null;
        }
    }

    static CompletableFuture<WriteResult> traceAppend(BiFunction<ManagedChannel, List<EventData>, CompletableFuture<WriteResult>> appendOperation, ManagedChannel channel, List<EventData> events, String streamId, KurrentDBClientSettings settings, UserCredentials optionalCallCredentials) {
        Span span = ClientTelemetry.createSpan("streams.append", SpanKind.CLIENT, null, ClientTelemetryTags.builder().withRequiredTag("db.kurrentdb.stream", streamId).withServerTagsFromGrpcChannel(channel).withServerTagsFromClientSettings(settings).withOptionalDatabaseUserTag(settings.getDefaultCredentials()).withOptionalDatabaseUserTag(optionalCallCredentials).build());
        try (Scope scope = span.makeCurrent();){
            CompletionStage completionStage = appendOperation.apply(channel, ClientTelemetry.tryInjectTracingContext(span, events)).handle((writeResult, throwable) -> {
                if (throwable != null) {
                    span.setStatus(StatusCode.ERROR);
                    span.recordException(throwable);
                    span.end();
                    throw new CompletionException((Throwable)throwable);
                }
                span.setStatus(StatusCode.OK);
                span.end();
                return writeResult;
            });
            return completionStage;
        }
    }

    static void traceSubscribe(Runnable tracedOperation, String subscriptionId, ManagedChannel channel, KurrentDBClientSettings settings, UserCredentials optionalCallCredentials, RecordedEvent event) {
        if (event == null) {
            tracedOperation.run();
            return;
        }
        SpanContext remoteParentContext = ClientTelemetry.tryExtractTracingContext(event.getUserMetadata());
        if (remoteParentContext == null) {
            tracedOperation.run();
            return;
        }
        Span span = ClientTelemetry.createSpan("streams.subscribe", SpanKind.CONSUMER, remoteParentContext, ClientTelemetryTags.builder().withRequiredTag("db.kurrentdb.stream", event.getStreamId()).withRequiredTag("db.kurrentdb.subscription.id", subscriptionId).withRequiredTag("db.kurrentdb.event.id", event.getEventId().toString()).withRequiredTag("db.kurrentdb.event.type", event.getEventType()).withServerTagsFromGrpcChannel(channel).withServerTagsFromClientSettings(settings).withOptionalDatabaseUserTag(settings.getDefaultCredentials()).withOptionalDatabaseUserTag(optionalCallCredentials).build());
        try (Scope scope = span.makeCurrent();){
            tracedOperation.run();
            span.setStatus(StatusCode.OK);
        }
        catch (Throwable t) {
            span.recordException(t);
            span.setStatus(StatusCode.ERROR);
            throw t;
        }
        finally {
            span.end();
        }
    }

    static Span createSpan(final String operationName, SpanKind spanKind, SpanContext parentContext, final ClientTelemetryTags customAttributes) {
        SpanBuilder spanBuilder = ClientTelemetry.getTracer().spanBuilder(operationName).setSpanKind(spanKind);
        if (parentContext != null) {
            spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)Span.wrap((SpanContext)parentContext)));
        }
        ClientTelemetryTags attributes = new ClientTelemetryTags(DEFAULT_ATTRIBUTES){
            {
                super(tags);
                this.put(ClientTelemetryAttributes.Database.OPERATION, operationName);
                if (customAttributes != null) {
                    this.putAll(customAttributes);
                }
            }
        };
        for (Map.Entry entry : attributes.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            spanBuilder.setAttribute((String)entry.getKey(), value);
        }
        return spanBuilder.startSpan();
    }
}

