/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.ClientInterceptor;
import io.kurrent.dbclient.ClientCertificate;
import io.kurrent.dbclient.Consts;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.NodePreference;
import io.kurrent.dbclient.UserCredentials;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionSettingsBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionSettingsBuilder.class);
    private static final Set<String> SUPPORTED_PROTOCOLS = new HashSet<String>(Arrays.asList("esdb", "esdb+discover", "kurrent", "kurrent+discover", "kdb", "kdb+discover", "kurrentdb", "kurrentdb+discover"));
    private boolean _dnsDiscover = false;
    private int _maxDiscoverAttempts = 3;
    private int _discoveryInterval = 500;
    private int _gossipTimeout = 3000;
    private NodePreference _nodePreference = NodePreference.LEADER;
    private boolean _tls = true;
    private boolean _tlsVerifyCert = true;
    private UserCredentials _defaultCredentials;
    private ClientCertificate _defaultClientCertificate;
    private LinkedList<InetSocketAddress> _hosts = new LinkedList();
    private long _keepAliveTimeout = Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS;
    private long _keepAliveInterval = Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS;
    private Long _defaultDeadline = null;
    private List<ClientInterceptor> _interceptors = new ArrayList<ClientInterceptor>();
    private String _tlsCaFile = null;
    private Set<String> _features = new HashSet<String>();

    ConnectionSettingsBuilder() {
    }

    public KurrentDBClientSettings buildConnectionSettings() {
        return new KurrentDBClientSettings(this._dnsDiscover, this._maxDiscoverAttempts, this._discoveryInterval, this._gossipTimeout, this._nodePreference, this._tls, this._tlsVerifyCert, this._defaultCredentials, this._defaultClientCertificate, this._hosts.toArray(new InetSocketAddress[0]), this._keepAliveTimeout, this._keepAliveInterval, this._defaultDeadline, this._interceptors, this._tlsCaFile, this._features);
    }

    public ConnectionSettingsBuilder dnsDiscover(boolean dnsDiscover) {
        this._dnsDiscover = dnsDiscover;
        return this;
    }

    public ConnectionSettingsBuilder maxDiscoverAttempts(int maxDiscoverAttempts) {
        this._maxDiscoverAttempts = maxDiscoverAttempts;
        return this;
    }

    public ConnectionSettingsBuilder discoveryInterval(int discoveryInterval) {
        this._discoveryInterval = discoveryInterval;
        return this;
    }

    public ConnectionSettingsBuilder gossipTimeout(int gossipTimeout) {
        this._gossipTimeout = gossipTimeout;
        return this;
    }

    public ConnectionSettingsBuilder nodePreference(NodePreference nodePreference) {
        this._nodePreference = nodePreference;
        return this;
    }

    public ConnectionSettingsBuilder tls(boolean tls) {
        this._tls = tls;
        return this;
    }

    public ConnectionSettingsBuilder tlsVerifyCert(boolean tlsVerifyCert) {
        this._tlsVerifyCert = tlsVerifyCert;
        return this;
    }

    public ConnectionSettingsBuilder defaultCredentials(String username, String password) {
        this._defaultCredentials = new UserCredentials(username, password);
        return this;
    }

    public ConnectionSettingsBuilder defaultCredentials(UserCredentials defaultCredentials) {
        this._defaultCredentials = defaultCredentials;
        return this;
    }

    public ConnectionSettingsBuilder defaultClientCertificate(String clientCertFile, String clientKeyFile) {
        this._defaultClientCertificate = new ClientCertificate(clientCertFile, clientKeyFile);
        return this;
    }

    public ConnectionSettingsBuilder defaultClientCertificate(ClientCertificate defaultClientCertificate) {
        this._defaultClientCertificate = defaultClientCertificate;
        return this;
    }

    public ConnectionSettingsBuilder addHost(String host, int port) {
        return this.addHost(new InetSocketAddress(host, port));
    }

    public ConnectionSettingsBuilder addHost(InetSocketAddress host) {
        this._hosts.push(host);
        return this;
    }

    public ConnectionSettingsBuilder keepAliveTimeout(long value) {
        if (value >= 0L && value < Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS) {
            logger.warn("Specified keepAliveTimeout of {} is less than recommended {}", (Object)value, (Object)Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS);
        }
        if (value == -1L) {
            value = Long.MAX_VALUE;
        }
        this._keepAliveTimeout = value;
        return this;
    }

    public ConnectionSettingsBuilder keepAliveInterval(long value) {
        if (value >= 0L && value < Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS) {
            logger.warn("Specified keepAliveInterval of {} is less than recommended {}", (Object)value, (Object)Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS);
        }
        if (value == -1L) {
            value = Long.MAX_VALUE;
        }
        this._keepAliveInterval = value;
        return this;
    }

    public ConnectionSettingsBuilder defaultDeadline(long value) {
        this._defaultDeadline = value;
        return this;
    }

    public ConnectionSettingsBuilder addInterceptor(ClientInterceptor interceptor) {
        this._interceptors.add(interceptor);
        return this;
    }

    public ConnectionSettingsBuilder tlsCaFile(String filepath) {
        this._tlsCaFile = filepath;
        return this;
    }

    public ConnectionSettingsBuilder features(String ... features) {
        this._features.addAll(Arrays.asList(features));
        return this;
    }

    public ConnectionSettingsBuilder feature(String feature) {
        this._features.add(feature);
        return this;
    }

    void parseGossipSeed(String host) {
        String[] hostParts = host.split(":");
        switch (hostParts.length) {
            case 1: {
                this.addHost(host, 2113);
                break;
            }
            case 2: {
                try {
                    this.addHost(hostParts[0], Short.parseShort(hostParts[1]));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(String.format("Invalid port number format: %s", hostParts[1]));
                }
            }
            default: {
                throw new RuntimeException(String.format("Invalid gossip seed format: %s", host));
            }
        }
    }

    static KurrentDBClientSettings parseFromUrl(ConnectionSettingsBuilder builder, URL url) {
        if (!SUPPORTED_PROTOCOLS.contains(url.getProtocol())) {
            throw new RuntimeException(String.format("Unknown URL scheme: %s", url.getProtocol()));
        }
        if (url.getProtocol().contains("esdb")) {
            logger.warn("The 'esdb' protocol is deprecated. Please use 'kurrentdb' instead.");
        }
        builder.dnsDiscover(url.getProtocol().endsWith("+discover"));
        if (url.getUserInfo() != null && !url.getUserInfo().isEmpty()) {
            String[] splits = url.getUserInfo().split(":", 2);
            if (splits.length > 1) {
                try {
                    builder.defaultCredentials(URLDecoder.decode(splits[0], "utf-8"), URLDecoder.decode(splits[1], "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                builder.defaultCredentials(splits[0], "");
            }
        }
        if (builder._hosts.isEmpty() && !url.getPath().isEmpty() && !url.getPath().equals("/")) {
            throw new RuntimeException(String.format("Unsupported URL path: %s", url.getPath()));
        }
        if (builder._hosts.isEmpty() && url.getHost().isEmpty()) {
            throw new RuntimeException("Connection string doesn't have an host");
        }
        if (builder._hosts.isEmpty()) {
            if (!url.getHost().contains(",")) {
                builder.addHost(url.getHost(), url.getPort() == -1 ? 2113 : url.getPort());
            } else {
                for (String hostPart : url.getHost().split(",")) {
                    builder.parseGossipSeed(hostPart);
                }
            }
        }
        if (url.getQuery() == null) {
            return builder.buildConnectionSettings();
        }
        String userCertFile = null;
        String userKeyFile = null;
        block59: for (String param : url.getQuery().split("&")) {
            String[] entry = param.split("=");
            if (entry.length <= 1) continue;
            String value = entry[1].toLowerCase();
            switch (entry[0].toLowerCase()) {
                case "nodepreference": {
                    switch (value) {
                        case "leader": {
                            builder._nodePreference = NodePreference.LEADER;
                            continue block59;
                        }
                        case "follower": {
                            builder._nodePreference = NodePreference.FOLLOWER;
                            continue block59;
                        }
                        case "readonlyreplica": {
                            builder._nodePreference = NodePreference.READ_ONLY_REPLICA;
                            continue block59;
                        }
                        case "random": {
                            builder._nodePreference = NodePreference.RANDOM;
                            continue block59;
                        }
                    }
                    throw new RuntimeException(String.format("Unsupported node preference '%s'", value));
                }
                case "maxdiscoverattempts": {
                    try {
                        int parsedValue = Integer.parseInt(value);
                        if (parsedValue < 0) {
                            ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                        }
                        builder._maxDiscoverAttempts = parsedValue;
                    }
                    catch (NumberFormatException e) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    continue block59;
                }
                case "discoveryinterval": {
                    try {
                        int parsedValue = Integer.parseInt(value);
                        if (parsedValue < 0) {
                            ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                        }
                        builder._discoveryInterval = parsedValue;
                    }
                    catch (NumberFormatException e) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    continue block59;
                }
                case "gossiptimeout": {
                    try {
                        int parsedValue = Integer.parseInt(value);
                        if (parsedValue < 0) {
                            ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                        }
                        builder._gossipTimeout = parsedValue;
                    }
                    catch (NumberFormatException e) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    continue block59;
                }
                case "dnsdiscover": {
                    if (!value.equals("true") && !value.equals("false")) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    builder._dnsDiscover = value.equals("true");
                    continue block59;
                }
                case "tls": {
                    if (!value.equals("true") && !value.equals("false")) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    builder._tls = value.equals("true");
                    continue block59;
                }
                case "tlsverifycert": {
                    if (!value.equals("true") && !value.equals("false")) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    builder._tlsVerifyCert = value.equals("true");
                    continue block59;
                }
                case "keepalivetimeout": {
                    try {
                        long parsedValue = Long.parseLong(value);
                        if (parsedValue >= 0L && parsedValue < Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS) {
                            logger.warn("Specified keepAliveTimeout of {} is less than recommended {}", (Object)parsedValue, (Object)Consts.DEFAULT_KEEP_ALIVE_TIMEOUT_IN_MS);
                        }
                        if (parsedValue < -1L) {
                            ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                        }
                        if (parsedValue == -1L) {
                            parsedValue = Long.MAX_VALUE;
                        }
                        builder._keepAliveTimeout = parsedValue;
                    }
                    catch (NumberFormatException e) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    continue block59;
                }
                case "keepaliveinterval": {
                    try {
                        long parsedValue = Long.parseLong(value);
                        if (parsedValue >= 0L && parsedValue < Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS) {
                            logger.warn("Specified keepAliveInterval of {} is less than recommended {}", (Object)parsedValue, (Object)Consts.DEFAULT_KEEP_ALIVE_INTERVAL_IN_MS);
                        }
                        if (parsedValue < -1L) {
                            ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                        }
                        if (parsedValue == -1L) {
                            parsedValue = Long.MAX_VALUE;
                        }
                        builder._keepAliveInterval = parsedValue;
                    }
                    catch (NumberFormatException e) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    continue block59;
                }
                case "defaultdeadline": {
                    try {
                        long parsedValue = Long.parseLong(value);
                        if (parsedValue <= 0L) {
                            ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                        }
                        builder._defaultDeadline = parsedValue;
                    }
                    catch (NumberFormatException e) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], value);
                    }
                    continue block59;
                }
                case "tlscafile": {
                    if (entry[1].isEmpty()) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], entry[1]);
                    }
                    builder._tlsCaFile = entry[1];
                    continue block59;
                }
                case "usercertfile": {
                    if (entry[1].isEmpty()) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], entry[1]);
                    }
                    userCertFile = entry[1];
                    continue block59;
                }
                case "userkeyfile": {
                    if (entry[1].isEmpty()) {
                        ConnectionSettingsBuilder.invalidParamFormat(entry[0], entry[1]);
                    }
                    userKeyFile = entry[1];
                    continue block59;
                }
                case "feature": {
                    builder._features.add(value);
                    continue block59;
                }
                default: {
                    logger.warn(String.format("Unknown setting '%s' is ignored", entry[0]));
                }
            }
        }
        if (userCertFile != null ^ userKeyFile != null) {
            throw new RuntimeException("Invalid user certificate settings. Both 'userCertFile' and 'userKeyFile' must be provided.");
        }
        if (userCertFile != null) {
            builder.defaultClientCertificate(userCertFile, userKeyFile);
        }
        return builder.buildConnectionSettings();
    }

    static void invalidParamFormat(String param, String value) {
        throw new RuntimeException(String.format("Invalid '%s' value format: '%s'", param, value));
    }
}

