/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.DeleteProjectionOptions;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.proto.projections.Projectionmanagement;
import io.kurrent.dbclient.proto.projections.ProjectionsGrpc;
import java.util.concurrent.CompletableFuture;

class DeleteProjection {
    private final GrpcClient client;
    private final String projectionName;
    private final DeleteProjectionOptions options;

    public DeleteProjection(GrpcClient client, String projectionName, DeleteProjectionOptions options) {
        this.client = client;
        this.projectionName = projectionName;
        this.options = options;
    }

    public CompletableFuture execute() {
        return this.client.run(channel -> {
            Projectionmanagement.DeleteReq.Options reqOptions = Projectionmanagement.DeleteReq.Options.newBuilder().setName(this.projectionName).setDeleteCheckpointStream(this.options.getDeleteCheckpointStream()).setDeleteEmittedStreams(this.options.getDeleteEmittedStreams()).setDeleteStateStream(this.options.getDeleteStateStream()).build();
            Projectionmanagement.DeleteReq request = Projectionmanagement.DeleteReq.newBuilder().setOptions(reqOptions).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            CompletableFuture result = new CompletableFuture();
            client.delete(request, (StreamObserver<Projectionmanagement.DeleteResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        });
    }
}

