/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.ClusterDiscovery;
import io.kurrent.dbclient.ConnectionService;
import io.kurrent.dbclient.Discovery;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.KurrentDBClientSettings;
import io.kurrent.dbclient.ServerVersion;
import io.kurrent.dbclient.SingleNodeDiscovery;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurrentDBClientBase {
    final Logger logger = LoggerFactory.getLogger(KurrentDBClientBase.class);
    private final GrpcClient client;

    KurrentDBClientBase(KurrentDBClientSettings settings) {
        Discovery discovery = settings.getHosts().length == 1 && !settings.isDnsDiscover() ? new SingleNodeDiscovery(settings.getHosts()[0]) : new ClusterDiscovery(settings);
        Security.addProvider((Provider)new BouncyCastleProvider());
        ConnectionService service = new ConnectionService(settings, discovery);
        this.client = service.getHandle();
        CompletableFuture.runAsync(service, this.createConnectionLoopExecutor());
    }

    private Executor createConnectionLoopExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r, "esdb-client-" + UUID.randomUUID());
            thread.setDaemon(true);
            return thread;
        });
    }

    public CompletableFuture<Void> shutdown() {
        return this.client.shutdown();
    }

    public boolean isShutdown() {
        return this.client.isShutdown();
    }

    public CompletableFuture<Optional<ServerVersion>> getServerVersion() {
        return this.client.getServerVersion();
    }

    GrpcClient getGrpcClient() {
        return this.client;
    }
}

