/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.ConnectionSettingsBuilder;
import io.kurrent.dbclient.KurrentDBClientSettings;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public final class KurrentDBConnectionString {
    KurrentDBConnectionString() {
    }

    public static KurrentDBClientSettings parseOrThrow(String connectionString) {
        ConnectionSettingsBuilder builder = KurrentDBClientSettings.builder();
        try {
            URL url = new URL(null, connectionString, new EsdbUrlHandler());
            return ConnectionSettingsBuilder.parseFromUrl(builder, url);
        }
        catch (MalformedURLException e) {
            if (!connectionString.contains(",")) {
                throw new RuntimeException(e);
            }
            try {
                URL url = new URL(null, connectionString.replaceAll(",", "/"), new EsdbUrlHandler());
                if (url.getHost().isEmpty()) {
                    throw new RuntimeException("Connection string doesn't have an host");
                }
                builder.addHost(url.getHost(), url.getPort() == -1 ? 2113 : url.getPort());
                for (String segment : url.getPath().split("/")) {
                    if (segment.isEmpty()) continue;
                    builder.parseGossipSeed(segment);
                }
                return ConnectionSettingsBuilder.parseFromUrl(builder, url);
            }
            catch (MalformedURLException ignored) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class EsdbUrlHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return null;
        }
    }
}

