/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import io.kurrent.dbclient.GrpcClient;
import io.kurrent.dbclient.GrpcUtils;
import io.kurrent.dbclient.HttpUtils;
import io.kurrent.dbclient.ListPersistentSubscriptionsOptions;
import io.kurrent.dbclient.PersistentSubscriptionInfo;
import io.kurrent.dbclient.UnsupportedFeatureException;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import io.kurrent.dbclient.proto.shared.Shared;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

final class ListPersistentSubscriptions {
    ListPersistentSubscriptions() {
    }

    public static <A> CompletableFuture<List<A>> execute(GrpcClient client, ListPersistentSubscriptionsOptions options, String stream, Function<PersistentSubscriptionInfo, A> func) {
        return client.runWithArgs(args -> {
            CompletableFuture result = new CompletableFuture();
            if (stream.equals("$all") && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeatureException());
                return result;
            }
            if (args.supportFeature(30)) {
                Persistent.ListReq.Options.Builder optionsBuilder = Persistent.ListReq.Options.newBuilder();
                if (stream.equals("")) {
                    optionsBuilder.setListAllSubscriptions(Shared.Empty.getDefaultInstance());
                } else if (stream.equals("$all")) {
                    optionsBuilder.setListForStream(Persistent.ListReq.StreamOption.newBuilder().setAll(Shared.Empty.getDefaultInstance()));
                } else {
                    optionsBuilder.setListForStream(Persistent.ListReq.StreamOption.newBuilder().setStream(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)stream))));
                }
                Persistent.ListReq req = Persistent.ListReq.newBuilder().setOptions(optionsBuilder).build();
                PersistentSubscriptionsGrpc.PersistentSubscriptionsStub stub = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), client.getSettings(), options);
                stub.list(req, (StreamObserver<Persistent.ListResp>)GrpcUtils.convertSingleResponse(result, resp -> {
                    ArrayList infos = new ArrayList();
                    for (Persistent.SubscriptionInfo wire : resp.getSubscriptionsList()) {
                        infos.add(func.apply(HttpUtils.parseInfoFromWire(wire)));
                    }
                    return infos;
                }));
            } else {
                String suffix = "";
                if (!stream.equals("")) {
                    suffix = String.format("/%s", HttpUtils.urlEncode(stream));
                }
                HttpURLConnection http = args.getHttpConnection(options, client.getSettings(), String.format("/subscriptions%s", suffix));
                try {
                    http.setRequestMethod("GET");
                    Exception error = HttpUtils.checkForError(http.getResponseCode());
                    if (error != null) {
                        result.completeExceptionally(error);
                    } else {
                        String content = HttpUtils.readContent(http);
                        ArrayList ps = new ArrayList();
                        for (JsonNode node : HttpUtils.getObjectMapper().readTree(content)) {
                            ps.add(func.apply(HttpUtils.parseSubscriptionInfo(node)));
                        }
                        result.complete(ps);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    http.disconnect();
                }
            }
            return result;
        });
    }
}

