/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.Position;
import io.kurrent.dbclient.RecordedEvent;
import io.kurrent.dbclient.proto.persistentsubscriptions.Persistent;
import io.kurrent.dbclient.proto.streams.StreamsOuterClass;
import java.util.Objects;
import java.util.Optional;

public class ResolvedEvent {
    private final RecordedEvent event;
    private final RecordedEvent link;
    private final Position position;

    public ResolvedEvent(RecordedEvent event, RecordedEvent link, Position position) {
        this.event = event;
        this.link = link;
        this.position = position;
    }

    public RecordedEvent getEvent() {
        return this.event;
    }

    public RecordedEvent getLink() {
        return this.link;
    }

    public RecordedEvent getOriginalEvent() {
        return this.link != null ? this.link : this.event;
    }

    public Optional<Position> getPosition() {
        return Optional.ofNullable(this.position);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedEvent that = (ResolvedEvent)o;
        return this.event.equals(that.event) && Objects.equals(this.link, that.link);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.link);
    }

    static ResolvedEvent fromWire(StreamsOuterClass.ReadResp.ReadEvent wireEvent) {
        RecordedEvent event = wireEvent.hasEvent() ? RecordedEvent.fromWire(wireEvent.getEvent()) : null;
        RecordedEvent link = wireEvent.hasLink() ? RecordedEvent.fromWire(wireEvent.getLink()) : null;
        Position position = wireEvent.hasNoPosition() ? null : new Position(wireEvent.getCommitPosition(), wireEvent.getCommitPosition());
        return new ResolvedEvent(event, link, position);
    }

    static ResolvedEvent fromWire(Persistent.ReadResp.ReadEvent wireEvent) {
        RecordedEvent event = wireEvent.hasEvent() ? RecordedEvent.fromWire(wireEvent.getEvent()) : null;
        RecordedEvent link = wireEvent.hasLink() ? RecordedEvent.fromWire(wireEvent.getLink()) : null;
        Position position = wireEvent.hasNoPosition() ? null : new Position(wireEvent.getCommitPosition(), wireEvent.getCommitPosition());
        return new ResolvedEvent(event, link, position);
    }

    public String toString() {
        return "ResolvedEvent{event=" + this.event + ", link=" + this.link + ", position=" + this.position + '}';
    }
}

