/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kurrent.dbclient.Acl;
import io.kurrent.dbclient.CustomAclCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StreamAcl
implements Acl {
    @JsonProperty(value="$r")
    @JsonSerialize(using=CustomAclCodec.ListSerializer.class)
    @JsonDeserialize(using=CustomAclCodec.ListDeserializer.class)
    private List<String> readRoles;
    @JsonProperty(value="$w")
    @JsonSerialize(using=CustomAclCodec.ListSerializer.class)
    @JsonDeserialize(using=CustomAclCodec.ListDeserializer.class)
    private List<String> writeRoles;
    @JsonProperty(value="$d")
    @JsonSerialize(using=CustomAclCodec.ListSerializer.class)
    @JsonDeserialize(using=CustomAclCodec.ListDeserializer.class)
    private List<String> deleteRoles;
    @JsonProperty(value="$mr")
    @JsonSerialize(using=CustomAclCodec.ListSerializer.class)
    @JsonDeserialize(using=CustomAclCodec.ListDeserializer.class)
    private List<String> metaReadRoles;
    @JsonProperty(value="$mw")
    @JsonSerialize(using=CustomAclCodec.ListSerializer.class)
    @JsonDeserialize(using=CustomAclCodec.ListDeserializer.class)
    private List<String> metaWriteRoles;

    public StreamAcl addReadRoles(String ... roles) {
        this.readRoles = this.readRoles == null ? new ArrayList() : this.readRoles;
        this.readRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addWriteRoles(String ... roles) {
        this.writeRoles = this.writeRoles == null ? new ArrayList() : this.writeRoles;
        this.writeRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addDeleteRoles(String ... roles) {
        this.deleteRoles = this.deleteRoles == null ? new ArrayList() : this.deleteRoles;
        this.deleteRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addMetaReadRoles(String ... roles) {
        this.metaReadRoles = this.metaReadRoles == null ? new ArrayList() : this.metaReadRoles;
        this.metaReadRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addMetaWriteRoles(String ... roles) {
        this.metaWriteRoles = this.metaWriteRoles == null ? new ArrayList() : this.metaWriteRoles;
        this.metaWriteRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public List<String> getReadRoles() {
        return this.readRoles;
    }

    public List<String> getWriteRoles() {
        return this.writeRoles;
    }

    public List<String> getDeleteRoles() {
        return this.deleteRoles;
    }

    public List<String> getMetaReadRoles() {
        return this.metaReadRoles;
    }

    public List<String> getMetaWriteRoles() {
        return this.metaWriteRoles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamAcl streamAcl = (StreamAcl)o;
        return Objects.equals(this.readRoles, streamAcl.readRoles) && Objects.equals(this.writeRoles, streamAcl.writeRoles) && Objects.equals(this.deleteRoles, streamAcl.deleteRoles) && Objects.equals(this.metaReadRoles, streamAcl.metaReadRoles) && Objects.equals(this.metaWriteRoles, streamAcl.metaWriteRoles);
    }

    public int hashCode() {
        return Objects.hash(this.readRoles, this.writeRoles, this.deleteRoles, this.metaReadRoles, this.metaWriteRoles);
    }

    public String toString() {
        return "StreamAcl{readRoles=" + this.readRoles + ", writeRoles=" + this.writeRoles + ", deleteRoles=" + this.deleteRoles + ", metaReadRoles=" + this.metaReadRoles + ", metaWriteRoles=" + this.metaWriteRoles + '}';
    }
}

