/*
 * Decompiled with CFR 0.152.
 */
package io.kurrent.dbclient;

import io.kurrent.dbclient.proto.shared.Shared;
import io.kurrent.dbclient.proto.streams.StreamsOuterClass;
import java.util.Objects;

public abstract class StreamState {
    public static StreamState any() {
        return new AnyStreamState();
    }

    public static StreamState noStream() {
        return new NoStreamState();
    }

    public static StreamState streamExists() {
        return new StreamExistsState();
    }

    public static StreamState streamRevision(long revision) {
        return new StreamRevisionStreamState(revision);
    }

    public static StreamState fromRawLong(long revision) {
        if (revision == -1L) {
            return StreamState.noStream();
        }
        if (revision == -2L) {
            return StreamState.any();
        }
        if (revision == -4L) {
            return StreamState.streamExists();
        }
        if (revision < 0L) {
            throw new RuntimeException(String.format("Invalid stream revision long representation '%s'", revision));
        }
        return StreamState.streamRevision(revision);
    }

    StreamState() {
    }

    abstract StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder var1);

    abstract StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder var1);

    abstract StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder var1);

    public long toRawLong() {
        if (this instanceof NoStreamState) {
            return -1L;
        }
        if (this instanceof AnyStreamState) {
            return -2L;
        }
        if (this instanceof StreamExistsState) {
            return -4L;
        }
        StreamRevisionStreamState revision = (StreamRevisionStreamState)this;
        return revision.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(this.getClass());
    }

    public static class StreamRevisionStreamState
    extends StreamState {
        final long version;

        StreamRevisionStreamState(long version) {
            this.version = version;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreamRevisionStreamState that = (StreamRevisionStreamState)o;
            return this.version == that.version;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.version);
        }

        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setRevision(this.version);
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setRevision(this.version);
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setRevision(this.version);
        }

        public String toString() {
            return Long.toString(this.version);
        }
    }

    public static class StreamExistsState
    extends StreamState {
        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setStreamExists(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setStreamExists(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setStreamExists(Shared.Empty.getDefaultInstance());
        }

        public String toString() {
            return "StreamExistsState";
        }
    }

    public static class AnyStreamState
    extends StreamState {
        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setAny(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setAny(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setAny(Shared.Empty.getDefaultInstance());
        }

        public String toString() {
            return "AnyStreamState";
        }
    }

    public static class NoStreamState
    extends StreamState {
        @Override
        public StreamsOuterClass.AppendReq.Options.Builder applyOnWire(StreamsOuterClass.AppendReq.Options.Builder options) {
            return options.setNoStream(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.DeleteReq.Options.Builder applyOnWire(StreamsOuterClass.DeleteReq.Options.Builder options) {
            return options.setNoStream(Shared.Empty.getDefaultInstance());
        }

        @Override
        public StreamsOuterClass.TombstoneReq.Options.Builder applyOnWire(StreamsOuterClass.TombstoneReq.Options.Builder options) {
            return options.setNoStream(Shared.Empty.getDefaultInstance());
        }

        public String toString() {
            return "NoStreamState";
        }
    }
}

